<?php
/**
 * The Template for displaying all single posts.
*/
get_header();
?>

<?php
$singlelayout = '';
if ( class_exists( 'ReduxFramework' ) ) {
    if ( isset( $_REQUEST['single-sb'] ) ) {
        $singlelayout = esc_attr(sanitize_text_field( $_REQUEST['single-sb']) );
    }else {
        $singlelayout = esc_attr(news247_theme_options('single_layout'));
    }
}
$singlestyles = '';
if ( class_exists( 'ReduxFramework' ) ) {
    if ( isset( $_REQUEST['single-lt'] ) ) {
        $singlestyles = esc_attr(sanitize_text_field( $_REQUEST['single-lt']) );
    }else {
        $singlestyles = esc_attr( news247_theme_options('single_style_blog'));
    }
}

?>

<div class="main-content">
	<div class="container">
	    <?php if ( news247_theme_options('breadcrumb_en') ) { ?>
	      <?php news247_theme_breadcrumb() ;?>
	    <?php } ?>
		<div class="main-content-wrap <?php echo esc_attr($singlelayout);?>">
			<?php if ( ($singlestyles == 'single_style3') || ($singlestyles == 'single_style4') ) { ?>
			<article id="post-<?php the_ID(); ?>" <?php post_class('post-layout'); ?>>
				<?php get_template_part( 'includes/single-entry-blog3' ); ?>
			</article><!-- #post-## -->
			<?php } ?>
			<div class="row justify-content-center">
			<?php if ($singlelayout == 'blogSingleRight'){ ?>
                <?php if ( is_active_sidebar( 'sidebar' ) ) { ?>
                <div id="content" class="col-lg-8 col-md-8 col-sm-12">
                <?php } else { ?>
                    <div id="content" class="col-lg-12 col-md-12 col-sm-12">
                <?php } ?>
					<div class="main-content-inner clearfix">
					<?php while ( have_posts() ) : the_post(); ?>
						<?php get_template_part( 'content-single'); ?>

					    <?php
					    if ( is_singular() ) {
					        $key = "_post_views_count";
					        $id = $post->ID;
					        $postview = get_post_meta( $id, $key,true);

					        if($postview == ''){
					            $postview = 0;
					            add_post_meta( $id, $key, 0);
					        }
					        else{
					            $postview = (int)$postview+1;
					            update_post_meta( $id, $key, $postview);
					        }
					    }
					    ?>
					<?php endwhile; // end of the loop. ?>
				</div> <!-- close .main-content-inner -->
			</div> <!-- close .main-content-inner -->
			<?php get_sidebar(); ?>

		<?php } elseif ($singlelayout == 'blogSingleLeft'){ ?>
				<?php get_sidebar(); ?>
                <?php if ( is_active_sidebar( 'sidebar' ) ) { ?>
                <div id="content" class="col-lg-8 col-md-8 col-sm-12">
                <?php } else { ?>
                    <div id="content" class="col-lg-12 col-md-12 col-sm-12">
                <?php } ?>
					<div class="main-content-inner clearfix">
					<?php while ( have_posts() ) : the_post(); ?>

						<?php get_template_part( 'content-single'); ?>
					    <?php
					    if ( is_singular() ) {
					        $key = "_post_views_count";
					        $id = $post->ID;
					        $postview = get_post_meta( $id, $key,true);

					        if($postview == ''){
					            $postview = 0;
					            add_post_meta( $id, $key, 0);
					        }
					        else{
					            $postview = (int)$postview+1;
					            update_post_meta( $id, $key, $postview);
					        }
					    }

					    ?>
					<?php endwhile; // end of the loop. ?>
				</div> <!-- close .main-content-inner -->
			</div> <!-- close .main-content-inner -->

		<?php } elseif ($singlelayout == 'SingleFullwidth') { ?>
				<div id="content" class="col-md-10 col-sm-10">
					<div class="main-content-inner clearfix">
					<?php while ( have_posts() ) : the_post(); ?>

						<?php get_template_part( 'content-single'); ?>

					    <?php

					    if ( is_singular() ) {
					        $key = "_post_views_count";
					        $id = $post->ID;
					        $postview = get_post_meta( $id, $key,true);

					        if($postview == ''){
					            $postview = 0;
					            add_post_meta( $id, $key, 0);
					        }
					        else{
					            $postview = (int)$postview+1;
					            update_post_meta( $id, $key, $postview);
					        }
					    }

					    ?>
					<?php endwhile; // end of the loop. ?>
				</div> <!-- close .main-content-inner -->
			</div> <!-- close .main-content-inner -->
		<?php } else { ?>
            <?php if ( is_active_sidebar( 'sidebar' ) ) { ?>
                <div id="content" class="col-lg-8 col-md-8 col-sm-12">
                <?php } else { ?>
                    <div id="content" class="col-lg-12 col-md-12 col-sm-12">
                <?php } ?>
					<div class="main-content-inner clearfix">
					<?php while ( have_posts() ) : the_post(); ?>

						<?php get_template_part( 'content-single'); ?>


					    <?php

					    if ( is_singular() ) {
					        $key = "_post_views_count";
					        $id = $post->ID;
					        $postview = get_post_meta( $id, $key,true);

					        if($postview == ''){
					            $postview = 0;
					            add_post_meta( $id, $key, 0);
					        }
					        else{
					            $postview = (int)$postview+1;
					            update_post_meta( $id, $key, $postview);
					        }
					    }

					    ?>

					<?php endwhile; // end of the loop. ?>
				</div> <!-- close .main-content-inner -->
			</div> <!-- close .main-content-inner -->
			<?php get_sidebar(); ?>
		<?php }?>
		</div> <!--/.row-->
	</div><!-- /.main-content-wrap -->
</div><!-- /.container -->
<?php get_footer(); ?>