<?php
/**
* Template Name: Blog With Right sidebar
*/
get_header();?>

<div class="main-content">
    <div class="container">
        <?php if ( news247_theme_options('breadcrumb_en') ) { ?>
          <?php news247_theme_breadcrumb() ;?>
        <?php } ?>
        <div class="main-content-wrap">
            <div class="row">
                <div id="content" class="col-lg-8 col-md-8 col-sm-12">
                    <div class="main-content-inner row">
                        <?php
                        global $paged, $wp_query, $wp;

                        if  ( empty($paged) ) {
                            if ( !empty( $_GET['paged'] ) ) {
                                $paged = sanitize_text_field($_GET['paged']);

                            } elseif ( !empty($wp->matched_query) && $args = wp_parse_args($wp->matched_query) ) {

                                if ( !empty( $args['paged'] ) ) {
                                    $paged = $args['paged'];
                                    }
                            }

                            if ( !empty($paged) )
                                $wp_query->set('paged', $paged);
                        }

                        $temp = $wp_query;
                        $wp_query= null;

                        $wp_query = new WP_Query();
                        $wp_query->query("post_type=post&paged=".$paged );

                        if ( have_posts() ) :
                            $index = 0;
                        while ( have_posts() ) : the_post();
                            get_template_part( 'content', get_post_format() );
                            $index ++;
                        endwhile;
                        wp_reset_postdata();
                        else:
                             get_template_part( 'no-results', 'index' );
                        endif;
                        ?>
                </div> <!--/.main-content-inner-->
                <?php get_template_part('includes/main/paginationdisplay'); ?>
            </div> <!-- close .col-sm-9 -->
            <?php get_sidebar(); ?>
        </div><!--/.row -->
        </div><!-- /.main-content-wrap -->
    </div><!-- /.container -->
<?php get_footer();