<?php
function news247_import_files() {
  return array(
    array(
      'import_file_name'           => 'Demo Import Data',
      'import_file_url'            => 'http://demo.themewinter.com/wp/demo-content/news247/demo-content.xml',
      'import_widget_file_url'     => 'http://demo.themewinter.com/wp/demo-content/news247/widgets.wie',
      'import_redux'               => array(
        array(
          'file_url'    => 'http://demo.themewinter.com/wp/demo-content/news247/theme-options.json',
          'option_name' => 'news247_options',
        ),
      )
    )
  );
}

add_filter( 'pt-ocdi/import_files', 'news247_import_files' );

function news247_after_import_setup() {
  // Assign menus to their locations.
  $main_menu = get_term_by( 'name', 'Main Menu', 'nav_menu' );

  set_theme_mod( 'nav_menu_locations', array(
      'primary' => $main_menu->term_id,
    )
  );

  // Assign front page and posts page (blog page).
  $front_page_id = get_page_by_title( 'Home' );
  $blog_page_id  = get_page_by_title( 'Blog Right Sidebar' );

  update_option( 'show_on_front', 'page' );
  update_option( 'page_on_front', $front_page_id->ID );
  update_option( 'page_for_posts', $blog_page_id->ID );

}
add_action( 'pt-ocdi/after_import', 'news247_after_import_setup' );

