<?php

//google font
if(!function_exists('news247_google_fonts_url')){
    function news247_google_fonts_url() {
    $fonts_url = '';
    $opensans = _x( 'on', 'Open Sans font: on or off', 'news247' );
    $arimo = _x( 'on', 'Arimo font: on or off', 'news247' );

    if ( 'off' !== $opensans || 'off' !== $arimo ) {
        $font_families = array();

        if ( 'off' !== $opensans ) {
        $font_families[] = 'Open+Sans:300,400,600,700';
        }

        if ( 'off' !== $arimo ) {
        $font_families[] = 'Arimo:400,700';
        }

        $query_args = array(
        'family' => urlencode( implode( '|', $font_families ) ),
        'subset' => urlencode( 'latin,latin-ext' ),
        );
        $fonts_url = add_query_arg( $query_args, 'https://fonts.googleapis.com/css' );
    }

    return $fonts_url;
    }
}

if ( ! function_exists( 'news247_theme_scripts' ) ) :
function news247_theme_scripts() {
     //google font
    wp_enqueue_style( 'google-fonts', news247_google_fonts_url(), array(), null );
    // Register Styles
    wp_enqueue_style( 'bootstrap', get_template_directory_uri() . '/css/bootstrap.min.css',false,'all');
    wp_enqueue_style( 'font-awesome', get_template_directory_uri() . '/css/font-awesome.min.css',false,'all');
    wp_enqueue_style( 'news247-wp', get_template_directory_uri() . '/css/bootstrap-wp.css',false,'all');
    wp_enqueue_style( 'magnific-popup', get_template_directory_uri() . '/css/magnific-popup.css',false,'all');
    wp_enqueue_style( 'owl.theme.default', get_template_directory_uri() . '/css/owl.theme.default.css',false,'all');
    wp_enqueue_style( 'lightbox', get_template_directory_uri() . '/css/lightbox.css',false,'all');
    wp_enqueue_style( 'news247-style', get_stylesheet_uri() );
    wp_add_inline_style( 'news247-style', news247_css_generator() );
    wp_enqueue_style( 'news247-responsive', get_template_directory_uri() . '/css/responsive.css',false,'all');
    wp_enqueue_style( 'news247-gutenberg-editor-styles', get_template_directory_uri() . '/css/gutenberg-custom.css', null, 'all' );

    // Register Scripts
    wp_enqueue_script( 'popper', NEWS247_URI . '/js/popper.min.js', array('jquery'), true);
    wp_enqueue_script('bootstrap', NEWS247_URI .'/js/bootstrap.min.js', array('jquery'), 'v4.0.0-beta', true );
    wp_enqueue_script( 'bootstrapwp', NEWS247_URI . '/js/bootstrap-wp.js', array('jquery'), true);
    wp_enqueue_script( 'jquery-magnific-popup', NEWS247_URI . '/js/jquery.magnific-popup.min.js', array('jquery'), 'v1.1.0', true);
    wp_enqueue_script( 'theia-sticky-sidebar', NEWS247_URI . '/js/theia-sticky-sidebar.js', array('jquery'), 'v1.3.0', true );
    wp_enqueue_script('news247-custom', NEWS247_URI .'/js/custom.js', array('jquery'), true);
    wp_localize_script( 'news247-custom', 'news247_ajax', array( 'ajax_url' => admin_url( 'admin-ajax.php' ) ) );
    wp_enqueue_script( 'sharethis', '//platform-api.sharethis.com/js/sharethis.js#property=5979503d1a124400114e5599&product=inline-share-buttons', array(), '',false,true );
    if ( is_singular() && comments_open() && get_option( 'thread_comments' ) ) {
        wp_enqueue_script( 'comment-reply' );
    }

}
add_action( 'wp_enqueue_scripts', 'news247_theme_scripts' );
endif;

require_once get_template_directory() . '/includes/main/preset.php';



//Gutenberg enqueue
add_action('enqueue_block_editor_assets', 'news247_action_enqueue_block_editor_assets' );
function news247_action_enqueue_block_editor_assets() {
    wp_enqueue_style( 'google-fonts', news247_google_fonts_url(), array(), null );
    wp_enqueue_style( 'news247-gutenberg-editor-font-awesome-styles', get_template_directory_uri() . '/css/font-awesome.min.css', null, 'all' );
    wp_enqueue_style( 'news247-style', get_stylesheet_uri() );
    wp_enqueue_style( 'news247-gutenberg-editor-customizer-styles', get_template_directory_uri() . '/css/gutenberg-editor-custom.css', null, 'all' );
    wp_enqueue_style( 'news247-gutenberg-editor-styles', get_template_directory_uri() . '/css/gutenberg-custom.css', null, 'all' );
}
