<?php

if(!function_exists('news247_css_generator')){
    function news247_css_generator(){

        $output = '';

        if ( esc_attr(news247_theme_options('sticky_menu')) ){
            $output .= '.thw-menubar-wrap.sticky-header {padding:0;  z-index: 99999;position: fixed;
          width: 100%;top: 0;-webkit-backface-visibility: hidden;box-shadow: 0 1px 5px rgba(0, 0, 0, 0.1);-webkit-box-shadow: 0 1px 5px rgba(0, 0, 0, 0.1);}';
            $output .= '.admin-bar .thw-menubar-wrap.sticky-header {top: 32px;}';
        }

        if ( news247_theme_options('menu_align') ) {
            $menu_align = esc_attr(news247_theme_options('menu_align'));
            switch ($menu_align) {

                case 'left':
                    $output .= '.site-nav-inner{text-align:left;}';
                break;

                case 'center':
                    $output .= '.site-nav-inner{text-align:center;}';
                break;

                case 'right':
                    $output .= '.site-nav-inner{text-align:right;}';
                break;

                default:
                    $output .= '.site-nav-inner{text-align:left;}';
                break;
            }
        } else {
            $output .= '.site-nav-inner{text-align:left;}';
        }


            $logo_align = '';
            if ( news247_theme_options('logo_align') ){
                if ( isset( $_REQUEST['logo-ps'] ) ) {
                    $logo_align = esc_attr(sanitize_text_field( $_REQUEST['logo-ps']) );
                }else {
                    $logo_align = esc_attr(news247_theme_options('logo_align'));
                }
            } else {
                $logo_align = 'left';
            }
            switch ($logo_align) {

                case 'left':
                    $output .= '.logo-header-inner{text-align:left;}';
                break;

                case 'center':
                    $output .= '.logo-header-inner{text-align:center;}';
                break;

                case 'right':
                    $output .= '.logo-header-inner{text-align:right;}';
                break;

                default:
                    $output .= '.logo-header-inner{text-align:left;}';
                break;
            }


        //major color
        if ( news247_theme_options('link_color') ) {

            $linkcolor = esc_attr(news247_theme_options('link_color'));
            if(isset($linkcolor)){
                $output .= 'a, a:visited, a:focus,.topbar .top-menu li a:hover,
                ul.main-menu>li:hover>a,
                ul.main-menu li ul li:hover > a,.navbar-header .navbar-toggle .menu-text:hover,
                .nav-solid ul.navbar-nav > li:hover > a, .nav-solid ul.navbar-nav > li.active > a,
                .blog-entry-footer a:hover,.blog-share-button ul li a:hover,.copyright-info i,
                .widget ul.nav>li>a:hover,.post-meta span i,.more-link:hover, .social-icons a:hover,
                .entry-header .page-title a:hover,.post-navigation span:hover,.post-navigation h3:hover,
                .authors-social a:hover,.related-item-content .border-overlay-content .post-cat a,
                .related-post .entry-title a:hover,.related-post .post-cat a:hover,
                .recent-posts .post-info .entry-title a:hover,
                .sidebar .widget_categories ul.nav  li:hover a,.sidebar .widget_archive ul li:hover a,
                .sidebar .widget_pages  ul li:hover a,.sidebar .widget_meta  ul li:hover a,
                .sidebar .widget_recent_comments  ul li:hover a,.sidebar .widget_recent_entries  ul li:hover a,
                .border-overlay-content .entry-title a:hover,
                .border-overlay-content .post-cat a:hover,.slider-content .post-cat a:hover,
                .slider-content .entry-title a:hover,.top-social li a:hover,
                .header .top-social li a:hover,.blog-header h2.page-title a:hover,
                a.more-link,.entry-meta .entry-meta-list i,.entry-comment a:hover,
                .social-button li a:hover,.nav-search:hover,.promo-center-content h3:hover a,
                .entry-post-meta .publish-date a:hover,
                #responsive-menu ul li a:hover,.owl-theme .owl-nav .owl-prev,.owl-theme .owl-nav .owl-next,
                .box-slider-meta .comment a:hover,.box-slider-meta .author a:hover,
                .most-meta-category a,.most-view-item-content .entry-title a:hover,
                .editor-meta-category a:hover,.ediotr-grid-content .entry-title a:hover,
                .editor-box-meta .author a:hover,.entry-blog .entry-post-title a:hover,
                .entry-post-footer-wrap a.readmore-blog:hover,

                .woocommerce ul.products li.product .woocommerce-loop-product__title:hover,

                .entry-post-footer-wrap span a:hover,.recent-posts-widget .post-info .entry-title a:hover,
                .recent-posts-widget .post-info .post-title a:hover,
                .editor-item-content-info h4 a:hover,ul.main-menu li > ul li.current-menu-parent > a,
                ul.main-menu > li.current-menu-ancestor > a,.footerbottom-widget .social-button-widget li a i:hover,
                .post-block-style .post-title a:hover,#wp-megamenu-primary > .wpmm-nav-wrap ul.wp-megamenu > li ul.wp-megamenu-sub-menu li
                .wpmm-vertical-tabs-nav ul li.active a,.topbar-nav li a:hover,
                .trending-bar.tickerbelowmenu .post-title a:hover{ color:'. esc_attr($linkcolor) .'; }';

                $output .= '.category-meta-bg a:hover:before{ border-top-color:'. esc_attr($linkcolor) .'; }';
                $output .= '#wp-megamenu-primary > .wpmm-nav-wrap .wp-megamenu >li > ul.wp-megamenu-sub-menu li.wpmm-type-widget > a:after{ border-bottom: 2px solid '. esc_attr($linkcolor) .'; }';

                $output .= '#header-trigger:hover .icon-bar,
                .thw-offcanvas .nano > .nano-pane > .nano-slider,
                .navbar-header .navbar-toggle:hover .icon-bar,
                .sidebar .widget-title:before,
                .widget.widget_tag_cloud .tagcloud a:hover,.btn-newsletter input[type=submit],
                .slider-content.boxed .post-cat a,.slider-content.boxed .post-cat:before,
                .box-slider .owl-nav > div:hover,.owl-merge .owl-nav > div:hover,
                .column-slider .owl-nav > div:hover,.post-meta-category a,
                .home_page5 .main-content-inner .post-layout .post-meta-category a:hover,
                .entry-image .quote-link,
                .btn-primary,a.btn-primary,.myblog-newsltter input[type=submit],
                button, input[type=button], input[type=reset], input[type=submit],
                .wpcf7-form-control.wpcf7-submit,.paging-navigation .post-nav li>a,
                .paging-navigation .post-nav  li>span,.slider-layout-cats a:hover,
                .box-slider.owl-theme .owl-dots .owl-dot span,
                .slider-layout3-item-inner .slider-layout3-btn a:hover,.comment-navigation .nav-previous a,
                .comment-navigation .nav-next a,.blog-entry-summary .page-links span,
                .post-pagination ul li a:hover,.post-pagination ul li span.current,#post-loading-button:hover,
                .latest-cats.random-clor-cats a,#post-loading-button,.owl-theme .owl-nav .owl-prev:hover,.owl-theme .owl-nav .owl-next:hover,
                .owl-theme .owl-dots .owl-dot.active span, .owl-theme .owl-dots .owl-dot:hover span,
                .search-newsletter .newsletter-subscribe a:hover,.footer-widget .widget-title:after,
                .meta-category.feature-cats a,.editor-item-content .most-meta-category a,
                .sidebar .widget-title:after,.category-meta-bg a:hover,

                    .woocommerce ul.products li.product .button,.woocommerce ul.products li.product .added_to_cart,
                    .woocommerce nav.woocommerce-pagination ul li a:focus, .woocommerce nav.woocommerce-pagination ul li a:hover, .woocommerce nav.woocommerce-pagination ul li span.current,
                    .woocommerce #respond input#submit.alt, .woocommerce a.button.alt, .woocommerce button.button.alt, .woocommerce input.button.alt,
                    .woocommerce #respond input#submit, .woocommerce a.button, .woocommerce button.button, .woocommerce input.button,

                    .entry-content a.readmore-blog,.ts-common-nav,.tp-control a,
                    .recent-posts-widget .posts-thumb .category-meta-bg a:hover,
.recent-posts-widget .post-info-full .category-meta-bg a:hover,
.single-entry-blog3 .category-meta-bg a:hover,.trending-title,.pb-common-nav:hover,.ps-common-nav:hover,
.menubelow.menudarkstyle #wp-megamenu-primary > .wpmm-nav-wrap ul.wp-megamenu > li.current-menu-ancestor,
.menubelow.menudarkstyle #wp-megamenu-primary > .wpmm-nav-wrap ul.wp-megamenu > li:hover,
.menu-menuwithlogodark #wp-megamenu-primary >
.wpmm-nav-wrap ul.wp-megamenu > li.current-menu-ancestor > a,
.menu-menuwithlogodark #wp-megamenu-primary >
.wpmm-nav-wrap ul.wp-megamenu > li:hover > a,#back-to-top .btn.btn-primary:hover,blockquote:before{ background-color:'. esc_attr($linkcolor) .'; }';

                $output .= '.latest-course-control a:hover,
                a.slider-layout-btn:hover,.slider-layout3-item-inner .slider-layout3-btn a:hover { border-color:'. esc_attr($linkcolor) .'; }';
                $output .= '.menubelow .thw-menubar > .row,
                .thw-menubar-wrap.menuabove{border-top:  3px solid '. esc_attr($linkcolor) .'; }';
                $output .= '.trending-title:before{border-top:  7px solid '. esc_attr($linkcolor) .'; }';
                $output .= '#home-search{border-top: 2px solid '. esc_attr($linkcolor) .'; }';
                $output .= 'ul.main-menu>li:hover>a:before,ul.main-menu>li.current-menu-item>a:before,
                #wp-megamenu-primary > .wpmm-nav-wrap ul.wp-megamenu > li.current-menu-ancestor > a:before,
                #wp-megamenu-primary > .wpmm-nav-wrap ul.wp-megamenu > li.current-menu-item > a:before,
                #wp-megamenu-primary > .wpmm-nav-wrap ul.wp-megamenu > li:hover > a:before{border-color: '. esc_attr($linkcolor) .'; }';
            }

        } else {
            $output .= 'a, a:visited, a:focus,.topbar .top-menu li a:hover,
                ul.main-menu>li:hover>a,
                ul.main-menu li ul li:hover > a,.navbar-header .navbar-toggle .menu-text:hover,
                .nav-solid ul.navbar-nav > li:hover > a, .nav-solid ul.navbar-nav > li.active > a,
                .blog-entry-footer a:hover,.blog-share-button ul li a:hover,.copyright-info i,
                .widget ul.nav>li>a:hover,.post-meta span i,.more-link:hover, .social-icons a:hover,
                .entry-header .page-title a:hover,.post-navigation span:hover,.post-navigation h3:hover,
                .authors-social a:hover,.related-item-content .border-overlay-content .post-cat a,
                .related-post .entry-title a:hover,.comment-notes span.required,.related-post .post-cat a:hover,
                .recent-posts .post-info .entry-title a:hover,.comment-form label .required,
                .sidebar .widget_categories ul.nav  li:hover a,.sidebar .widget_archive ul li:hover a,
                .sidebar .widget_pages  ul li:hover a,.sidebar .widget_meta  ul li:hover a,
                .sidebar .widget_recent_comments  ul li:hover a,.sidebar .widget_recent_entries  ul li:hover a,
                .border-overlay-content .entry-title a:hover,
                .border-overlay-content .post-cat a:hover,.slider-content .post-cat a:hover,
                .slider-content .entry-title a:hover,.top-social li a:hover,
                .header .top-social li a:hover,.blog-header h2.page-title a:hover,
                a.more-link,.entry-meta .entry-meta-list i,.entry-comment a:hover,
                .social-button li a:hover,.nav-search:hover,.promo-center-content h3:hover a,
                .entry-post-meta .publish-date a:hover,
                #responsive-menu ul li a:hover,.owl-theme .owl-nav .owl-prev,.owl-theme .owl-nav .owl-next,
                .box-slider-meta .comment a:hover,.box-slider-meta .author a:hover,
                .most-meta-category a,.most-view-item-content .entry-title a:hover,
                .editor-meta-category a:hover,.ediotr-grid-content .entry-title a:hover,
                .editor-box-meta .author a:hover,.entry-blog .entry-post-title a:hover,
                .entry-post-footer-wrap a.readmore-blog:hover,

                .woocommerce ul.products li.product .woocommerce-loop-product__title:hover,

                .entry-post-footer-wrap span a:hover,.recent-posts-widget .post-info .entry-title a:hover{ color:#ec0000; }

                .category-meta-bg a:hover:before{ border-top: 8px solid #ec0000; }

                #header-trigger:hover .icon-bar,
                .thw-offcanvas .nano > .nano-pane > .nano-slider,
                .navbar-header .navbar-toggle:hover .icon-bar,
                .sidebar .widget-title:before,
                .widget.widget_tag_cloud .tagcloud a:hover,.btn-newsletter input[type=submit],
                .slider-content.boxed .post-cat a,.slider-content.boxed .post-cat:before,
                .box-slider .owl-nav > div:hover,.owl-merge .owl-nav > div:hover,
                .column-slider .owl-nav > div:hover,.post-meta-category a,
                .home_page5 .main-content-inner .post-layout .post-meta-category a:hover,
                .entry-image .quote-link,
                .btn-primary,a.btn-primary,.myblog-newsltter input[type=submit],
                button, input[type=button], input[type=reset], input[type=submit],
                .wpcf7-form-control.wpcf7-submit,.paging-navigation .post-nav li>a,
                .paging-navigation .post-nav  li>span,.slider-layout-cats a:hover,
                .box-slider.owl-theme .owl-dots .owl-dot span,
                .slider-layout3-item-inner .slider-layout3-btn a:hover,.comment-navigation .nav-previous a,
                .comment-navigation .nav-next a,.blog-entry-summary .page-links span,
                .post-pagination ul li a:hover,.post-pagination ul li span.current,#post-loading-button:hover,
                .latest-cats.random-clor-cats a,#post-loading-button,.owl-theme .owl-nav .owl-prev:hover,.owl-theme .owl-nav .owl-next:hover,
                .owl-theme .owl-dots .owl-dot.active span, .owl-theme .owl-dots .owl-dot:hover span,
                .search-newsletter .newsletter-subscribe a:hover,.footer-widget .widget-title:after,
                .meta-category.feature-cats a,.editor-item-content .most-meta-category a,
                .sidebar .widget-title:after,.category-meta-bg a:hover,

                    .woocommerce ul.products li.product .button,.woocommerce ul.products li.product .added_to_cart,
                    .woocommerce nav.woocommerce-pagination ul li a:focus, .woocommerce nav.woocommerce-pagination ul li a:hover, .woocommerce nav.woocommerce-pagination ul li span.current,
                    .woocommerce #respond input#submit.alt, .woocommerce a.button.alt, .woocommerce button.button.alt, .woocommerce input.button.alt,
                    .woocommerce #respond input#submit, .woocommerce a.button, .woocommerce button.button, .woocommerce input.button,

                    .entry-content a.readmore-blog,.ts-common-nav,.tp-control a{ background-color:#ec0000; }

                .latest-course-control a:hover,
                a.slider-layout-btn:hover,.slider-layout3-item-inner .slider-layout3-btn a:hover { border-color:#ec0000; }

            .slider-content-meta a:hover,.post-meta-author a:hover,
            .copyright-info a:hover { color: #ec0000 !important;}
            .latest-course-control a:hover,a.slider-layout-btn:hover{ border-color:  #ec0000; }
            ';
        }

        if ( news247_theme_options('hover_color') ) {
            $hovercolor = esc_attr(news247_theme_options('hover_color'));
            if(isset($hovercolor)){
                $output .= 'a:hover,a.more-link,.most-meta-category a:hover{ color:'. esc_attr($hovercolor) .'; }';
              $output .= '.form-submit .btn.btn-primary:hover,.post-meta-category a:hover,
              a.btn-primary:hover,.btn-primary:hover,.myblog-newsltter input[type=submit]:hover,
                button, input[type=button]:hover, input[type=reset]:hover,
                input[type=submit]:hover,.wpcf7-form-control.wpcf7-submit:hover,
                .paging-navigation .post-nav li>a:hover, .paging-navigation .post-nav  li>span:hover,
                .comment-navigation .nav-previous a:hover,
                .comment-navigation .nav-next a:hover,
                #post-loading-button:hover,.latest-cats.random-clor-cats a:hover,
                .meta-category.feature-cats a:hover,.editor-item-content .most-meta-category a:hover,
                .category-meta-bg a:hover,

                            .woocommerce ul.products li.product .button:hover,
                    .woocommerce ul.products li.product .added_to_cart:hover,
                    .woocommerce #respond input#submit.alt:hover, .woocommerce a.button.alt:hover, .woocommerce button.button.alt:hover, .woocommerce input.button.alt:hover,
                    .woocommerce #respond input#submit:hover, .woocommerce a.button:hover, .woocommerce button.button:hover, .woocommerce input.button:hover,

                    .entry-content a.readmore-blog:hover,.ts-common-nav:hover,.tp-control a:hover{ background-color:'. esc_attr($hovercolor) .'; }';
            } else {
                $output .= 'a:hover,a.more-link,.most-meta-category a:hover{ color:#d70000; }
                .form-submit .btn.btn-primary:hover,.post-meta-category a:hover,
              a.btn-primary:hover,.btn-primary:hover,.myblog-newsltter input[type=submit]:hover,
                button, input[type=button]:hover, input[type=reset]:hover,
                input[type=submit]:hover,.wpcf7-form-control.wpcf7-submit:hover,
                .paging-navigation .post-nav li>a:hover, .paging-navigation .post-nav  li>span:hover,
                .comment-navigation .nav-previous a:hover,
                .comment-navigation .nav-next a:hover,
                #post-loading-button:hover,.latest-cats.random-clor-cats a:hover,
                .meta-category.feature-cats a:hover,.editor-item-content .most-meta-category a:hover,
                .category-meta-bg a:hover,

                .woocommerce ul.products li.product .button:hover,
                    .woocommerce ul.products li.product .added_to_cart:hover,
                    .woocommerce #respond input#submit.alt:hover, .woocommerce a.button.alt:hover, .woocommerce button.button.alt:hover, .woocommerce input.button.alt:hover,
                    .woocommerce #respond input#submit:hover, .woocommerce a.button:hover, .woocommerce button.button:hover, .woocommerce input.button:hover,

                    .entry-content a.readmore-blog:hover,.ts-common-nav:hover,.tp-control a:hover{ background-color:#d70000; }';
            }
        } else {
            $output .= 'a:hover,a.more-link,.most-meta-category a:hover{ color:#d70000; }
                .form-submit .btn.btn-primary:hover,.post-meta-category a:hover,
              a.btn-primary:hover,.btn-primary:hover,.myblog-newsltter input[type=submit]:hover,
                button, input[type=button]:hover, input[type=reset]:hover,
                input[type=submit]:hover,.wpcf7-form-control.wpcf7-submit:hover,
                .paging-navigation .post-nav li>a:hover, .paging-navigation .post-nav  li>span:hover,
                .comment-navigation .nav-previous a:hover,
                .comment-navigation .nav-next a:hover,
                #post-loading-button:hover,.latest-cats.random-clor-cats a:hover,
                .meta-category.feature-cats a:hover,.editor-item-content .most-meta-category a:hover,
                .category-meta-bg a:hover,

                .woocommerce ul.products li.product .button:hover,
                    .woocommerce ul.products li.product .added_to_cart:hover,
                    .woocommerce #respond input#submit.alt:hover, .woocommerce a.button.alt:hover, .woocommerce button.button.alt:hover, .woocommerce input.button.alt:hover,
                    .woocommerce #respond input#submit:hover, .woocommerce a.button:hover, .woocommerce button.button:hover, .woocommerce input.button:hover,

                    .entry-content a.readmore-blog:hover,.ts-common-nav:hover,.tp-control a:hover{ background-color:#d70000; }';
        }
        if ( news247_theme_options('menu_bg') ) {
            $menubg = esc_attr(news247_theme_options('menu_bg'));
            if(isset($menubg)){
                $output .= '.thw-menubar-wrap{ background:'. esc_attr($menubg) .'; }';
            }
        }else {
            $output .= '.thw-menubar-wrap{ background:#fff; }';
        }

        if ( news247_theme_options('topbar_color') ) {
            $topbar_color = esc_attr(news247_theme_options('topbar_color'));
            if(isset($topbar_color)){
                $output .= '.tsnews-date, .top-menu li a,.social-button li a{ color:'. esc_attr($topbar_color) .'; }';
            }
        }else {
            $output .= '.tsnews-date, .top-menu li a,.social-button li a{ color:#a3a3a3; }';
        }

        if ( news247_theme_options('topbar_hover_color') ) {
            $topbar_hover_color = esc_attr(news247_theme_options('topbar_hover_color'));
            if(isset($topbar_hover_color)){
                $output .= '.top-menu li a:hover,.social-button li a:hover{ color:'. esc_attr($topbar_hover_color) .'; }';
            }
        }else {
            $output .= '.top-menu li a:hover,.social-button li a:hover{ color:#ec0000; }';
        }

        if ( news247_theme_options('menu_color') ) {
            $menucolor = esc_attr(news247_theme_options('menu_color'));
            if(isset($menucolor)){
                $output .= 'ul.main-menu>li>a,.thw-menubar .social-button li a,.thw-menubar .nav-search{ color:'. esc_attr($menucolor) .'; }';
            }
        }else {
            $output .= 'ul.main-menu>li>a,.thw-menubar .social-button li a,.thw-menubar .nav-search{ color:#000; }';
        }
        if ( news247_theme_options('menu_hover_color') ) {
            $menuhovercolor = esc_attr(news247_theme_options('menu_hover_color'));
            if(isset($menuhovercolor)){
                $output .= 'ul.main-menu>li>a:hover,ul.main-menu > li.current-menu-item >a,
                ul.main-menu>li.current-menu-parent>a{ color:'. esc_attr($menuhovercolor) .'; }';
            }
        }else {
            $output .= 'ul.main-menu>li>a:hover,ul.main-menu > li.current-menu-item >a,
            ul.main-menu>li.current-menu-parent>a{ color:#ec0000; }';
        }


        if ( news247_theme_options('submenu_color') ) {
            $submenucolor = esc_attr(news247_theme_options('submenu_color'));
            if(isset($submenucolor)){
                $output .= 'ul.main-menu li ul li a{ color:'. esc_attr($submenucolor) .'; }';
            }
        }else {
            $output .= 'ul.main-menu li ul li a{ color:#000; }';
        }
        if ( news247_theme_options('submenu_hover_color') ) {
            $submenuhovercolor = esc_attr(news247_theme_options('submenu_hover_color'));
            if(isset($submenuhovercolor)){
                $output .= 'ul.main-menu li ul li a:hover,ul.main-menu li ul li.current-menu-item > a{ color:'. esc_attr($submenuhovercolor) .'; }';
            }
        }else {
            $output .= 'ul.main-menu li ul li a:hover,ul.main-menu li ul li.current-menu-item > a{ color:#ec0000; }';
        }

        if ( news247_theme_options('footer_bg') ) {
            $footer = esc_attr(news247_theme_options('footer_bg'));
            if(isset($footer)){
                $output .= '.footer-column{ background:'. esc_attr($footer) .'; }';
            }
        }else {
            $output .= '.footer-column{ background: #1c1c1c; }';
        }
        if ( news247_theme_options('footer_color') ) {
            $footercolor = esc_attr(news247_theme_options('footer_color'));
            if(isset($footercolor)){
                $output .= '.footer-column, .footer-column a, .footer-column .widget ul.nav>li>a,
                .footer-widget .recent-posts .post-info .entry-title a,.footer-widget .recent-posts-widget .post-info .entry-title a,
                .footer-widget .recent-posts-widget .post-meta time{ color:'. esc_attr($footercolor) .'; }';
            }
        }else {
            $output .= '.footer-column, .footer-column a, .footer-column .widget ul.nav>li>a,
                .footer-widget .recent-posts .post-info .entry-title a,.footer-widget .recent-posts-widget .post-info .entry-title a,
                .footer-widget .recent-posts-widget .post-meta time{ color: #969696; }';
        }

        if ( news247_theme_options('footer_title_color') ) {
            $footer_title_color = esc_attr(news247_theme_options('footer_title_color'));
            if(isset($footer_title_color)){
                $output .= '.footer-widget .widget-title, .footerbottom-widget .widget-title{ color:'. esc_attr($footer_title_color) .'; }';
            }
        }else {
            $output .= '.footer-widget .widget-title, .footerbottom-widget .widget-title{ color: #fff; }';
        }

        if ( news247_theme_options('footer_hover_color') ) {
            $footerhovercolor = esc_attr(news247_theme_options('footer_hover_color'));
            if(isset($footerhovercolor)){
                $output .= '.footer-column a:hover, .footer-column .widget ul.nav>li>a:hover,
                .footer-widget .recent-posts .post-info .entry-title a:hover,.footer-widget .recent-posts-widget .post-info .entry-title a:hover{ color:'. esc_attr($footerhovercolor) .'; }';
            }
        }else {
            $output .= '.footer-column a:hover,.footer-column .widget ul.nav>li>a:hover,.footer-widget .recent-posts-widget .post-info .entry-title a:hover{ color: #ec0000; }';
        }


        if ( news247_theme_options('copyright_bg') ) {
            $copyright_bg = esc_attr(news247_theme_options('copyright_bg'));
            if(isset($copyright_bg)){
                $output .= '.copyright{ background:'. esc_attr($copyright_bg) .'; }';
            }
        }else {
            $output .= '.copyright{ background: #ec0000; }';
        }
        if ( news247_theme_options('copyright_color') ) {
            $copyright_color = esc_attr(news247_theme_options('copyright_color'));
            if(isset($copyright_color)){
                $output .= '.copyright, .footer-nav li a { color:'. esc_attr($copyright_color) .'; }';
            }
        }else {
            $output .= '.copyright, .footer-nav li a{ color: #fff; }';
        }
        if ( news247_theme_options('copyright_hover_color') ) {
            $copyright_hover_color = esc_attr(news247_theme_options('copyright_hover_color'));
            if(isset($copyright_hover_color)){
                $output .= '.copyright a:hover, .footer-nav li a:hover { color:'. esc_attr($copyright_hover_color) .'; }';
            }
        }else {
            $output .= '.copyright a:hover, .footer-nav li a:hover{ color: #bbb; }';
        }

        if (news247_theme_options('custom_css')) {
            $output .= esc_attr(news247_theme_options('custom_css'));
        }
        return $output;
    }
}