<?php
/**
 * news247 functions and definitions
 * @package news247
 * @link http://www.news247.com
 */

/********************************
/*******   Define   ********
*********************************/

define( 'NEWS247_DIR', get_template_directory() );
define( 'NEWS247_URI', get_template_directory_uri() );


/**************************************
/*******   Set Content Width   ********
***************************************/

if ( ! isset( $content_width ) ) {
	$content_width = 660;
}


/*********************************
/*******   Theme Setup  ********
**********************************/
require_once NEWS247_DIR . '/includes/main/setup.php';

/*********************************
/*******  Register Widget  ********
**********************************/
require_once NEWS247_DIR . '/includes/main/reg_widget.php';


/*********************************************
/*******  Enqueue scripts and styles  ********
**********************************************/
require_once NEWS247_DIR . '/includes/main/reg_script.php';


/*************************************
/*******   Nav  ********
**************************************/
require_once NEWS247_DIR . '/includes/main/pagination_content.php';


/*************************************
/*******  register tgm Plugin  ********
**************************************/
require_once NEWS247_DIR . '/includes/main/reg_tgm.php';

/*************************************
/*******  Custom Post Lenght  ********
**************************************/
require_once NEWS247_DIR . '/includes/main/content_text_limit.php';

/*************************************
/*******  Breadcrumb  ********
**************************************/
require_once NEWS247_DIR . '/includes/main/breadcrumb.php';

/*************************************
/*******  Navwalker  ********
**************************************/
require_once NEWS247_DIR . '/includes/main/wp-responsive-navwalker.php';


/*************************************
/*******  Home Design Layout  ********
**************************************/
require_once NEWS247_DIR . '/includes/main/home-layout.php';


/*********************************************
/*******  Importer  ********
**********************************************/
require_once NEWS247_DIR . '/includes/news247import.php';


/*************************************
/*******  Load More  ********
**************************************/
add_action( 'wp_ajax_nopriv_news247_post_ajax_loading', 'news247_post_ajax_loading_cb' );
add_action( 'wp_ajax_news247_post_ajax_loading', 'news247_post_ajax_loading_cb' );
function news247_post_ajax_loading_cb()
{
    require_once( get_template_directory()  . '/includes/main/postcontentloading.php');

    wp_die();
}

/*************************************
/*******  Header Design Layout  ********
**************************************/
require_once NEWS247_DIR . '/includes/main/header-design-layout.php';

/*************************************
/*******  Menu Design Layout  ********
**************************************/
require_once NEWS247_DIR . '/includes/main/menu-design-layout.php';

/*************************************
/*******  Comment  ********
**************************************/
require_once NEWS247_DIR . '/includes/main/tw_comment.php';

/*************************************
/*******   Post View Count  ********
**************************************/
if(!function_exists('news247_wpb_get_post_views')):
function news247_wpb_get_post_views($postID){
    $count_key = '_post_views_count';
    $count = get_post_meta($postID, $count_key, true);
    if($count==''){
        delete_post_meta($postID, $count_key);
        add_post_meta($postID, $count_key, '0');
        return "0";
    }
    return $count;
}
endif;
