<?php
/**
 * The template for displaying the footer.
 *
 * Contains the closing of the id=main div and all content after
 */
?>

		</div><!-- /.main-content -->

        <?php

        if ( news247_theme_options('footer_column') ) {
            $footercolumn = esc_attr(news247_theme_options('footer_column'));
        } else {
            $footercolumn = '3';
        }

        if ( is_active_sidebar( 'footer1' ) || is_active_sidebar( 'footer2' ) || is_active_sidebar( 'footer3' ) || is_active_sidebar( 'footer4' ) || is_active_sidebar( 'footerbottom' ) ) { ?>
            <div class="footer-column">
                <div class="container">
                    <div class="row">
                        <?php if( is_active_sidebar( 'footer1' ) ) { ?>
                            <div class="col-sm-6 col-md-6 col-lg-<?php echo esc_attr($footercolumn);?>">
                                <?php dynamic_sidebar('footer1'); ?>
                            </div>
                        <?php } ?>
                        <?php if( is_active_sidebar( 'footer2' ) ) { ?>
                            <div class="col-sm-6 col-md-6 col-lg-<?php echo esc_attr($footercolumn);?>">
                                <?php dynamic_sidebar('footer2'); ?>
                            </div>
                        <?php } ?>
                        <?php if( is_active_sidebar( 'footer3' ) ) { ?>
                            <div class="col-sm-6 col-md-6 col-lg-<?php echo esc_attr($footercolumn);?>">
                                <?php dynamic_sidebar('footer3'); ?>
                            </div>
                        <?php } ?>
                        <?php if( is_active_sidebar( 'footer4' ) ) { ?>
                            <div class="col-sm-6 col-md-6 col-lg-<?php echo esc_attr($footercolumn);?>">
                                <?php dynamic_sidebar('footer4'); ?>
                            </div>
                        <?php } ?>
                    </div><!--/.row -->
					<?php if ( is_active_sidebar( 'footerbottom' ) ) { ?>
				        <div class="footer-bottom text-center">
					         <?php dynamic_sidebar('footerbottom'); ?>
						</div><!--/.footer-area -->
					<?php } ?>

                </div><!--/.container -->
            </div><!--/.bottom-column -->
        <?php } ?>

		<?php
		if ( class_exists( 'ReduxFramework' ) ) {
			if ( news247_theme_options('copyright_en') ) {
			?>
				<footer class="copyright copyright-layout1">
		            <div class="container">
						<div class="row copyright-info">
					        <?php if( news247_theme_options('copyright') ) { ?>
					        	<div class="col-md-6">
									<?php  if( news247_theme_options('copyright') )  print wp_kses_post(news247_theme_options('copyright')); ?>
								</div>
							<?php } ?>
							<?php if ( has_nav_menu( 'footermenu' ) ) : ?>
								<div class="footer-menu text-right col-md-6">
									<?php
										// footer Nav
										wp_nav_menu( array(
											'theme_location' => 'footermenu',
											'depth'          => 1,
											'menu_class' => 'nav footer-nav',
											'fallback_cb' => '',
										) );
									?>
								</div>
							<?php endif; ?>
						</div>
                        <?php if ( news247_theme_options('totop_en') ) { ?>
                        <div id="back-to-top" data-spy="affix" data-offset-top="10" class="back-to-top affix">
                            <button class="btn btn-primary" title="<?php esc_html_e( 'Back to Top', 'news247' ); ?>">
                                <i class="fa fa-angle-up"></i>
                            </button>
                        </div>
                        <?php } ?>
					</div><!-- Container end -->
		        </footer><!--/.footer-area -->

	        <?php } ?>
        <?php } else { ?>
	        <footer class="copyright">
	        	<div class="container">
					<div class="copyright-info text-center">
						<?php esc_html_e( 'Copyright © 2017 News247 All Rights Reserved.', 'news247' ); ?>
					</div>
				</div>
			</footer><!--/.footer-area -->
        <?php } ?>

	</div><!--/.body-inner -->
	<?php wp_footer(); ?>
</body>
</html>