<?php
/**
 * The template for displaying Archive pages.
 * Learn more: http://codex.wordpress.org/Template_Hierarchy
*/

get_header(); ?>
<div class="main-content">

	<div class="container">
	    <?php if ( news247_theme_options('breadcrumb_en') ) { ?>
			<?php news247_theme_breadcrumb() ;?>
		<?php } ?>
		<div class="main-content-wrap">
			<div class="row">
			<?php // add the class "panel" below here to wrap the content-padder in Bootstrap style ;) ?>
            <?php if ( is_active_sidebar( 'sidebar' ) ) { ?>
                <div id="content" class="col-lg-8 col-md-8 col-sm-12">
                <?php } else { ?>
                    <div id="content" class="col-lg-12 col-md-12 col-sm-12">
                <?php } ?>
				
				<header class="page-header">
							<h1 class="page-title">
								<?php
									if ( is_category() ) :
										single_cat_title();

									elseif ( is_tag() ) :
										single_tag_title();

									elseif ( is_author() ) :
										/* Queue the first post, that way we know
										 * what author we're dealing with (if that is the case).
										*/
										the_post();
										printf( esc_html__( 'Author: %s', 'news247' ), '<span class="vcard">' . esc_html( get_the_author() ) . '</span>' );
										rewind_posts();

									elseif ( is_day() ) :
										printf( esc_html__( 'Day: %s', 'news247' ), '<span>' . esc_html( get_the_date() ) . '</span>' );

									elseif ( is_month() ) :
										printf( esc_html__( 'Month: %s', 'news247' ), '<span>' . esc_html( get_the_date( 'F Y' ) ) . '</span>' );

									elseif ( is_year() ) :
										printf( esc_html__( 'Year: %s', 'news247' ), '<span>' . esc_html( get_the_date( 'Y' ) ) . '</span>' );

									elseif ( is_tax( 'post_format', 'post-format-aside' ) ) :
										esc_html_e( 'Asides', 'news247' );

									elseif ( is_tax( 'post_format', 'post-format-image' ) ) :
										esc_html_e( 'Images', 'news247');

									elseif ( is_tax( 'post_format', 'post-format-video' ) ) :
										esc_html_e( 'Videos', 'news247' );

									elseif ( is_tax( 'post_format', 'post-format-quote' ) ) :
										esc_html_e( 'Quotes', 'news247' );

									elseif ( is_tax( 'post_format', 'post-format-link' ) ) :
										esc_html_e( 'Links', 'news247' );

									else :
										esc_html_e( 'Archives', 'news247' );

									endif;
								?>
							</h1>
							<?php
								// Show an optional term description.
								$term_description = term_description();
								if ( ! empty( $term_description ) ) :
									printf( '<div class="taxonomy-description">%s</div>', esc_attr ($term_description) );
								endif;
							?>
						</header><!-- .page-header -->
						<div class="main-content-inner row clearfix">
					<?php if ( have_posts() ) : ?>
	
						<?php /* Start the Loop */
						while ( have_posts() ) : the_post();
							get_template_part( 'content', get_post_format() );
						endwhile;
					else :
						get_template_part( 'no-results', 'archive' );
					endif;
					news247_content_nav( 'nav-below' ); ?>
				</div><!-- .main-content-inner -->
				</div><!-- .col-sm-9 -->
			<?php get_sidebar(); ?>
            </div><!--/.row -->
        </div><!-- /.main-content-wrap -->
    </div><!-- /.container -->

<?php get_footer(); ?>
