<?php
/**
 * Demo
 *
 * A simple plugin to allow overwrite options var in demo to showcase
 *
 *
 * @wordpress-plugin
 * Plugin Name:       Demo
 * Plugin URI:        http://wowothemes.com
 * Description:       A simple plugin to allow overwrite options var in demo to showcase
 * Version:           1.0.0
 * Author:            WoWoThemes, LLC
 * Author URI:        http://wowothemes.com
 * Domain Path:       /languages
 */

// If this file is called directly or the plugin already exists, abort.
if ( ! defined( 'WPINC' ) ) {
	die;
}

if( !is_admin() ) :

// Presets Vars
global $ivan_demo_overloads;
global $ivan_demo_per_page;

$ivan_demo_per_page = 0;

$ivan_demo_overloads = array(

	// Features
	'classic_header' => array(
		'header-layout' => 'Ivan_Layout_Header_Classic_Right_Area',
		'header-v-sign-switch' => true,
		'header-text-switch' => true,
	),

	'centered_logo' => array(
		'header-layout' => 'Ivan_Layout_Header_Simple_Logo_Centered',
		'header-v-sign-switch' => '0',
		'header-text-switch' => true,
		'css_editor' => '#menu-item-100 { display: none; }',
	),

	'centered_classic' => array(
		'header-layout' => 'Ivan_Layout_Header_Classic_Logo_Centered',
		'header-v-sign-switch' => true,
		'header-text-switch' => true,
		'header-menu-pull-center-switch' => true,
	),

	// Blog
	'blog_aside_date' => array(
		'blog-layout' => 'large',
		'blog-sub-large' => 'aside-date',
	),

	'blog_medium' => array(
		'blog-layout' => 'medium',
		'blog-sub-medium' => 'simple',
		'blog-sidebar-right' => '0',
		'blog-sidebar-left' => '0',
		'blog-boxed-style' => true,
	),

	'blog_masonry_three' => array(
		'blog-layout' => 'masonry',
		'blog-sub-masonry' => 'simple',
		'blog-columns' => '3',
		'blog-sidebar-right' => '0',
		'blog-sidebar-left' => '0',
		'posts_per_page' => 8,
	),

	'blog_masonry_two' => array(
		'blog-layout' => 'masonry',
		'blog-sub-masonry' => 'simple',
		'blog-columns' => '2',
		'blog-sidebar-right' => '0',
		'blog-sidebar-left' => '0',
		'posts_per_page' => 8,
	),

	'blog_masonry_side' => array(
		'blog-layout' => 'masonry',
		'blog-sub-masonry' => 'simple',
		'blog-columns' => '2',
		'blog-sidebar-right' => true,
		'blog-sidebar-left' => '0',
		'posts_per_page' => 8,
	),

	'blog_boxed_style' => array(
		'blog-boxed-style' => true,
		'blog-sidebar-right' => true,
	),

	'blog_full' => array(
		'blog-layout' => 'full',
		'blog-sub-full' => 'polaroid',
		'blog-sidebar-right' => '0',
		'blog-sidebar-left' => '0',
	),

	'blog_side_left' => array(
		'blog-boxed-style' => true,
		'blog-sidebar-right' => '0',
		'blog-sidebar-left' => true,
	),

	'blog_boxed' => array(
		'blog-layout' => 'medium',
		'blog-sub-medium' => 'simple',
		'blog-sidebar-right' => '0',
		'blog-sidebar-left' => '0',
		'blog-boxed-page' => true,
	),

	'blog_aside_large' => array(
		'main-layout' => 'Ivan_Main_Layout_Aside_Left',
		'layout-header-fixed-height' => true,
	),

	'blog_aside_full' => array(
		'main-layout' => 'Ivan_Main_Layout_Aside_Left',
		'layout-header-fixed-height' => true,
		'blog-layout' => 'full',
		'blog-sub-full' => 'polaroid',
		'blog-sidebar-right' => '0',
		'blog-sidebar-left' => '0',
		'blog-disable-title' => true,
		'blog-boxed-style' => true,
	),

	'blog_aside_masonry' => array(
		'main-layout' => 'Ivan_Main_Layout_Aside_Left',
		'layout-header-fixed-height' => true,
		'blog-layout' => 'masonry',
		'blog-sub-masonry' => 'simple',
		'blog-columns' => '2',
		'blog-sidebar-right' => '0',
		'blog-sidebar-left' => '0',
		'posts_per_page' => 30,
		'blog-disable-title' => true,
	),

	// Shop
	'wide_shop' => array(
		'woo-shop-layout' => 'full',
		'woo-shop-columns' => '4',
	),

	'side_right_shop' => array(
		'woo-shop-layout' => 'right',
	),

	'two_cols_shop' => array(
		'woo-shop-columns' => '2',
	),

	'four_cols_shop' => array(
		'woo-shop-columns' => '4',
		//'woo-shop-layout' => 'full',
	),

	'list_shop' => array(
		'woo-list-layout' => true,
	),

	'cat_header_shop' => array(
		'woo-category-image' => true,
	),

	// Single Product
	
	'prod_section' => array(
		'woo-product-tabs-layout' => 'block',
	),

	'prod_v_tab' => array(
		'woo-product-tabs-layout' => 'vertical',
	),

	'prod_side_right' => array(
		'woo-product-layout' => 'right'
	),

	'prod_side_left' => array(
		'woo-product-layout' => 'left'
	),

	'prod_wide_thumb' => array(
		'woo-product-layout' => 'right',
		'woo-thumbnail-stacked' => true,
	),

	'prod_catalog' => array(
		'woo-catalog-mode' => true
	),


);

// Check if any overload are being called here...
foreach ($ivan_demo_overloads as $key => $value) {
	// A overload is being used???
	if( isset( $_GET[ $key ] ) ) {
		//var_dump( $value );
		// Adds a filter to each key of overload
		foreach ($value as $var_name => $var_val) {

			if('posts_per_page' != $var_name) :
				add_filter( 'ivan_get_option_filter_' . $var_name, function($value) use ($var_val) {
					return $var_val;
				}, 3 );
			else :
				global $ivan_demo_per_page;

				$ivan_demo_per_page = $var_val;
			endif;
		}
		
	}
}

if($ivan_demo_per_page > 0) :

	// Increase results of search page
	add_action( 'pre_get_posts', 'ivan_demo_set_posts_per_page' );
	function ivan_demo_set_posts_per_page( $query ) {

		global $wp_the_query;
		global $ivan_demo_per_page;

		if ( ( ! is_admin() ) && ( $query === $wp_the_query ) ) {
			$query->set( 'posts_per_page', $ivan_demo_per_page );
		}

		return $query;
	}
endif;

endif; // is_admin global if