<?php
/**
 *
 * Template Part called at class Ivan_Layout_Header_Horizontal_With_Sidebar
 *
 * @package   IvanFramework
 */

?>


<?php

	wp_enqueue_script( 'dlmenu' );

	// Variable used to display additional classes in the layout.
	$_classes = '';

	// Check if Fixed Header option is enabled and output the respective class.
	$_classes .= ivan_get_option_display( 'header-fixed-switch', ' header-fixed', '' );

	$_classes .= ivan_get_option_display( 'header-overlay-bottom-border', ' has-border', '' );

	// Check if Lateral Lines in modules is enabled and output the respective class.
	$_classes .= ivan_get_option_display( 'header-lateral-lines-switch', ' lateral-lines', '' );

	// Check if Negative Height is enabled and output the respective class.
	$_classes .= ivan_get_option_display( 'header-negative-height', ' negative-height', '' );

	// If header has negative height
	if( true == ivan_get_option( 'header-negative-height' ) ) :

		// Apply background type to header
		$_classes .= ' ' . ivan_get_option( 'header-bg-type' );

		// Apply color scheme to header
		$_classes .= ' ' . ivan_get_option( 'header-color-scheme' );

		// Apply boxed layout to header
		$_classes .= ivan_get_option_display( 'header-boxed-layout', ' simple-boxed-menu', '' );

	endif;

	// Locally Disabled Modules
	$disabled_items = ivan_get_post_option( 'header-local-disabled-modules' );
	if( $disabled_items == null )
		$disabled_items = array();

	$enabled_items = ivan_get_post_option( 'header-local-enabled-modules' );
	if( $enabled_items == null )
		$enabled_items = array();

	$_classes = esc_attr( $_classes ); // escape classes to attribute

?>

<div class="<?php echo apply_filters( 'iv_header_classes', 'iv-layout header style7'. $_classes ); ?>">
	<div class="container">
		<div class="row">
			<div class="col-md-12">
				<div class="menu-bar clearfix">
					<div class="logo-container">
						<?php Ivan_Module_Logo::display(); ?>
					</div><!-- /logo-container -->
					<div class="nav-trigger">
						<a class="dl-trigger" href="#">
							<span class="bars">
								<span></span>
								<span></span>
								<span></span>
							</span>
						</a>
					</div><!-- /col-md-12 -->
				</div><!-- /row -->
			</div><!-- /container -->
		</div><!-- /nav-trigger -->
	</div><!-- /menu-bar -->
	<div class="menu-items-container">
		
		<?php
		$menu_args = array(
			'theme_location' => 'primary',
			'container' => 'div',
			'container_id' => 'dl-menu',
			'container_class' => 'iv-module-menu menu-items dl-menuwrapper' . ivan_get_option_display( 'header-menu-pull-center-switch', ' centralized-menu', ' pull-left' ),
			'menu_id' => 'menu-primary-menu',
			'menu_class' => 'dl-menu',
			'menu_holder' => 'centered',
		);

		Ivan_Module_Menu::display( $menu_args ); 
		?>
	</div><!-- /menu-items-container -->
</div><!-- /header -->
