<?php
/*
 * WooCommerce Section
*/

$this->sections[] = array(
	'title' => esc_html__('Shop', 'sliva'),
	'desc' => esc_html__('Change shop templates and configurations.', 'sliva'),
	'icon' => 'el-icon-screen',
	'fields' => array(

		array(
			'id' => 'random-woo-templates',
			'type' => 'info',
			'desc' => esc_html__('General Configuration.', 'sliva')
		),

		array(
			'id'=>'woo-shop-layout',
			'type' => 'select',
			'title' => esc_html__('Shop Layout', 'sliva'), 
			'subtitle' => esc_html__('Select the layout to be used in shop.', 'sliva'),
			'options' => array( 
				'left' => 'Sidebar at Left',
				'right' => 'Sidebar at Right',
				'full' => 'Without Sidebar (Wide)',
				),
			'default' => 'left',
			'validate' => 'not_empty',
		),

		array(
			'id' => 'woo-per-page',
			'type' => 'text',
			'title' => esc_html__('Products per Page', 'sliva'),
			'subtitle' => esc_html__('Define the number of products displayed per page.', 'sliva'),
			'default' => '8',
			'validate' => 'not_empty',
		),

		array(
			'id' => 'woo-shop-columns',
			'type' => 'slider',
			'title' => esc_html__('Columns', 'sliva'),
			'subtitle' => esc_html__('Define columns number at shop.', 'sliva'),
			"default" => "3",
			"min" => "1",
			"step" => "1",
			"max" => "4",
		),
		
		array(
			'id' => 'woo-shop-one-less',
			'type' => 'switch',
			'title' => esc_html__('One less on first row', 'sliva'),
			'subtitle' => esc_html__('Show one less product on first row.', 'sliva'),
			"default" => "0",
		),

		array(
			'id'=>'woo-list-layout',
			'type' => 'switch', 
			'title' => esc_html__('Display Products in List', 'sliva'),
			'subtitle'=> esc_html__('If on, products will be displayed as list instead thumbs at shop.', 'sliva'),
			'default' => 0,
		),

		array(
			'id'=>'woo-catalog-mode',
			'type' => 'switch', 
			'title' => esc_html__('Enable Catalog Mode?', 'sliva'),
			'subtitle'=> esc_html__('If on, Add to Cart buttons will not be displayed to users.', 'sliva'),
			'default' => 0,
		),

		array(
			'id'=>'woo-catalog-mode-text',
			'type' => 'textarea', 
			'title' => esc_html__('Catalog Mode Text', 'sliva'),
			'subtitle'=> esc_html__('What will be displayed instead default Add to Cart button.', 'sliva'),
			'default' => 'Get in <a href="#">touch</a> to more details.',
			'required' => array( 'woo-catalog-mode', '=', 1 ),
		),	

		array(
			'id'=>'woo-category-image',
			'type' => 'switch', 
			'title' => esc_html__('Enable Category Image?', 'sliva'),
			'subtitle'=> esc_html__('If on, the uploaded image will be displayed above the products in shop listing.', 'sliva'),
			'default' => 0,
		),

		array(
			'id'=>'woo-display-sorting',
			'type' => 'switch', 
			'title' => esc_html__('Enable Sorting Options?', 'sliva'),
			'subtitle'=> esc_html__('If on, the sorting options will be displayed in the shop, this way users can order by price or others.', 'sliva'),
			'default' => 0,
		),

		array(
			'id'=>'woo-disable-quick-view',
			'type' => 'switch', 
			'title' => esc_html__('Disable Quick View Feature?', 'sliva'),
			'subtitle'=> esc_html__('If on, the quick view feature will not be avaliable.', 'sliva'),
			'default' => 0,
		),

		array(
			'id'=>'woo-disable-front-back',
			'type' => 'switch', 
			'title' => esc_html__('Disable Front/Back Feature?', 'sliva'),
			'subtitle'=> esc_html__('If on, the front and back images will not be avaliable.', 'sliva'),
			'default' => 0,
		),

		array(
			'id'=>'woo-disable-title',
			'type' => 'switch', 
			'title' => esc_html__('Disable Title Wrapper?', 'sliva'),
			'subtitle'=> esc_html__('If on, title wrapper will not be displayed.', 'sliva'),
			"default" => 0,
		),

		array(
			'id' => 'random-woo-templates',
			'type' => 'info',
			'desc' => esc_html__('Single Product Configuration.', 'sliva')
		),

		array(
			'id'=>'woo-product-layout',
			'type' => 'select',
			'title' => esc_html__('Product Layout', 'sliva'), 
			'subtitle' => esc_html__('Select the layout to be used in single products.', 'sliva'),
			'options' => array( 
				'left' => 'Sidebar at Left',
				'right' => 'Sidebar at Right',
				'full' => 'Without Sidebar (Wide)',
				),
			'default' => 'full',
			'validate' => 'not_empty',
		),

		array(
			'id'=>'woo-thumbnail-stacked',
			'type' => 'switch', 
			'title' => esc_html__('Display Wide Thumbnail', 'sliva'),
			'subtitle'=> esc_html__('If on, instead two columns in single products, they will appear as one column.', 'sliva'),
			'default' => 0,
		),

		array(
			'id'=>'woo-product-tabs-layout',
			'type' => 'select',
			'title' => esc_html__('Product Tabs Layout', 'sliva'), 
			'subtitle' => esc_html__('Select the layout to be used in single products tabs.', 'sliva'),
			'options' => array( 
				'default' => 'Horizontal Tabs',
				'vertical' => 'Vertical Tabs',
				'block' => 'Without Tabs (blocks)',
				),
			'default' => 'default',
			'validate' => 'not_empty',
		),

		array(
			'id'=>'woo-product-extra-tab',
			'type' => 'switch', 
			'title' => esc_html__('Enable Extra Tab?', 'sliva'),
			'subtitle'=> esc_html__('If on, an additional global tab will be displayed in products tabs.', 'sliva'),
			'default' => 0,
		),

			array(
				'id' => 'woo-product-extra-tab-title',
				'type' => 'text',
				'title' => esc_html__('Extra Tab Title', 'sliva'),
				'subtitle' => esc_html__('Define the extra tab title.', 'sliva'),
				'default' => 'Extra Tab',
				'validate' => 'not_empty',
				'required' => array('woo-product-extra-tab', '=', 1),
			),

			array(
				'id' => 'woo-product-extra-tab-content',
				'type' => 'editor',
				'title' => esc_html__('Extra Tab Content', 'sliva'),
				'subtitle' => esc_html__('Define the extra tab content.', 'sliva'),
				'default' => 'Content',
				'validate' => 'not_empty',
				'required' => array('woo-product-extra-tab', '=', 1),
			),

		array(
			'id'=>'woo-disable-breadcrumb',
			'type' => 'switch', 
			'title' => esc_html__('Disable Breadcrumb?', 'sliva'),
			'subtitle'=> esc_html__('If on, breadcrumb above product title will not be displayed.', 'sliva'),
			'default' => 0,
		),

		array(
			'id'=>'woo-disable-social-share',
			'type' => 'switch', 
			'title' => esc_html__('Disable Social Share?', 'sliva'),
			'subtitle'=> esc_html__('If on, social share icons below product details will not be displayed.', 'sliva'),
			'default' => 0,
		),

		array(
			'id'=>'woo-disable-related-products',
			'type' => 'switch', 
			'title' => esc_html__('Disable Related Products?', 'sliva'),
			'subtitle'=> esc_html__('If on, related products will not be displayed.', 'sliva'),
			'default' => 0,
		),


		array(
			'id' => 'random-woo-templates',
			'type' => 'info',
			'desc' => esc_html__('Shop and Product Settings.', 'sliva')
		),

		array(
			'id'=>'shop-boxed-page',
			'type' => 'switch', 
			'title' => esc_html__('Display Shop/Products Boxed?', 'sliva'),
			'subtitle'=> esc_html__('If on, the shop and products will be displayed in a boxed layout.', 'sliva'),
			"default" => 0,
		),
	), // #fields
);