<?php
/*
 * Layout Section
*/

$this->sections[] = array(
	'title' => esc_html__('Layout Settings', 'sliva'),
	'desc' => esc_html__('Change the main theme\'s layout and configure it.', 'sliva'),
	'icon' => 'el-icon-adjust-alt',
	'fields' => array(

		array(
			'id'        => 'main-layout',
			'type'      => 'image_select',
			'compiler'  => true,
			'title' => esc_html__('Main Layout', 'sliva'),
			'desc' => esc_html__('See that this layout is valid to the whole website, but you can overwrite it locally in a page, for example.', 'sliva'),
			'subtitle' => esc_html__('Select the layout to be used by the website.', 'sliva'),
			'options'   => array(
				'Ivan_Main_Layout_Normal' => array(
					'alt' => 'Default Layout',
					'title' => 'Top Header',
					'img' => get_template_directory_uri() . '/framework/assets/images/main-layout-top.png'
				),
			),
			'default'   => 'Ivan_Main_Layout_Normal',
			'validate' => 'not_empty',
		),
		
		array(
			'id' => 'main-layout-aside-background',
			'type' => 'background',
			'output' => array('.header.vertical.modern .background-container'),
			'title' => esc_html__('Aside Layout Background', 'sliva'),
			'subtitle' => esc_html__('Background image, color and other options. Usually visible only when using boxed layout.', 'sliva'),
			'required' => array('main-layout', '=', 'Ivan_Main_Layout_Aside_Left_Modern')
		),

		// Enable Fixed Height Header effect in website
		array(
			'id'=>'layout-header-fixed-height',
			'type' => 'switch', 
			'title' => esc_html__('Fixed Height Header', 'sliva'),
			'subtitle'=> esc_html__('If on, the header will be fixed at screen top not scrolling together with page.', 'sliva'),
			'default' => 0,
			'required' => array( 'main-layout', '!=', array('Ivan_Main_Layout_Normal', 'Ivan_Main_Layout_Aside_Left_Modern') ),
		),

		// Disable Widget Area below header
		array(
			'id'=>'layout-header-widget-area',
			'type' => 'switch', 
			'title' => esc_html__('Disable Widget Area?', 'sliva'),
			'subtitle'=> esc_html__('If on, the header will not show the widget area below menu. Useful when you are using Fixed Height Header.', 'sliva'),
			'default' => 0,
			'required' => array( 'main-layout', '!=', array('Ivan_Main_Layout_Normal', 'Ivan_Main_Layout_Aside_Left_Modern') ),
		),

		array(
			'id'=>'wide-boxed-switch',
			'type' => 'image_select',
			'title' => esc_html__('Template', 'sliva'),
			'desc' => esc_html__('See that this configuration is valid to the whole website, but you can overwrite it locally in a page, for example.', 'sliva'),
			'subtitle' => esc_html__('Select if the layout will be boxed or wide.', 'sliva'),
			'options' => array(
				'wide' => array(
					'alt' => 'Wide',
					'title' => 'Wide',
					'img' => get_template_directory_uri() . '/framework/assets/images/template-wide.png'
				),
				'boxed' => array(
					'alt' => 'Boxed',
					'title' => 'Boxed',
					'img' => get_template_directory_uri() . '/framework/assets/images/template-framed.png'
				),
				'boxed-laterals' => array(
					'alt' => 'Boxed only Lateral Margins',
					'title' => 'Boxed only Lateral Margins',
					'img' => get_template_directory_uri() . '/framework/assets/images/template-boxed.png'
				),
				'page-framed' => array(
					'alt' => 'Framed',
					'title' => 'Framed',
					'img' => get_template_directory_uri() . '/framework/assets/images/template-framed.png'
				),
			),				
			'default' => 'wide'
		),

		array(
			'id' => 'random-layout-label',
			'type' => 'info',
			'desc' => esc_html__('Container Configuration.', 'sliva')
		),

		array(
			'id'=>'header-container-type',
			'type' => 'select',
			'title' => esc_html__('Header Container Type', 'sliva'),
			'desc' => esc_html__('Define container configuration to be used, it can be normal, expanded or compact.', 'sliva'),
			'options' => array(
					'normal' => 'Normal',
					'expanded' => 'Expanded',
					'compact' => 'Compact',
					),
			'default' => 'normal',
			'required' => array( 'main-layout', '=', 'Ivan_Main_Layout_Normal'),
		),

		array(
			'id'=>'content-container-type',
			'type' => 'select',
			'title' => esc_html__('Content Container Type', 'sliva'),
			'desc' => esc_html__('Define container configuration to be used, it can be normal, expanded or compact.', 'sliva'),
			'options' => array(
					'normal' => 'Normal',
					'expanded' => 'Expanded',
					'compact' => 'Compact',
					),
			'default' => 'normal',
			'required' => array( 'main-layout', '=', 'Ivan_Main_Layout_Normal'),
		),

		array(
			'id'=>'footer-container-type',
			'type' => 'select',
			'title' => esc_html__('Footer Container Type', 'sliva'),
			'desc' => esc_html__('Define container configuration to be used, it can be normal, expanded or compact.', 'sliva'),
			'options' => array(
					'normal' => 'Normal',
					'expanded' => 'Expanded',
					'compact' => 'Compact',
					),
			'default' => 'normal',
			'required' => array( 'main-layout', '=', 'Ivan_Main_Layout_Normal'),
		),

		array(
			'id'=>'aside-container-type',
			'type' => 'select',
			'title' => esc_html__('Aside Container Type', 'sliva'),
			'desc' => esc_html__('Define container configuration to be used, it can be normal or compact.', 'sliva'),
			'options' => array(
					'normal' => 'Normal',
					'compact' => 'Compact',
					),
			'default' => 'normal',
			'required' => array( 'main-layout', '!=', array('Ivan_Main_Layout_Normal', 'Ivan_Main_Layout_Aside_Left_Modern') ),
		),

	),
);