<?php
/*
 * Layout Section
*/

$this->sections[] = array(
	'title' => esc_html__('Header', 'sliva'),
	'desc' => esc_html__('Change the header section configuration.', 'sliva'),
	'icon' => 'el-icon-cog',
	'fields' => array(

		// Disabled Header layout in the website
		array(
			'id' => 'header-enable-switch',
			'type' => 'switch', 
			'title' => esc_html__('Disable header?', 'sliva'),
			'subtitle' => esc_html__('If on, this layout part will not be displayed in website.', 'sliva'),
			'default' => 0,
		),

		array(
			'id'=>'header-layout',
			'type' => 'select',
			'title' => esc_html__('Header Layout', 'sliva'), 
			'subtitle' => esc_html__('Select the layout to be used at header.', 'sliva'),
			'options' => apply_filters('ivan_header_layouts', array( 
					'Ivan_Layout_Header_Horizontal_With_Sidebar' => 'Default',
					'Ivan_Layout_Header_Simple_Right_Menu' => 'Classic',
					'Ivan_Layout_Header_Two_Rows_Style2' => 'Modern Style',
					'Ivan_Layout_Header_Classic_Right_Area' => 'Logo and Modules + Menu Below',
					'Ivan_Layout_Header_Classic_Logo_Centered' => 'Logo Centered, Modules at Left and Right + Menu Below',
						) ),
			'default' => 'Ivan_Layout_Header_Simple_Right_Menu',
			'validate' => 'not_empty',
		),

		array(
			'id'=>'header-overlay-bottom-border',
			'type' => 'switch', 
			'title' => esc_html__('Bottom Border', 'sliva'),
			'subtitle' => esc_html__('If on, this border will displayed.', 'sliva'),
			'default' => 1,
			'required' => array(
				array('header-layout', '=', 'Ivan_Layout_Overlay_Menu'),
			),
		),
		
		array(
			'id'=>'header-menu-color',
			'type' => 'color', 
			'title' => esc_html__('Menu Color', 'sliva'),
			'required' => array(
				array('header-layout', '=', 'Ivan_Layout_Header_Horizontal_With_Sidebar'),
			),
			'output' => array(
				'color' => '
					.header.style6 .mega_main_menu .mega_main_menu_ul > li > .item_link
			'),
			'validate' => 'color',
		),
		
		// Enable Fixed Header effect in website
		array(
			'id'=>'header-fixed-switch',
			'type' => 'switch', 
			'title' => esc_html__('Fixed Header', 'sliva'),
			'subtitle'=> esc_html__('If on, the header will be fixed at screen top on page scroll.', 'sliva'),
			'default' => 0,
		),
		
		array(
			'id'=>'header-fixed-hide-upper-on-scroll',
			'type' => 'switch', 
			'title' => esc_html__('Hide upper header part on scroll', 'sliva'),
			'subtitle'=> esc_html__('If on, the upper part of header will be hidden on scroll down.', 'sliva'),
			'default' => 0,
			'required' => array(
				array('header-fixed-switch', '=', '1'),
				array('header-layout', '=', 'Ivan_Layout_Header_Two_Rows_Style2'),
			)
		),
		
		array(
			'id' => 'random-number',
			'type' => 'info',
			'desc' => esc_html__('Header Layout Configuration.', 'sliva')
		),

		// Enables Negative Height Header
		array(
			'id'=>'header-negative-height',
			'type' => 'switch', 
			'title' => esc_html__('Negative Height', 'sliva'),
			'subtitle'=> esc_html__('If on, header will not have height and content will be showed behind it.', 'sliva'),
			"default" => 0,
		),
		
		// Enables Boxed Header Layout
		array(
			'id'=>'header-boxed-layout',
			'type' => 'switch', 
			'title' => esc_html__('Enabled Boxed Layout?', 'sliva'),
			'subtitle'=> esc_html__('If on, header will look boxed in the website even when the layout is wide.', 'sliva'),
			"default" => 0,
			'required' => array(
				array('header-negative-height', 'equals', 1),
				),
		),

		array(
			'id'=>'header-bg-type',
			'type' => 'select',
			'title' => esc_html__('Header Background Type', 'sliva'), 
			'subtitle' => esc_html__('Select the type of background to be applied in header.', 'sliva'),
			'options' => array( 
					'transparent-bg' => 'Transparent',
					'semi-transparent-bg' => 'Semi Transparent',
					'solid' => 'Solid',
					),
			'default' => 'transparent-bg',
			'validate' => 'not_empty',
			'required' => array('header-negative-height', 'equals', 1),
		),

		array(
			'id' => 'header-color-scheme',
			'type' => 'select',
			'title' => esc_html__('Alternative Color Scheme', 'sliva'),
			'subtitle' => esc_html__('Select an alternative color scheme to header items.', 'sliva'),
			'options' => array( 'standard' => 'Standard', 'light' => 'Light (great to dark backgrounds)', 'dark' => 'Dark (great to light backgrounds)' ),
			'default' => 'standard',
			'validate' => 'not_empty',
			'required' => array('header-negative-height', 'equals', 1),
		),

		array(
			'id'=>'header-top-margin',
			'type' => 'spacing_mod',
			'mode'=> 'margin', // absolute, padding, margin, defaults to padding
			'right' => false, // Disable the right
			'bottom' => false, // Disable the bottom
			'left' => false, // Disable the left
			'units' => 'px', // You can specify a unit value. Possible: px, em, %
			'title' => esc_html__('Header Top Margin', 'sliva'),
			'subtitle' => esc_html__('Select a custom margin to the be applied to header top.', 'sliva'),
			'desc' => esc_html__('If not set, default margin will be applied by theme.', 'sliva'),
			'default' => array(),
			'required' => array('header-negative-height', 'equals', 1),
			'output' => array('.iv-layout.header'), // Our theme generates custom output for this field...
		),

		// Show only after page fold
		array(
			'id'=>'header-after-fold',
			'type' => 'switch', 
			'title' => esc_html__('Display Header after Page Fold?', 'sliva'),
			'subtitle'=> esc_html__('If on, header will be displayed after user scroll until page fold.', 'sliva'),
			"default" => 0,
			'required' => array(
				array('header-negative-height', 'equals', 1),
				array('header-layout', '!=', 'Ivan_Layout_Overlay_Menu'),
				),
		),

			array(
				'id'=>'header-after-fold-logo',
				'type' => 'switch', 
				'title' => esc_html__('Keep showing logo before fold?', 'sliva'),
				'subtitle'=> esc_html__('If on, only the logo will be showed before page fold.', 'sliva'),
				"default" => 0,
				'required' => array(
					array('header-after-fold', 'equals', 1),
					array('header-layout', '!=', 'Ivan_Layout_Overlay_Menu'),	
					),
			),

		array(
			'id' => 'random-number-mod',
			'type' => 'info',
			'desc' => esc_html__('General Modules Configuration.', 'sliva'),
		),

		// Option to pull menu to left in avaliable layouts
		array(
			'id'=>'header-menu-pull-left-switch',
			'type' => 'switch', 
			'title' => esc_html__('Pull Menu to Left Side', 'sliva'),
			'subtitle'=> esc_html__('If on and avaliable in the layout, the menu will be placed at left. Works with "Normal Layout", "Logo at left and Menu + Modules Aside" and "Logo at left and Menu + Modules Aside -Style 2" only.', 'sliva'),
			'default' => 0,
			'required' => array(
				array('main-layout', 'equals', 'Ivan_Main_Layout_Normal'),
				array('header-layout', 'equals', array(
					'Ivan_Layout_Header_Simple_Right_Menu',
					'Ivan_Layout_Header_Style3_Right_Menu',
					'Ivan_Layout_Header_Style4_Right_Menu',
				) ),
			),
		),

		array(
			'id'=>'header-menu-pull-center-switch',
			'type' => 'switch', 
			'title' => esc_html__('Centralized Menu', 'sliva'),
			'subtitle'=> esc_html__('If on, menu will be centralized. Note that this option does not work with all layouts.', 'sliva'),
			'default' => 0,
			'required' => array(
				array('main-layout', 'equals', 'Ivan_Main_Layout_Normal'),
				array('header-layout', 'equals', 
					array(
						'Ivan_Layout_Header_Classic_Right_Area', 
						'Ivan_Layout_Header_Classic_Logo_Centered', 
						'Ivan_Layout_Header_Only_Menu'
					) 
				),
			),
		),

		array(
			'id'=>'header-aside-menu-centered-switch',
			'type' => 'switch', 
			'title' => esc_html__('Center Align Aside Menu Items', 'sliva'),
			'subtitle'=> esc_html__('If on the menu items will be centered, else default alignment left/right will be used.', 'sliva'),
			'default' => 1,
			'required' => array(
				array('main-layout', 'equals', array('Ivan_Main_Layout_Aside_Left', 'Ivan_Main_Layout_Aside_Right') ),
			),
		),

		// Adds Lateral Lines to Modules
		array(
			'id'=>'header-lateral-lines-switch',
			'type' => 'switch', 
			'title' => esc_html__('Lateral Lines', 'sliva'),
			'subtitle'=> esc_html__('If on, modules will have lateral lines to separate them.', 'sliva'),
			'default' => 0,
			'required' => array('header-layout', '!=', 'Ivan_Layout_Overlay_Menu'),
		),

		// Adds V sign after menu items
		array(
			'id'=>'header-v-sign-switch',
			'type' => 'switch', 
			'title' => esc_html__('Menu Arrow', 'sliva'),
			'subtitle'=> esc_html__('If on, menu items will get a arrow after text.', 'sliva'),
			'default' => 0,
			'required' => array('header-layout', '!=', 'Ivan_Layout_Overlay_Menu'),
		),

		// Use responsive menu in select mode
		array(
			'id'=>'header-select-menu-switch',
			'type' => 'switch', 
			'title' => esc_html__('Use select responsive menu instead default?', 'sliva'),
			'subtitle'=> esc_html__('If on and avaliable, responsive menu will be displayed in a select instead default.', 'sliva'),
			'desc' => esc_html__('Useful to single page layouts or small menus.', 'sliva'),
			'default' => 0,
		),

		array(
			'id' => 'random-number',
			'type' => 'info',
			'desc' => esc_html__('Logo Module Configuration.', 'sliva')
		),

		array(
			'id'=>'logo',
			'type' => 'media', 
			'url' => true,
			'title' => esc_html__('Logo', 'sliva'),
			'subtitle' => esc_html__('Upload the logo that will be displayed in the header.', 'sliva'),
		),

			array(
				'id'=>'logo-retina',
				'type' => 'media', 
				'url'=> true,
				'title' => esc_html__('Logo Retina', 'sliva'),
				'desc'=> esc_html__('The same logo image but with twice dimensions, e.g. your logo is 100x100, then your retina logo must be 200x200.', 'sliva'),
				'subtitle' => esc_html__('Optional retina version displayed in devices with retina display (high resolution display).', 'sliva'),
				'required' => array( 'logo', '!=', null ),
				),

			//Overwrite logo margins if user wants
			array(
				'id'=>'header-logo-spacing',
				'type' => 'spacing_mod',
				'output' => array('.logo'), // Our theme uses custom output for this field
				'mode'=> 'margin', // absolute, padding, margin, defaults to padding
				'right' => false, // Disable the right
				'units' => 'px', // You can specify a unit value. Possible: px, em, %
				'title' => esc_html__('Logo Margin', 'sliva'),
				'subtitle' => esc_html__('Select a custom margin to the be applied in the logo.', 'sliva'),
				'desc' => esc_html__('If not set, default margin will be applied by theme.', 'sliva'),
				'default' => array(),
				'required' => array( 'logo', '!=', null ),
			),

		array(
			'id'=>'header-logo-light-switch',
			'type' => 'switch', 
			'title' => esc_html__('Light Logo', 'sliva'),
			'subtitle'=> esc_html__('Turn on to upload a light version of logo used in dark backgrounds.', 'sliva'),
			'default' => 0,
		),

		array(
			'id'=>'logo-light',
			'type' => 'media', 
			'url' => true,
			'title' => esc_html__('Logo (light)', 'sliva'),
			'subtitle' => esc_html__('Upload the logo that will be displayed in the header.', 'sliva'),
			'required' => array( 'header-logo-light-switch', '=', 1 ),
		),

			array(
				'id'=>'logo-retina-light',
				'type' => 'media', 
				'url'=> true,
				'title' => esc_html__('Logo Retina (light)', 'sliva'),
				'desc'=> esc_html__('The same logo image but with twice dimensions, e.g. your logo is 100x100, then your retina logo must be 200x200.', 'sliva'),
				'subtitle' => esc_html__('Optional retina version displayed in devices with retina display (high resolution display).', 'sliva'),
				'required' => array( 'logo-light', '!=', null ),
				),

		array(
			'id'=>'header-logo-dark-switch',
			'type' => 'switch', 
			'title' => esc_html__('Dark Logo', 'sliva'),
			'subtitle'=> esc_html__('Turn on to upload a dark version of logo used in light backgrounds.', 'sliva'),
			'default' => 0,
		),

		array(
			'id'=>'logo-dark',
			'type' => 'media', 
			'url' => true,
			'title' => esc_html__('Logo (dark)', 'sliva'),
			'subtitle' => esc_html__('Upload the logo that will be displayed in the header.', 'sliva'),
			'required' => array( 'header-logo-dark-switch', '=', 1 ),
		),

			array(
				'id'=>'logo-retina-dark',
				'type' => 'media', 
				'url'=> true,
				'title' => esc_html__('Logo Retina (dark)', 'sliva'),
				'desc'=> esc_html__('The same logo image but with twice dimensions, e.g. your logo is 100x100, then your retina logo must be 200x200.', 'sliva'),
				'subtitle' => esc_html__('Optional retina version displayed in devices with retina display (high resolution display).', 'sliva'),
				'required' => array( 'logo-dark', '!=', null ),
				),

		array(
			'id' => 'random-number',
			'type' => 'info',
			'desc' => esc_html__('Logo Dimensions', 'sliva')
		),

		array(
			'id' => 'header-logo-lg',
			'type' => 'slider',
			'title' => esc_html__('Logo Columns (Large)', 'sliva'),
			'desc' => esc_html__('Define how many columns of header is occupied by the logo in larger devices. More than 1200px.', 'sliva'),
			'subtitle' => esc_html__('Do not use too big values because this can break the layout.', 'sliva'),
			"default" => "2",
			"min" => "1",
			"step" => "1",
			"max" => "8",
		),

		array(
			'id' => 'header-logo-md',
			'type' => 'slider',
			'title' => esc_html__('Logo Columns (Medium)', 'sliva'),
			'desc' => esc_html__('Define how many columns of header is occupied by the logo in normal devices. More than 991px.', 'sliva'),
			'subtitle' => esc_html__('Do not use too big values because this can break the layout.', 'sliva'),
			"default" => "2",
			"min" => "1",
			"step" => "1",
			"max" => "8",
		),

		array(
			'id' => 'header-logo-sm',
			'type' => 'slider',
			'title' => esc_html__('Logo Columns (Tablets)', 'sliva'),
			'desc' => esc_html__('Define how many columns of header is occupied by the logo in tablet devices. Smaller than 991px. ', 'sliva'),
			'subtitle' => esc_html__('Do not use too big values because this can break the layout.', 'sliva'),
			"default" => "2",
			"min" => "1",
			"step" => "1",
			"max" => "8",
		),

		array(
			'id' => 'header-logo-xs',
			'type' => 'slider',
			'title' => esc_html__('Logo Columns (Mobile)', 'sliva'),
			'desc' => esc_html__('Define how many columns of header is occupied by the logo in small mobile devices. Smaller than 768px.', 'sliva'),
			'subtitle' => esc_html__('Do not use too big values because this can break the layout.', 'sliva'),
			"default" => "4",
			"min" => "1",
			"step" => "1",
			"max" => "8",
		),

		array(
			'id' => 'random-number',
			'type' => 'info',
			'desc' => esc_html__('Woo Cart Module Configuration.', 'sliva')
		),

		array(
			'id'=>'header-woo-cart-switch',
			'type' => 'switch', 
			'title' => esc_html__('Woo Cart', 'sliva'),
			'subtitle'=> esc_html__('If on, a WooCommerce cart will be displayed. Requires WooCommerce plugin activated.', 'sliva'),
			'default' => 1,
		),
		
		array(
			'id'=>'header-woo-cart-total-switch',
			'type' => 'switch', 
			'title' => esc_html__('Woo Cart Total', 'sliva'),
			'subtitle'=> esc_html__('If on, a WooCommerce cart will be displayed with total value of products in the cart. Requires WooCommerce plugin activated.', 'sliva'),
			'default' => 0,
		),
		
		array(
			'id'=>'header-woo-cart-layout',
			'type' => 'select',
			'title' => esc_html__('Woo Cart Layout', 'sliva'),
			'desc' => esc_html__('Cart layout.', 'sliva'),
			'subtitle' => esc_html__('Select the cart layout to be used in the header and top header', 'sliva'),
			'options' => array( 
				'default' => 'Default',
				'alternative' => 'Alternative',
			),
			'default' => ''
			),
		
		array(
			'id' => 'random-number',
			'type' => 'info',
			'desc' => esc_html__('Login AJAX Module Configuration.', 'sliva')
		),

		array(
			'id'=>'header-login-ajax-switch',
			'type' => 'switch', 
			'title' => esc_html__('Login AJAX', 'sliva'),
			'subtitle'=> esc_html__('If on, a Login AJAX will be displayed. Requires Login With Ajax plugin activated.', 'sliva'),
			'default' => 1,
		),

		array(
			'id' => 'random-number',
			'type' => 'info',
			'desc' => esc_html__('Search Module Configuration.', 'sliva')
		),

		array(
			'id'=>'header-search-switch',
			'type' => 'switch', 
			'title' => esc_html__('Search', 'sliva'),
			'subtitle'=> esc_html__('If on, a search module will be displayed.', 'sliva'),
			'default' => 1,
		),
		
		array(
			'id'=>'header-search-style',
			'type' => 'select',
			'title' => esc_html__('Search Style', 'sliva'), 
			'subtitle' => esc_html__('Select the search style.', 'sliva'),
			'options' => array( 
					'search-top-style' => 'Top',
					'search-full-screen-alt-style' => 'Full Screen',
			 ),
			'default' => 'search-top-style',
			'validate' => 'not_empty',
			'required' => array( 'header-search-switch', '=', 1 ),
		),

		array(
			'id' => 'random-number',
			'type' => 'info',
			'desc' => esc_html__('Text Module Configuration.', 'sliva')
		),

		array(
			'id'=>'header-text-switch',
			'type' => 'switch', 
			'title' => esc_html__('Text Module', 'sliva'),
			'subtitle'=> esc_html__('If on, a rich text module will be displayed.', 'sliva'),
			'default' => 0,
		),

			array(
				'id' => 'header-text-content',
				'type' => 'editor',
				'title' => esc_html__('Text Module Content', 'sliva'),
				'subtitle' => esc_html__('Place any text or shortcode to be displayed in header. Use [iv_separator] to add a separator in the text. Use [iv_icon icon="cogs"] to display Font Awesome icons. Use [iv_flags] to add WPML flags.', 'sliva'),
				'default' => '[iv_icon icon="phone"] 9854-888-021 <br />[iv_icon icon="home"] New York, NY',
				'required' => array( 'header-text-switch', '=', 1 ),
			),

		array(
			'id' => 'random-number',
			'type' => 'info',
			'desc' => esc_html__('Social Module Configuration.', 'sliva')
		),

		array(
			'id'=>'header-social-switch',
			'type' => 'switch', 
			'title' => esc_html__('Social Module', 'sliva'),
			'subtitle'=> esc_html__('If on, a social icon module will be displayed.', 'sliva'),
			'default' => 0,
		),

			array(
				'id' => 'header-social-icons',
				'type' => 'social_select',
				'title' => esc_html__('Social Icons', 'sliva'),
				'subtitle' => esc_html__('Add and organize the icons to be displayed.', 'sliva'),
				'required' => array( 'header-social-switch', '=', 1 ),
				'placeholder' => array(
					'title' => esc_html__('Social Media URL', 'sliva'),
				),
			),

		array(
			'id' => 'random-number',
			'type' => 'info',
			'desc' => esc_html__('Menu Module Configuration.', 'sliva')
		),

		array(
			'id'=>'header-menu-module-switch',
			'type' => 'switch', 
			'title' => esc_html__('Header Menu Module', 'sliva'),
			'subtitle'=> esc_html__('If on, a additional menu will be displayed together with modules.', 'sliva'),
			'default' => 0,
		),

		array(
			'id' => 'random-number',
			'type' => 'info',
			'desc' => esc_html__('Ads Module Configuration.', 'sliva')
		),

		array(
			'id'=>'header-ads-switch',
			'type' => 'switch', 
			'title' => esc_html__('Ads Module', 'sliva'),
			'subtitle'=> esc_html__('If on, a ads module will be displayed. Note that it is not avaliable to all layouts.', 'sliva'),
			'default' => 0,
		),

			array(
				'id' => 'header-ads-content',
				'type' => 'textarea',
				'title' => esc_html__('Ads Module Content', 'sliva'),
				'subtitle' => esc_html__('Place your Ads code, it supports HTML code as well or even JavaScript.', 'sliva'),
				'default' => '',
				'required' => array( 'header-ads-switch', '=', 1 ),
				'validate' => false,
			),

		array(
			'id' => 'random-number',
			'type' => 'info',
			'desc' => esc_html__('WPML Modules', 'sliva')
		),
		array(
			'id'=>'header-wpml-lang-dropdown',
			'type' => 'switch', 
			'title' => esc_html__('WPML Language Dropdown', 'sliva'),
			'subtitle'=> esc_html__('If on, the avaliable languages will be displayed. Only works with WPML activated.', 'sliva'),
			"default" => 0,
			'required' => array(
				array( 'header-layout', '=','Ivan_Layout_Header_Two_Rows' ),
				array( 'header-layout', '=','Ivan_Layout_Header_Two_Rows_Style2' )
			),
		),
		
		array(
			'id' => 'random-number-sideheader',
			'type' => 'info',
			'desc' => esc_html__('Sidebar Switcher Module Configuration.', 'sliva'),
			'required' => array('header-layout','=', 'Ivan_Layout_Header_Horizontal_With_Sidebar')
		),
		
		array(
			'id'=>'header-disable-main-sidebar-switcher',
			'type' => 'switch', 
			'title' => esc_html__('Disable Sidebar Switcher', 'sliva'),
			'subtitle'=> esc_html__('If on, a sidebar switcher will not be displayed. Note that it is not avaliable to all layouts.', 'sliva'),
			'default' => 0,
			'required' => array('header-layout','=', 'Ivan_Layout_Header_Horizontal_With_Sidebar')
		),
		
		array(
			'id' => 'random-number-textareas',
			'type' => 'info',
			'desc' => esc_html__('Text areas used for Dark Menu', 'sliva'),
			'required' => array('header-layout','=','Ivan_Layout_Dark_Menu')
		),
		array(
			'id' => 'header-text-area-1',
			'type' => 'textarea',
			'title' => esc_html__('Textarea 1', 'sliva'),
			'subtitle' => esc_html__('Place any text or shortcode to be displayed in header eg. [ivan_contact_info icon="home" title="..." subtitle="..." link="..."]. ', 'sliva'),
			'default' => '',
			'required' => array('header-layout','=','Ivan_Layout_Dark_Menu')
		),

		array(
			'id' => 'header-text-area-2',
			'type' => 'textarea',
			'title' => esc_html__('Textarea 2', 'sliva'),
			'subtitle' => esc_html__('Place any text or shortcode to be displayed in header eg. [ivan_contact_info icon="home" title="..." subtitle="..." link="..."]. ', 'sliva'),
			'default' => '',
			'required' => array('header-layout','=','Ivan_Layout_Dark_Menu')
		),

		array(
			'id' => 'header-text-area-3',
			'type' => 'textarea',
			'title' => esc_html__('Textarea 3', 'sliva'),
			'subtitle' => esc_html__('Place any text or shortcode to be displayed in header eg. [ivan_contact_info icon="home" title="..." subtitle="..." link="..."]. ', 'sliva'),
			'default' => '',
			'required' => array('header-layout','=','Ivan_Layout_Dark_Menu')
		),
		array(
			'id'=>'header-text-area-icons-color',
			'type' => 'color', 
			'title' => esc_html__('Icons Color', 'sliva'),
			'required' => array(
				array('header-layout', '=', 'Ivan_Layout_Dark_Menu'),
			),
			'output' => array(
				'color' => '
					.header.style5 .mid-header .contact-info-container .contact-info .icon-container
			'),
			'validate' => 'color',
		),
	
		array(
			'id' => 'random-header-da',
			'type' => 'info',
			'desc' => esc_html__('Dynamic Area', 'sliva')
		),

		array(
			'id'=>'header-da-after-enable',
			'type' => 'switch', 
			'title' => esc_html__('Enable Dynamic Area After Header?', 'sliva'),
			'subtitle'=> esc_html__('If on, a dynamic area will be displayed after header.', 'sliva'),
			"default" => 0,
		),

		array(
			'id'=>'header-da-after',
			'type' => 'select',
			'title' => esc_html__('After Header Dynamic Content Page', 'sliva'), 
			'subtitle' => esc_html__('Select the page from where the content will be loaded and displayed.', 'sliva'),
			'data' => 'pages',
			'required' => array( 'header-da-after-enable', '=', 1),
		),

		array(
			'id'=>'header-da-after-blog',
			'type' => 'select',
			'title' => esc_html__('Blog: Header Dynamic Content', 'sliva'), 
			'subtitle' => esc_html__('Select the page from where the content will be loaded and displayed. Displayed only at blog.', 'sliva'),
			'data' => 'pages',
			'required' => array( 'header-da-after-enable', '=', 1),
		),

		array(
			'id'=>'header-da-after-single',
			'type' => 'select',
			'title' => esc_html__('Single: Header Dynamic Content', 'sliva'), 
			'subtitle' => esc_html__('Select the page from where the content will be loaded and displayed. Displayed only at single.', 'sliva'),
			'data' => 'pages',
			'required' => array( 'header-da-after-enable', '=', 1),
		),

		array(
			'id'=>'header-da-after-shop',
			'type' => 'select',
			'title' => esc_html__('Shop: Header Dynamic Content', 'sliva'), 
			'subtitle' => esc_html__('Select the page from where the content will be loaded and displayed. Displayed only at shop.', 'sliva'),
			'data' => 'pages',
			'required' => array( 'header-da-after-enable', '=', 1),
		),

		array(
			'id'=>'header-da-after-single-product',
			'type' => 'select',
			'title' => esc_html__('Product: Header Dynamic Content', 'sliva'), 
			'subtitle' => esc_html__('Select the page from where the content will be loaded and displayed. Displayed only at product.', 'sliva'),
			'data' => 'pages',
			'required' => array( 'header-da-after-enable', '=', 1),
		),

	), // #fields
);