<?php
/*
 * General Section
*/

$this->sections[] = array(
	'title' => esc_html__('General Settings', 'sliva'),
	'desc' => esc_html__('Configure easily the basic theme\'s settings.', 'sliva'),
	'icon' => 'el-icon-magic',
	'fields' => array(

		array(
			'id'=>'page-comments-switch',
			'type' => 'switch', 
			'title' => esc_html__('Enable Comments in Pages?', 'sliva'),
			'subtitle'=> esc_html__('If on, the comment form will be avaliable in all pages.', 'sliva'),
			'default' => 1,
		),
		
		array(
			'id'=>'search-shop-switch',
			'type' => 'switch', 
			'title' => esc_html__('Enable Shop Search instead default Search?', 'sliva'),
			'subtitle'=> esc_html__('If on, the search forms of Live Search modules will be for shop products instead default.', 'sliva'),
			'default' => 0,
		),

		array(
			'id'=>'enable-preloader',
			'type' => 'switch', 
			'title' => esc_html__('Enable Loader Effect?', 'sliva'),
			'subtitle'=> esc_html__('If on, a loader will appear before loading the page.', 'sliva'),
			'default' => 0,
		),
		
		array(
			'id'=>'preloader-style',
			'type' => 'select', 
			'title' => esc_html__('Loader Style', 'sliva'),
			'subtitle'=> esc_html__('Select loader style.', 'sliva'),
			'options' => array(
				'default' => esc_html__('Default', 'sliva'),
			),
			'default' => 'default',
			'required' => array('enable-preloader','=',	1)
		),
		array(
			'id'=>'preloader-background-color',
			'type' => 'color', 
			'title' => esc_html__('Loader Background Color', 'sliva'),
			'subtitle'=> esc_html__('Background color of the loder overlay.', 'sliva'),
			'output' => array('background-color' => '#page-loader.page-loader-style2'),
			'default' => '',
			'required' => array('preloader-style','=', array('style2') )
		),
		array(
			'id'=>'preloader-text',
			'type' => 'text', 
			'title' => esc_html__('Loader Text', 'sliva'),
			'subtitle'=> esc_html__('Text displayed inside loader.', 'sliva'),
			'default' => '',
			'required' => array('preloader-style','=','style2')
		),
		array(
			'id'=>'disable-responsiveness',
			'type' => 'switch', 
			'title' => esc_html__('Disable Responsive Layout?', 'sliva'),
			'subtitle'=> esc_html__('If on, the website will not adapt in smaller devices like tablets or smartphones.', 'sliva'),
			'default' => 0,
		),

		array(
			'id'=>'clear-static-files',
			'type' => 'switch', 
			'title' => esc_html__('Clear Static Files Query String', 'sliva'),
			'subtitle'=> esc_html__('If enabled qeury string variable "ver" will be removed from query string for JS and CSS files.', 'sliva'),
			'default' => 0,
		),

		array(
 			'id'=>'character-sets',
 			'type' => 'checkbox',
 			'title' => esc_html__('Additional Google Fonts character sets', 'sliva'),
 			'subtitle'=> esc_html__('Choose the character sets you want to download from Google Fonts.', 'sliva'),
 			'options' => array(
				'cyrillic' => esc_html__('Cyrillic','sliva'),
				'cyrillic-ext' => esc_html__('Cyrillic Extended','sliva'),
				'greek' => esc_html__('Greek','sliva'),
				'greek-ext' => esc_html__('Greek Extended','sliva'),
				'latin-ext' => esc_html__('Latin Extended','sliva'),
				'vietnamese' => esc_html__('Vietnamese','sliva'),
			),
			'default' => '',
			'validate' => '',
 		),
	),
);