<?php
/*
 * Layout Section
*/

$this->sections[] = array(
	'title' => esc_html__('Top Header', 'sliva'),
	'desc' => esc_html__('Change the top header section configuration.', 'sliva'),
	'icon' => 'el-icon-cog',
	'fields' => array(

		array(
			'id'=>'top-header-enable-switch',
			'type' => 'switch', 
			'title' => esc_html__('Disable this layout part?', 'sliva'),
			'subtitle'=> esc_html__('If on, this layout part will not be displayed.', 'sliva'),
			"default" => 1,
		),
		
		array(
			'id'=>'top-header-variant',
			'type' => 'select',
			'title' => esc_html__('Top Header Style', 'sliva'), 
			'subtitle' => esc_html__('Select the top syle to be used at header.', 'sliva'),
			'options' => array( 
					'default' => 'Dark',
					'alternative-dark' => 'Color',
					'alternative-light' => 'Light',
			 ),
			'default' => 'alternative-light',
			'validate' => 'not_empty',
		),
		
		array(
			'id'=>'top-header-layout',
			'type' => 'select',
			'title' => esc_html__('Top Header Layout', 'sliva'), 
			'subtitle' => esc_html__('Select the top layout to be used at header.', 'sliva'),
			'options' => apply_filters('ivan_top_header_layouts', array( 
					'Ivan_Layout_Top_Header_Two_Columns' => 'Two Columns',
					) ),
			'default' => 'Ivan_Layout_Top_Header_Two_Columns',
			'validate' => 'not_empty',
		),

		array(
			'id' => 'top-header-left-width',
			'type' => 'slider',
			'title' => esc_html__('Left Area Width', 'sliva'),
			'desc' => esc_html__('Define columns number of top header left side.', 'sliva'),
			'subtitle' => esc_html__('The left and right side combined should not be greater than 12! Otherwise the layout will break.', 'sliva'),
			"default" => "4",
			"min" => "1",
			"step" => "1",
			"max" => "11",
		),

		array(
			'id' => 'top-header-right-width',
			'type' => 'slider',
			'title' => esc_html__('Right Area Width', 'sliva'),
			'desc' => esc_html__('Define columns number of top header left side.', 'sliva'),
			'subtitle' => esc_html__('The left and right side combined should not be greater than 12! Otherwise the layout will break.', 'sliva'),
			"default" => "8",
			"min" => "1",
			"step" => "1",
			"max" => "11",
		),

		array(
			'id'=>'top-header-menu-disable',
			'type' => 'switch', 
			'title' => esc_html__('Disable Menu?', 'sliva'),
			'subtitle'=> esc_html__('If on, menu will not be displayed.', 'sliva'),
			"default" => 1,
		),

		array(
			'id'=>'top-header-menu-left-switch',
			'type' => 'switch', 
			'title' => esc_html__('Display Menu at Left Area', 'sliva'),
			'subtitle'=> esc_html__('If on, menu will display at left side of top header.', 'sliva'),
			"default" => 0,
			'required' => array( 'top-header-menu-disable', '=', 0),
		),

		array(
			'id'=>'top-header-v-sign-switch',
			'type' => 'switch', 
			'title' => esc_html__('Menu Arrow', 'sliva'),
			'subtitle'=> esc_html__('If on, menu items will get a arrow after text.', 'sliva'),
			"default" => 0,
			'required' => array( 'top-header-menu-disable', '=', 0),
		),

		array(
			'id' => 'random-number',
			'type' => 'info',
			'desc' => esc_html__('Woo Cart Module Configuration.', 'sliva')
		),

		array(
			'id'=>'top-header-woo-cart-switch',
			'type' => 'switch', 
			'title' => esc_html__('Woo Cart', 'sliva'),
			'subtitle'=> esc_html__('If on, a WooCommerce cart will be displayed. Requires WooCommerce plugin activated.', 'sliva'),
			"default" => 1,
		),

		array(
			'id' => 'random-number',
			'type' => 'info',
			'desc' => esc_html__('Login AJAX Module Configuration.', 'sliva')
		),

		array(
			'id'=>'top-header-login-ajax-switch',
			'type' => 'switch', 
			'title' => esc_html__('Login AJAX', 'sliva'),
			'subtitle'=> esc_html__('If on, a Login AJAX will be displayed. Requires Login With Ajax plugin activated.', 'sliva'),
			"default" => 1,
		),

		array(
			'id' => 'random-number',
			'type' => 'info',
			'desc' => esc_html__('Search Module Configuration.', 'sliva')
		),

		array(
			'id'=>'top-header-search-switch',
			'type' => 'switch', 
			'title' => esc_html__('Search', 'sliva'),
			'subtitle'=> esc_html__('If on, a search module will be displayed.', 'sliva'),
			"default" => 1,
		),
		
		array(
			'id'=>'top-header-search-style',
			'type' => 'select',
			'title' => esc_html__('Search Style', 'sliva'), 
			'subtitle' => esc_html__('Select the search style.', 'sliva'),
			'options' => array( 
					'default' => 'Default',
					'search-top-style' => 'Top',
					'search-full-screen-style' => 'Full Screen',
					'search-full-screen-alt-style' => 'Full Screen Alternative',
			 ),
			'default' => 'default',
			'validate' => 'not_empty',
			'required' => array( 'top-header-search-switch', '=', 1 ),
		),

		array(
			'id' => 'random-number',
			'type' => 'info',
			'desc' => esc_html__('Text Module Configuration.', 'sliva')
		),

		array(
			'id'=>'top-header-text-switch',
			'type' => 'switch', 
			'title' => esc_html__('Text Module', 'sliva'),
			'subtitle'=> esc_html__('If on, a rich text module will be displayed.', 'sliva'),
			"default" => 0,
		),

			array(
				'id' => 'top-header-text-content',
				'type' => 'editor',
				'title' => esc_html__('Text Module Content', 'sliva'),
				'subtitle' => esc_html__('Place any text or shortcode to be displayed in header. Use [iv_separator] to add a separator in the text. Use [iv_icon icon="cogs"] to display Font Awesome icons. Use [iv_flags] to add WPML flags.', 'sliva'),
				'default' => '[iv_icon icon="phone"] 9854-888-021 [iv_separator] [iv_icon icon="home"] New York, NY',
				'required' => array( 'top-header-text-switch', '=', 1 ),
			),

		array(
			'id' => 'random-number',
			'type' => 'info',
			'desc' => esc_html__('Social Module Configuration.', 'sliva')
		),

		array(
			'id'=>'top-header-social-switch',
			'type' => 'switch', 
			'title' => esc_html__('Social Module', 'sliva'),
			'subtitle'=> esc_html__('If on, a social icon module will be displayed.', 'sliva'),
			"default" => 0,
		),

			array(
				'id' => 'top-header-social-icons',
				'type' => 'social_select',
				'title' => esc_html__('Social Icons', 'sliva'),
				'subtitle' => esc_html__('Add and organize the icons to be displayed.', 'sliva'),
				'required' => array( 'top-header-social-switch', '=', 1 ),
				'placeholder' => array(
					'title' => esc_html__('Social Media URL', 'sliva'),
				),
			),

		array(
			'id' => 'random-number',
			'type' => 'info',
			'desc' => esc_html__('WPML Modules', 'sliva')
		),

			array(
				'id'=>'top-header-wpml-lang-switch',
				'type' => 'switch', 
				'title' => esc_html__('WPML Language Flags', 'sliva'),
				'subtitle'=> esc_html__('If on, the avaliable languages flags will be displayed. Only works with WPML activated.', 'sliva'),
				"default" => 0,
			),

			array(
				'id'=>'top-header-wpml-currency-switch',
				'type' => 'switch', 
				'title' => esc_html__('WPML Shop Currencies', 'sliva'),
				'subtitle'=> esc_html__('If on, the avaliable currencies flags will be displayed. Only works with WPML + WooCommerce Multilingual activated.', 'sliva'),
				"default" => 0,
			),

	), // #fields
);