<?php
/*
 * Layout Section
*/

$this->sections[] = array(
	'title' => esc_html__('Title Wrapper', 'sliva'),
	'desc' => esc_html__('Change the title wrapper section configuration.', 'sliva'),
	'icon' => 'el-icon-cog',
	'fields' => array(

		array(
			'id'=>'title-wrapper-enable-switch',
			'type' => 'switch', 
			'title' => esc_html__('Disable this layout part?', 'sliva'),
			'subtitle'=> esc_html__('If on, this layout part will not be displayed.', 'sliva'),
			"default" => 0,
		),

		array(
			'id'=>'title-wrapper-layout',
			'type' => 'select',
			'title' => esc_html__('Title Wrapper Layout', 'sliva'), 
			'subtitle' => esc_html__('Select the top layout to be used at title wrapper.', 'sliva'),
			'options' => apply_filters('ivan_title_wrapper_layouts', array( 
					'Ivan_Layout_Title_Wrapper_Normal' => 'Classic with Description Text',
					'Ivan_Layout_Title_Wrapper_Large' => 'Large with Description Text',
					) ),
			'default' => 'Ivan_Layout_Title_Wrapper_Normal',
			'validate' => 'not_empty',
		),

		array(
			'id'=>'title-large-align',
			'type' => 'switch', 
			'title' => esc_html__('Align Large Title to Left?', 'sliva'),
			'subtitle'=> esc_html__('If on, the large title wrapper layout will be aligned to left.', 'sliva'),
			"default" => 0,
			'required' => array( 'title-wrapper-layout', '=', array('Ivan_Layout_Title_Wrapper_Large') ),
		),

		array(
			'id'=>'title-large-opacity',
			'type' => 'switch', 
			'title' => esc_html__('Overlay', 'sliva'),
			'subtitle'=> esc_html__('Best for light photos.', 'sliva'),
			"default" => 0,
			'required' => array( 'title-wrapper-layout', '=', array('Ivan_Layout_Title_Wrapper_Large') ),
		),
		
		array(
			'id'=>'breadcrumb-enable',
			'type' => 'switch', 
			'title' => esc_html__('Enable Breadcrumb?', 'sliva'),
			'subtitle'=> esc_html__('If on, a breadcrumb will be displayed aside of title wrapper.', 'sliva'),
			"default" => 1,
			'required' => array( 'title-wrapper-layout', '=', array('Ivan_Layout_Title_Wrapper_Normal') ),
		),
		array(
			'id'=>'search-enable',
			'type' => 'switch', 
			'title' => esc_html__('Enable Search?', 'sliva'),
			'subtitle'=> esc_html__('If on, a search form will be displayed aside of title wrapper.', 'sliva'),
			"default" => 1,
			'required' => array( 'title-wrapper-layout', '=', array('Ivan_Layout_Title_Wrapper_Normal') ),
		),
		array(
			'id'=>'breadcrumb-proj-disable',
			'type' => 'switch', 
			'title' => esc_html__('Disable Projects Breadcrumb?', 'sliva'),
			'subtitle'=> esc_html__('If on, breadcrumbs will not be displayed in projects.', 'sliva'),
			"default" => 0,
			'required' => array( 'breadcrumb-enable', '=', true ),
		),

		array(
			'id'=>'breadcrumb-shop-disable',
			'type' => 'switch', 
			'title' => esc_html__('Disable Shop Breadcrumb?', 'sliva'),
			'subtitle'=> esc_html__('If on, breadcrumbs will not be displayed in shop pages.', 'sliva'),
			"default" => 0,
		),

		array(
			'id' => 'random-number',
			'type' => 'info',
			'desc' => esc_html__('Default Titles.', 'sliva')
		),

		array(
			'id' => 'title-text-blog',
			'type' => 'text',
			'title' => esc_html__('Default Blog Title', 'sliva'),
			'subtitle' => esc_html__('Title used in index post listing.', 'sliva'),
			'default' => 'Our Blog',
			'validate' => 'not_empty',
		),

		array(
			'id' => 'title-desc-blog',
			'type' => 'textarea',
			'title' => esc_html__('Default Blog Description', 'sliva'),
			'subtitle' => esc_html__('Place any text or shortcode to be displayed below blog title.', 'sliva'),
			'validate' => 'html_custom',
			'allowed_html' => array(
					'a' => array(
						'href' => array(),
						'title' => array(),
						'target' => array(),
					),
					'br' => array(),
					'em' => array(),
					'strong' => array()
				),
			'default' => '',
		),

		array(
			'id' => 'title-text-shop',
			'type' => 'text',
			'title' => esc_html__('Default Shop Title', 'sliva'),
			'subtitle' => esc_html__('Title used in single product title when avaliable.', 'sliva'),
			'default' => 'Our Shop',
			'validate' => 'not_empty',
		),

		array(
			'id' => 'title-desc-shop',
			'type' => 'textarea',
			'title' => esc_html__('Default Shop Description', 'sliva'),
			'subtitle' => esc_html__('Place any text or shortcode to be displayed below shop title.', 'sliva'),
			'validate' => 'html_custom',
			'allowed_html' => array(
					'a' => array(
						'href' => array(),
						'title' => array(),
						'target' => array(),
					),
					'br' => array(),
					'em' => array(),
					'strong' => array()
				),
			'default' => '',
		),

	), // #fields
);