<?php
/*
 * Templates Section
*/

$this->sections[] = array(
	'title' => esc_html__('Single', 'sliva'),
	'desc' => esc_html__('Change single post templates.', 'sliva'),
	'icon' => 'el-icon-screen',
	'fields' => array(

		array(
			'id' => 'random-templates',
			'type' => 'info',
			'desc' => esc_html__('Single Post.', 'sliva')
		),

		/* Base Layouts */
		array(
			'id'=>'single-layout',
			'type' => 'select',
			'title' => esc_html__('Base Layout', 'sliva'), 
			'subtitle' => esc_html__('Select the layout to be used in blog.', 'sliva'),
			'options' => apply_filters('ivan_single_base_layouts', array( 
				'large' => 'Large',
				) ),
			'default' => 'large',
			'validate' => 'not_empty',
		),

			/* Sub Layouts > Large */
			array(
				'id'=> 'single-sub-large',
				'type' => 'select',
				'title' => esc_html__('Layout Style', 'sliva'), 
				'subtitle' => esc_html__('Select the layout style to be applied in the blog posts.', 'sliva'),
				'options' => apply_filters('ivan_single_large_layouts', array( 
					'simple' => "Simple",
					) ),
				'default' => 'simple',
				'required' => array( 'single-layout', '=', array('large') ),
			),

		array(
			'id'=>'single-reduced-width',
			'type' => 'switch', 
			'title' => esc_html__('Use Reduced Width?', 'sliva'),
			'subtitle'=> esc_html__('If on, the post will use reduced width. Recommended to full single layout.', 'sliva'),
			"default" => 0,
		),

		array(
			'id'=>'single-sidebar-right',
			'type' => 'switch', 
			'title' => esc_html__('Enable Sidebar at Right?', 'sliva'),
			'subtitle'=> esc_html__('If on, sidebar will be displayed in the specified location.', 'sliva'),
			"default" => 1,
		),

		array(
			'id'=>'single-sidebar-left',
			'type' => 'switch', 
			'title' => esc_html__('Enable Sidebar at Left?', 'sliva'),
			'subtitle'=> esc_html__('If on, sidebar will be displayed in the specified location.', 'sliva'),
			"default" => 0,
		),

		array(
			'id'=>'single-disable-title',
			'type' => 'switch', 
			'title' => esc_html__('Disable Title Wrapper?', 'sliva'),
			'subtitle'=> esc_html__('If on, title wrapper will not be displayed.', 'sliva'),
			"default" => 0,
		),

		array(
			'id'=>'single-boxed-page',
			'type' => 'switch', 
			'title' => esc_html__('Display Single Boxed?', 'sliva'),
			'subtitle'=> esc_html__('If on, the single will be displayed in a boxed layout.', 'sliva'),
			"default" => 0,
		),

		array(
			'id' => 'random-templates',
			'type' => 'info',
			'desc' => esc_html__('Effects/Additional Styles', 'sliva')
		),

		array(
			'id'=>'single-disable-thumb',
			'type' => 'switch', 
			'title' => esc_html__('Disable Thumbnails?', 'sliva'),
			'subtitle'=> esc_html__('If on, thumbnails will not be displayed in single post.', 'sliva'),
			"default" => 0,
		),

		array(
			'id' => 'random-templates',
			'type' => 'info',
			'desc' => esc_html__('Components', 'sliva')
		),

		array(
			'id'=>'single-post-nav',
			'type' => 'switch', 
			'title' => esc_html__('Enable Post Navigation?', 'sliva'),
			'subtitle'=> esc_html__('If on, navigation will be displayed below content.', 'sliva'),
			"default" => 1,
		),

		array(
			'id'=>'single-author-box',
			'type' => 'switch', 
			'title' => esc_html__('Enable author box?', 'sliva'),
			'subtitle'=> esc_html__('If on, the author box with details and social icons will be displayed.', 'sliva'),
			"default" => 0,
		),

		array(
			'id'=>'single-related',
			'type' => 'switch', 
			'title' => esc_html__('Enable Related Posts?', 'sliva'),
			'subtitle'=> esc_html__('If on, the related posts box will be displayed.', 'sliva'),
			"default" => 0,
		),

		array(
			'id'=>'single-tags',
			'type' => 'switch', 
			'title' => esc_html__('Enable Tags after Content?', 'sliva'),
			'subtitle'=> esc_html__('If on, the tags will be displayed after post content.', 'sliva'),
			"default" => 1,
		),

		array(
			'id' => 'random-templates',
			'type' => 'info',
			'desc' => esc_html__('Single Project', 'sliva')
		),

		array(
			'id'=>'project-nav',
			'type' => 'switch', 
			'title' => esc_html__('Display Navigation in Projects?', 'sliva'),
			'subtitle'=> esc_html__('If on, next and previous project will be displayed in single project pages.', 'sliva'),
			"default" => 1,
		),

		array(
			'id'=>'project-related',
			'type' => 'switch', 
			'title' => esc_html__('Display Related Projects?', 'sliva'),
			'subtitle'=> esc_html__('If on, the related projects will be displayed below project contents.', 'sliva'),
			"default" => 1,
		),

		array(
			'id' => 'random-single',
			'type' => 'info',
			'desc' => esc_html__('Dynamic Area', 'sliva')
		),

		array(
			'id'=>'single-da-after-enable',
			'type' => 'switch', 
			'title' => esc_html__('Enable Dynamic Area After Post Content?', 'sliva'),
			'subtitle'=> esc_html__('If on, a dynamic area will be displayed after post contents. Great to a newsletter form!', 'sliva'),
			"default" => 0,
		),

		array(
			'id'=>'single-da-after',
			'type' => 'select',
			'title' => esc_html__('After Content Dynamic Content Page', 'sliva'), 
			'subtitle' => esc_html__('Select the page from where the content will be loaded and displayed.', 'sliva'),
			'data' => 'pages',
			'required' => array( 'single-da-after-enable', '=', 1),
		),

		array(
			'id' => 'random-templates',
			'type' => 'info',
			'desc' => esc_html__('Advanced Configuration', 'sliva')
		),

		array(
			'id'=>'single-thumb-size',
			'type' => 'text',
			'title' => esc_html__('Custom Single Thumbnail Size', 'sliva'), 
			'subtitle' => esc_html__('Select a custom thumbnail size to your blog.', 'sliva'),
			'description' => 'Type the thumbnail name like "full", "medium" or a custom size defined.',
			'default' => '',
		),

	), // #fields
);