<?php
/*
 * Layout Section
*/

$this->sections[] = array(
	'title' => esc_html__('Footer', 'sliva'),
	'desc' => esc_html__('Change the footer section configuration.', 'sliva'),
	'icon' => 'el-icon-cog',
	'fields' => array(

		array(
			'id'=>'footer-enable-switch',
			'type' => 'switch', 
			'title' => esc_html__('Disable this layout part?', 'sliva'),
			'subtitle'=> esc_html__('If on, this layout part will not be displayed.', 'sliva'),
			"default" => 0,
		),
		
		array(
			'id'=>'footer-sticky',
			'type' => 'switch', 
			'title' => esc_html__('Sticky footer?', 'sliva'),
			'subtitle'=> esc_html__('If on, this layout part will be sticky.', 'sliva'),
			"default" => 0,
		),
		
		array(
			'id'=>'footer-color-scheme',
			'type' => 'select',
			'title' => esc_html__('Color scheme', 'sliva'), 
			'subtitle' => esc_html__('Select footer color scheme.', 'sliva'),
			'options' => array(
				'dark' => esc_html__('Default', 'sliva'),
			),
			'default' => 'dark',
			'validate' => 'not_empty',
		),

		array(
			'id'=>'footer-layout',
			'type' => 'select',
			'title' => esc_html__('Footer Layout', 'sliva'), 
			'subtitle' => esc_html__('Select the footer layout to be used.', 'sliva'),
			'options' => apply_filters('ivan_footer_layouts', array( 
					'Ivan_Layout_Footer_Normal' => 'Customizable Columns',
					) ),
			'default' => 'Ivan_Layout_Footer_Normal',
			'validate' => 'not_empty',
		),

		array(
			'id' => 'footer-column-1',
			'type' => 'slider',
			'title' => esc_html__('#1 Column Width', 'sliva'),
			'desc' => esc_html__('Define column width, max is 12 parts, set as 0 to disable this area.', 'sliva'),
			'subtitle' => esc_html__('The four columns width combined should be equal to 12! Otherwise the layout will break.', 'sliva'),
			"default" => "3",
			"min" => "0",
			"step" => "1",
			"max" => "12",
		),

		array(
			'id' => 'footer-column-2',
			'type' => 'slider',
			'title' => esc_html__('#2 Column Width', 'sliva'),
			'desc' => esc_html__('Define column width, max is 12 parts, set as 0 to disable this area.', 'sliva'),
			'subtitle' => esc_html__('The four columns width combined should be equal to 12! Otherwise the layout will break.', 'sliva'),
			"default" => "3",
			"min" => "0",
			"step" => "1",
			"max" => "12",
		),

		array(
			'id' => 'footer-column-3',
			'type' => 'slider',
			'title' => esc_html__('#3 Column Width', 'sliva'),
			'desc' => esc_html__('Define column width, max is 12 parts, set as 0 to disable this area.', 'sliva'),
			'subtitle' => esc_html__('The four columns width combined should be equal to 12! Otherwise the layout will break.', 'sliva'),
			"default" => "3",
			"min" => "0",
			"step" => "1",
			"max" => "12",
		),

		array(
			'id' => 'footer-column-4',
			'type' => 'slider',
			'title' => esc_html__('#4 Column Width', 'sliva'),
			'desc' => esc_html__('Define column width, max is 12 parts, set as 0 to disable this area.', 'sliva'),
			'subtitle' => esc_html__('The four columns width combined should be equal to 12! Otherwise the layout will break.', 'sliva'),
			"default" => "3",
			"min" => "0",
			"step" => "1",
			"max" => "12",
		),
		
		array(
			'id' => 'footer-column-5',
			'type' => 'slider',
			'title' => esc_html__('#5 Column Width', 'sliva'),
			'desc' => esc_html__('Define column width, max is 12 parts, set as 0 to disable this area.', 'sliva'),
			'subtitle' => esc_html__('The four columns width combined should be equal to 12! Otherwise the layout will break.', 'sliva'),
			"default" => "0",
			"min" => "0",
			"step" => "1",
			"max" => "12",
		),

		array(
			'id' => 'random-footer',
			'type' => 'info',
			'desc' => esc_html__('Dynamic Areas', 'sliva')
		),

		array(
			'id'=>'footer-da-before-enable',
			'type' => 'switch', 
			'title' => esc_html__('Enable Dynamic Area Before Footer?', 'sliva'),
			'subtitle'=> esc_html__('If on, a dynamic area will be displayed above the layout.', 'sliva'),
			"default" => 0,
		),

		array(
			'id'=>'footer-da-before',
			'type' => 'select',
			'title' => esc_html__('Before Dynamic Content Page', 'sliva'), 
			'subtitle' => esc_html__('Select the page from where the content will be loaded and displayed.', 'sliva'),
			'data' => 'pages',
			'required' => array( 'footer-da-before-enable', '=', 1),
		),

		array(
			'id'=>'footer-da-after-enable',
			'type' => 'switch', 
			'title' => esc_html__('Enable Dynamic Area After Footer?', 'sliva'),
			'subtitle'=> esc_html__('If on, a dynamic area will be displayed below the layout.', 'sliva'),
			"default" => 0,
		),

		array(
			'id'=>'footer-da-after',
			'type' => 'select',
			'title' => esc_html__('After Dynamic Content Page', 'sliva'), 
			'subtitle' => esc_html__('Select the page from where the content will be loaded and displayed.', 'sliva'),
			'data' => 'pages',
			'required' => array( 'footer-da-after-enable', '=', 1),
		),
		
		array(
			'id' => 'random-floating',
			'type' => 'info',
			'desc' => esc_html__('Floating Contact Form', 'sliva')
		),

		array(
			'id'=>'footer-floating-contact-form',
			'type' => 'switch', 
			'title' => esc_html__('Enable Floating Contact Form', 'sliva'),
			'subtitle'=> esc_html__('If on, a floating contact form will be displayed in the right bottom corner.', 'sliva'),
			'desc' => sprintf(esc_html__('If you don\'t receive emails please check your email server settings. Most servers doesn\'t allow to send emails without smtp authentication. This little plugin can be helpful %s', 'sliva'), '<a href="https://wordpress.org/plugins/webriti-smtp-mail/">Easy SMTP Mail</a>'),
			"default" => 0,
		),
		
		array(
			'id' => 'footer-floating-contact-form-recaptcha',
			'type' => 'switch',
			'title' => esc_html__('Enable reCaptcha', 'sliva'),
			'subtitle' => esc_html__('If on, reCaptcha will be activated.', 'sliva'),
			'description' => sprintf(esc_html__('Register your site here %s and get you site and secret key.', 'sliva'),'<a href="https://www.google.com/recaptcha">https://www.google.com/recaptcha</a>'),
			"default" => 0,
			'required' => array( 'footer-floating-contact-form', '=', 1 ),
		),
		
		array(
			'id' => 'footer-floating-contact-form-recaptcha-site-key',
			'type' => 'text',
			'title' => esc_html__('reCaptcha Site Key', 'sliva'),
			'subtitle' => esc_html__('Site key', 'sliva'),
			'default' => '',
			'required' => array( 'footer-floating-contact-form-recaptcha', '=', 1 ),
		),
		
		array(
			'id' => 'footer-floating-contact-form-recaptcha-secret-key',
			'type' => 'text',
			'title' => esc_html__('reCaptcha Secret Key', 'sliva'),
			'subtitle' => esc_html__('Secret key', 'sliva'),
			'default' => '',
			'required' => array( 'footer-floating-contact-form-recaptcha', '=', 1 ),
		),
		
		array(
			'id'=>'footer-floating-contact-form-recaptcha-theme',
			'type' => 'select',
			'title' => esc_html__('reCaptcha Theme', 'sliva'), 
			'subtitle' => esc_html__('Select the theme to be used for reCaptcha.', 'sliva'),
			'options' => apply_filters('ivan_footer_layouts', array( 
				'light' => 'Light',
				'dark' => 'Dark',
			) ),
			'default' => 'light',
			'validate' => 'not_empty',
			'required' => array( 'footer-floating-contact-form-recaptcha', '=', 1 ),
		),
		
		
		
		array(
			'id' => 'footer-floating-contact-form-email',
			'type' => 'text',
			'title' => esc_html__('Email', 'sliva'),
			'subtitle' => esc_html__('Destination email address', 'sliva'),
			'default' => '',
			'required' => array( 'footer-floating-contact-form', '=', 1 ),
		),
		
		array(
			'id' => 'footer-floating-contact-form-header',
			'type' => 'text',
			'title' => esc_html__('Form Header', 'sliva'),
			'subtitle' => esc_html__('Header of the form', 'sliva'),
			'default' => '',
			'required' => array( 'footer-floating-contact-form', '=', 1 ),
			'validate' => false,
		),
		
		array(
			'id' => 'footer-floating-contact-form-description',
			'type' => 'textarea',
			'title' => esc_html__('Form Description', 'sliva'),
			'subtitle' => esc_html__('Short text displayed below the form header', 'sliva'),
			'default' => '',
			'required' => array( 'footer-floating-contact-form', '=', 1 ),
			'validate' => false,
		),
		

	), // #fields
);