<?php
/*
 * Layout Section
*/

$this->sections[] = array(
	'title' => esc_html__('Bottom Footer', 'sliva'),
	'desc' => esc_html__('Change the bottom footer section configuration.', 'sliva'),
	'icon' => 'el-icon-cog',
	'fields' => array(

		array(
			'id'=>'bottom-footer-enable',
			'type' => 'switch', 
			'title' => esc_html__('Disable this layout part?', 'sliva'),
			'subtitle'=> esc_html__('If on, this layout part will not be displayed.', 'sliva'),
			"default" => 0,
		),
		
		array(
			'id'=>'bottom-footer-color-scheme',
			'type' => 'select',
			'title' => esc_html__('Color scheme', 'sliva'), 
			'subtitle' => esc_html__('Select footer color scheme.', 'sliva'),
			'options' => array(
				'dark' => esc_html__('Dark', 'sliva'),
				'light-alt' => esc_html__('Light', 'sliva'),
			),
			'default' => 'dark',
			'validate' => 'not_empty',
		),

		array(
			'id'=>'bottom-footer-layout',
			'type' => 'select',
			'title' => esc_html__('Bottom Footer Layout', 'sliva'), 
			'subtitle' => esc_html__('Select the bottom footer to be used at header.', 'sliva'),
			'options' => apply_filters('ivan_bottom_footer_layouts', array( 
				'Ivan_Layout_Bottom_Footer_Two_Columns' => 'Two Columns',
				'Ivan_Layout_Bottom_Footer_Centered' => 'Centered',
			) ),
			'default' => 'Ivan_Layout_Bottom_Footer_Two_Columns',
			'validate' => 'not_empty',
		),

		array(
			'id'=>'bottom-footer-fullwidth',
			'type' => 'switch', 
			'title' => esc_html__('Fulll Width', 'sliva'),
			'subtitle'=> esc_html__('If on, the bottom footer will be full width.', 'sliva'),
			"default" => 0,
			'required' => array('bottom-footer-layout', '=', 'Ivan_Layout_Bottom_Footer_Two_Columns'),
		),
		
		array(
			'id'=>'bottom-footer-expanded-paddings',
			'type' => 'switch', 
			'title' => esc_html__('Enable Expanded Paddings?!', 'sliva'),
			'subtitle'=> esc_html__('If on, the bottom footer will receive extra vertical padding.', 'sliva'),
			"default" => 0,
			'required' => array('bottom-footer-layout', '=', 'Ivan_Layout_Bottom_Footer_Two_Columns'),
		),

		array(
			'id' => 'bottom-footer-left-width',
			'type' => 'slider',
			'title' => esc_html__('Left Area Width', 'sliva'),
			'desc' => esc_html__('Define columns number of top header left side.', 'sliva'),
			'subtitle' => esc_html__('The left and right side combined should not be greater than 12! Otherwise the layout will break.', 'sliva'),
			"default" => "6",
			"min" => "0",
			"step" => "1",
			"max" => "12",
			'required' => array('bottom-footer-layout', '=', 'Ivan_Layout_Bottom_Footer_Two_Columns'),
		),

		array(
			'id' => 'bottom-footer-right-width',
			'type' => 'slider',
			'title' => esc_html__('Right Area Width', 'sliva'),
			'desc' => esc_html__('Define columns number of top header left side.', 'sliva'),
			'subtitle' => esc_html__('The left and right side combined should not be greater than 12! Otherwise the layout will break.', 'sliva'),
			"default" => "6",
			"min" => "0",
			"step" => "1",
			"max" => "12",
			'required' => array('bottom-footer-layout', '=', 'Ivan_Layout_Bottom_Footer_Two_Columns'),
		),

		array(
			'id'=>'bottom-footer-menu-disable',
			'type' => 'switch', 
			'title' => esc_html__('Disable Menu?', 'sliva'),
			'subtitle'=> esc_html__('If on, menu will not be displayed.', 'sliva'),
			"default" => 0,
			'required' => array('bottom-footer-layout', '=', 'Ivan_Layout_Bottom_Footer_Two_Columns'),
		),
		array(
			'id'=>'bottom-footer-logo',
			'type' => 'media', 
			'url'=> true,
			'title' => esc_html__('Logo', 'sliva'),
			'subtitle' => esc_html__('Upload the logo that will be displayed in the bottom footer.', 'sliva'),
		),
		array(
			'id'=>'bottom-footer-menu-left-switch',
			'type' => 'switch', 
			'title' => esc_html__('Display Menu at Left Area', 'sliva'),
			'subtitle'=> esc_html__('If on, menu will display at left side of bottom footer.', 'sliva'),
			"default" => 0,
			'required' => array(
				array('bottom-footer-layout', '=', 'Ivan_Layout_Bottom_Footer_Two_Columns'),
				array( 'bottom-footer-menu-disable', '=', 0)
			),
		),

		array(
			'id' => 'random-number-text-module',
			'type' => 'info',
			'desc' => esc_html__('Text Module Configuration.', 'sliva'),
		),

		array(
			'id'=>'bottom-footer-text-switch',
			'type' => 'switch', 
			'title' => esc_html__('Text Module', 'sliva'),
			'subtitle'=> esc_html__('If on, a rich text module will be displayed.', 'sliva'),
			"default" => 1,
		),

			array(
				'id' => 'bottom-footer-text-content',
				'type' => 'editor',
				'title' => esc_html__('Text Module Content', 'sliva'),
				'subtitle' => esc_html__('Place any text or shortcode to be displayed in header. Use [iv_separator] to add a separator in the text. Use [iv_icon icon="cogs"] to display Font Awesome icons. Use [iv_flags] to add WPML flags.', 'sliva'),
				'default' => 'All rights reserved.',
				'required' => array( 'bottom-footer-text-switch', '=', 1 ),
			),

		array(
			'id' => 'random-number',
			'type' => 'info',
			'desc' => esc_html__('Social Module Configuration.', 'sliva')
		),

		array(
			'id'=>'bottom-footer-social-switch',
			'type' => 'switch', 
			'title' => esc_html__('Social Module', 'sliva'),
			'subtitle'=> esc_html__('If on, a social icon module will be displayed.', 'sliva'),
			"default" => 0,
		),

			array(
				'id' => 'bottom-footer-social-icons',
				'type' => 'social_select',
				'title' => esc_html__('Social Icons', 'sliva'),
				'subtitle' => esc_html__('Add and organize the icons to be displayed.', 'sliva'),
				'required' => array( 'bottom-footer-social-switch', '=', 1 ),
				'placeholder' => array(
					'title' => esc_html__('Social Media URL', 'sliva'),
				),
			),

		array(
			'id' => 'random-bottom-footer',
			'type' => 'info',
			'desc' => esc_html__('Dynamic Areas', 'sliva')
		),

		array(
			'id'=>'bottom-footer-da-before-enable',
			'type' => 'switch', 
			'title' => esc_html__('Enable Dynamic Area Before Bottom Footer?', 'sliva'),
			'subtitle'=> esc_html__('If on, a dynamic area will be displayed above the layout.', 'sliva'),
			"default" => 0,
		),

		array(
			'id'=>'bottom-footer-da-before',
			'type' => 'select',
			'title' => esc_html__('Before Dynamic Content Page', 'sliva'), 
			'subtitle' => esc_html__('Select the page from where the content will be loaded and displayed.', 'sliva'),
			'data' => 'pages',
			'required' => array( 'bottom-footer-da-before-enable', '=', 1),
		),

		array(
			'id'=>'bottom-footer-da-after-enable',
			'type' => 'switch', 
			'title' => esc_html__('Enable Dynamic Area After Bottom Footer?', 'sliva'),
			'subtitle'=> esc_html__('If on, a dynamic area will be displayed below the layout.', 'sliva'),
			"default" => 0,
		),

		array(
			'id'=>'bottom-footer-da-after',
			'type' => 'select',
			'title' => esc_html__('After Dynamic Content Page', 'sliva'), 
			'subtitle' => esc_html__('Select the page from where the content will be loaded and displayed.', 'sliva'),
			'data' => 'pages',
			'required' => array( 'bottom-footer-da-after-enable', '=', 1),
		),

	), // #fields
);