<?php
/**
 * Filters and actions used by framework
 *
 */

/**
 * Remove redux menu under the tools
 * 
 */
add_action( 'admin_menu', 'ivan_remove_redux_menu',12 );
function ivan_remove_redux_menu() {
	remove_submenu_page('tools.php','redux-about');
}

// Activation theme hook
add_action("after_switch_theme", "ivan_activation_theme", 10 , 2);
function ivan_activation_theme($oldname, $oldtheme=false) {

	update_option( 'medium_size_w',480 );
	update_option( 'medium_size_h', 480 );

	update_option( 'large_size_w', 1200 );
	update_option( 'large_size_h', 1200 );

	// WooCommerce
	update_option('shop_catalog_image_size', array('width'=>480, 'height'=>600, 'crop' => false) );
	update_option('shop_single_image_size', array('width'=>510, 'height'=>600, 'crop' => true) );
	update_option('shop_thumbnail_image_size', array('width'=>120, 'height'=>120, 'crop' => true) );
	update_option('woocommerce_enable_lightbox', false );

}

// Negative Height Wrapper
add_action('ivan_header', 'ivan_neg_wrapper_before', 15);
function ivan_neg_wrapper_before() {

	if( 'Ivan_Main_Layout_Normal' == ivan_get_option('main-layout') ) :

		if( true == ivan_get_option( 'header-negative-height' ) ) :		
		?>
			<div class="z-enabled">
	<?php
		endif; // negative height enabled

	endif; // layout if...
}

add_action('ivan_content_before', 'ivan_neg_wrapper_after', 15);
function ivan_neg_wrapper_after() {
	
	if( 'Ivan_Main_Layout_Normal' == ivan_get_option('main-layout') ) :

		if( true == ivan_get_option( 'header-negative-height' ) ) :	
	?>
		</div><!-- .z-enabled -->
	<?php
		endif; // negative height enabled

	endif; // layout if...
}

// Header Action
add_filter( 'body_class', 'ivan_header_classes', 1 );
function ivan_header_classes( $classes ) {
	$header_layout = ivan_get_option( 'header-layout' );
	$classes[] = strtolower(str_replace(array('Ivan_Layout_','_'),array('','-'),$header_layout));
	
	return $classes;
}

// Header Action
add_filter( 'body_class', 'ivan_footer_classes', 1 );
function ivan_footer_classes( $classes ) {
	if (ivan_get_option( 'footer-sticky' )) {
		$classes[] = 'sticky-footer';
	}
	
	
	return $classes;
}

// Boxed/Wide Layouts Action
add_filter( 'body_class', 'ivan_boxed_wide_classes', 1 );
function ivan_boxed_wide_classes( $classes ) {

	$layout_mode = ivan_get_option('wide-boxed-switch');

	if( $layout_mode != null ){
		$classes[] = $layout_mode;
	}

	if( 'Ivan_Main_Layout_Normal' == ivan_get_option('main-layout') && 
		true == ivan_get_option('header-negative-height') && 'semi-transparent-bg' != ivan_get_option('header-bg-type') )
		$classes[] = 'negative-header-active';

	if( 'Ivan_Main_Layout_Normal' == ivan_get_option('main-layout') && 
		true == ivan_get_option('header-negative-height') && 'semi-transparent-bg' == ivan_get_option('header-bg-type') )
		$classes[] = 'semi-negative-header-active';

	if( 'Ivan_Main_Layout_Normal' == ivan_get_option('main-layout') && 
		true == ivan_get_option('header-negative-height') && true == ivan_get_option('header-boxed-layout') )
		$classes[] = 'header-boxed';

	if( true == ivan_get_option('header-negative-height') && true == ivan_get_option('title-wrapper-enable-switch') )
		$classes[] = 'moz-negative-adjust';

	$headerLayout = ivan_get_option('header-layout');
	if('Ivan_Layout_Header_Classic_Right_Area' == $headerLayout OR
		'Ivan_Layout_Header_Classic_Logo_Centered' == $headerLayout)
		$classes[] = 'classic-menu-activated';

	// Check if Visual Composer is activated in single post, activate it!
	if(is_singular()) {
		$_post = get_post();
		if($_post != null) {
			if($_post && preg_match('/vc_row/', $_post->post_content)) {
				$classes[] = 'vc_being_used';
			}
		}
	}

	return $classes;
}

// Insert Custom CSS Global Code in wp_head
add_action('wp_head', 'ivan_global_custom_css', 200);
function ivan_global_custom_css() {
	?>
<?php echo ivan_get_option('link_editor'); ?>
<?php
	if( is_singular() )
		echo ivan_get_post_option('link_editor_local'); 
?>
<style type="text/css">
<?php echo ivan_get_option('css_editor'); ?>
<?php
	if( is_singular() )
		echo ivan_get_post_option('css_editor_local'); 
?>
</style>
	<?php
}

// Insert Custom JS Global Code in wp_head
add_action('wp_footer', 'ivan_global_custom_js', 200);
function ivan_global_custom_js() {
	?>
<script type="text/javascript">
<?php echo ivan_get_option('js_editor'); ?>
<?php
	if( is_singular() )
		echo ivan_get_post_option('js_editor_local'); 
?>
</script>
	<?php
}

// Set menu orientation in aside layouts
add_filter( 'ivan_set_menu_orientation', 'ivan_header_menu_orientation', 10, 2 );
function ivan_header_menu_orientation( $orientation, $location ) {

	if( ivan_get_current_caller('main-layout') == 'Ivan_Main_Layout_Aside_Left' OR
	ivan_get_current_caller('main-layout') == 'Ivan_Main_Layout_Aside_Right' ) {

		if( $location == 'primary' )
			$orientation = 'vertical';
	}

	return $orientation;
}

// Set menu drop side in aside layouts
add_filter( 'ivan_menu_drops_side', 'ivan_header_menu_drops_side', 10, 1 );

function ivan_header_menu_drops_side( $side ) {

	if( ivan_get_current_caller('main-layout') == 'Ivan_Main_Layout_Aside_Right' ) {
		$side = 'drop_to_left';
	}
	else if( ivan_get_current_caller('main-layout') == 'Ivan_Main_Layout_Aside_Left' ) {
		$side = 'drop_to_right';
	}
	else if( ivan_get_option('header-menu-pull-center-switch') != true && 
		( 
			ivan_get_option('header-layout') == 'Ivan_Layout_Header_Classic_Right_Area' OR 
			ivan_get_option('header-layout') == 'Ivan_Layout_Header_Style2_Right_Area' OR 
			ivan_get_option('header-layout') == 'Ivan_Layout_Header_Classic_Logo_Centered' OR 
			ivan_get_option('header-layout') == 'Ivan_Layout_Header_Style2_Logo_Centered' OR 
			ivan_get_option('header-layout') == 'Ivan_Layout_Header_Only_Menu' OR 
			ivan_get_option('header-layout') == 'Ivan_Layout_Header_Simple_Logo_Centered' 
		) ) {

		$side = 'drop_to_right';

	}

	return $side;
}

// Add custom background pattern
add_action( 'wp_head', 'ivan_custom_pattern_css', 180 );
function ivan_custom_pattern_css() {

	$content = '';

	if( ivan_get_option('layout-patterns') != null && !is_array( ivan_get_option('layout-patterns') ) ) {
		$content .= '
		body {
			background-image: url('. ivan_get_option('layout-patterns') .');
			background-repeat: repeat;
			background-size: auto;
			background-attachment: scroll;
		}';
	}

	if( ivan_get_option('layout-boxed-patterns') != null && !is_array( ivan_get_option('layout-boxed-patterns') ) ) {
		$content .= '
		.page .content-wrapper.page-boxed-style, 
		.single-ivan_vc_projects .content-wrapper.page-boxed-style {
			background-image: url('. ivan_get_option('layout-boxed-patterns') .');
			background-repeat: repeat;
			background-size: auto;
			background-attachment: scroll;
		}';
	}

	echo '<style type="text/css">'. apply_filters('ivan_custom_css_content', $content) .'</style>';
}

// Add Favicon Support
if ( version_compare( get_bloginfo('version'), '4.3', '<' ) || !function_exists('wp_site_icon') ) {

	add_action( 'wp_head', 'ivan_favicons', 5 );
	function ivan_favicons() {
	?>
	<?php 
	$favicon_16 = ivan_get_option('favicon-16');
	if( is_array($favicon_16) && $favicon_16['url'] != '' ) : ?>
		<link rel="icon" type="image/png" href="<?php echo esc_url($favicon_16['url']); ?>" sizes="16x16">
	<?php endif; ?>
	<?php 
	$favicon_32 = ivan_get_option('favicon-32');
	if( is_array($favicon_32) && $favicon_32['url'] != '' ) : ?>
		<link rel="icon" type="image/png" href="<?php echo esc_url($favicon_32['url']); ?>" sizes="32x32">
	<?php endif; ?>
	<?php 
	$favicon_96 = ivan_get_option('favicon-96'); 
	if( is_array($favicon_96) && $favicon_96['url'] != '' ) : ?>
		<link rel="icon" type="image/png" href="<?php echo esc_url($favicon_96['url']); ?>" sizes="96x96">
	<?php endif; ?>
	<?php 
	$favicon_160 = ivan_get_option('favicon-160');
	if( is_array($favicon_160) && $favicon_160['url'] != '' ) : ?>
		<link rel="icon" type="image/png" href="<?php echo esc_url($favicon_160['url']); ?>" sizes="160x160">
	<?php endif; ?>
	<?php 
	$favicon_192 = ivan_get_option('favicon-192');
	if( is_array($favicon_192) && $favicon_192['url'] != '' ) : ?>
		<link rel="icon" type="image/png" href="<?php echo esc_url($favicon_192['url']); ?>" sizes="192x192">
	<?php endif; ?>
	<?php 
	$favicon_a_57 = ivan_get_option('favicon-a-57');
	if( is_array($favicon_a_57) && $favicon_a_57['url'] != '' ) : ?>
		<link rel="apple-touch-icon" sizes="57x57" href="<?php echo esc_url($favicon_a_57['url']); ?>">
	<?php endif; ?>
	<?php 
	$favicon_a_114 = ivan_get_option('favicon-a-114');
	if( is_array($favicon_a_114) && $favicon_a_114['url'] != '' ) : ?>
		<link rel="apple-touch-icon" sizes="114x114" href="<?php echo esc_url($favicon_a_114['url']); ?>">
	<?php endif; ?>
	<?php 
	$favicon_a_72 = ivan_get_option('favicon-a-72');
	if( is_array($favicon_a_72) && $favicon_a_72['url'] != '' ) : ?>
		<link rel="apple-touch-icon" sizes="72x72" href="<?php echo esc_url($favicon_a_72['url']); ?>">
	<?php endif; ?>
	<?php 
	$favicon_a_144 = ivan_get_option('favicon-a-144');
	if( is_array($favicon_a_144) && $favicon_a_144['url'] != '' ) : ?>
		<link rel="apple-touch-icon" sizes="144x144" href="<?php echo esc_url($favicon_a_144['url']); ?>">
	<?php endif; ?>
	<?php 
	$favicon_a_60 = ivan_get_option('favicon-a-60');
	if( is_array($favicon_a_60) && $favicon_a_60['url'] != '' ) : ?>
		<link rel="apple-touch-icon" sizes="60x60" href="<?php echo esc_url($favicon_a_60['url']); ?>">
	<?php endif; ?>
	<?php 
	$favicon_a_120 = ivan_get_option('favicon-a-120');
	if( is_array($favicon_a_120) && $favicon_a_120['url'] != '' ) : ?>
		<link rel="apple-touch-icon" sizes="120x120" href="<?php echo esc_url($favicon_a_120['url']); ?>">
	<?php endif; ?>
	<?php 
	$favicon_a_76 = ivan_get_option('favicon-a-76');
	if( is_array($favicon_a_76) && $favicon_a_76['url'] != '' ) : ?>
		<link rel="apple-touch-icon" sizes="76x76" href="<?php echo esc_url($favicon_a_76['url']); ?>">
	<?php endif; ?>
	<?php 
	$favicon_a_152 = ivan_get_option('favicon-a-152');
	if( is_array($favicon_a_152) && $favicon_a_152['url'] != '' ) : ?>
		<link rel="apple-touch-icon" sizes="152x152" href="<?php echo esc_url($favicon_a_152['url']); ?>">
	<?php endif; ?>
	<?php 
	$favicon_a_180 = ivan_get_option('favicon-a-180');
	if( is_array($favicon_a_180) && $favicon_a_180['url'] != '' ) : ?>
		<link rel="apple-touch-icon" sizes="180x180" href="<?php echo esc_url($favicon_a_180['url']); ?>">
	<?php endif; ?>
	<?php if( ivan_get_option('favicon-win-color') != '' ) : ?>
		<meta name="msapplication-TileColor" content="<?php echo esc_attr( ivan_get_option('favicon-win-color') ); ?>" />
	<?php endif; ?>
	<?php 
	$favicon_win_70 = ivan_get_option('favicon-win-70');
	if( is_array($favicon_win_70) && $favicon_win_70['url'] != '' ) : ?>
		<meta name="msapplication-square70x70logo" content="<?php echo esc_attr($favicon_win_70['url']); ?>" />
	<?php endif; ?>
	<?php 
	$favicon_win_150 = ivan_get_option('favicon-win-150');
	if( is_array($favicon_win_150) && $favicon_win_150['url'] != '' ) : ?>
		<meta name="msapplication-square150x150logo" content="<?php echo esc_attr($favicon_win_150['url']); ?>" />
	<?php endif; ?>
	<?php 
	$favicon_win_310 = ivan_get_option('favicon-win-310');
	if( is_array($favicon_win_310) && $favicon_win_310['url'] != '' ) : ?>
		<meta name="msapplication-wide310x150logo" content="<?php echo esc_attr($favicon_win_310['url']); ?>" />
	<?php endif; ?>
	<?php 
	$favicon_win_310_quad = ivan_get_option('favicon-win-310-quad');
	if( is_array($favicon_win_310_quad) && $favicon_win_310_quad['url'] != '' ) : ?>
		<meta name="msapplication-square310x310logo" content="<?php echo esc_attr($favicon_win_310_quad['url']); ?>" />
	<?php endif; ?>	
	<?php
	}
}

// Add Favicon Support
add_action( 'wp_head', 'ivan_disable_responsiveness', 100 );
function ivan_disable_responsiveness() {
	if( true == ivan_get_option('disable-responsiveness') ) :
	?>
	<script type="text/javascript">
		jQuery(window).ready(function(){
		   jQuery('meta[name="viewport"]').prop('content', 'width=1349');
		});
	</script>
	<?php
	endif;
}

// Replace Sidebars Per Page
add_filter('ivan_replace_sidebars', 'ivan_replace_sidebars');
function ivan_replace_sidebars( $sidebar ) {
	if( is_singular() ) {

		if( null != ivan_get_post_option( $sidebar . '-replace' ) ) {
			return ivan_get_post_option( $sidebar . '-replace' );
			
		} else if ( null != ivan_get_option( $sidebar . '-global-replace' ) ) {
			return ivan_get_option( $sidebar . '-global-replace' );
		}
	} else {
		if( null != ivan_get_option( $sidebar . '-global-replace' ) ) {
			return ivan_get_option( $sidebar . '-global-replace' );
		}
	}

	return $sidebar;
}

// Custom icons in user profile

function ivan_get_user_profile_media() {

	$ivan_user_profile_media = apply_filters('iv_user_profile_icons', array(
		'facebook', 'twitter', 'linkedin', 'pinterest', 'google-plus', 'tumblr', 'instagram',
		'vk', 'flickr', 'youtube', 'dribbble', 'vimeo-square', 'github', 'weibo',
	) );
	return $ivan_user_profile_media;
}

add_filter( 'user_contactmethods', 'ivan_custom_user_profile_social' );
function ivan_custom_user_profile_social($profile_fields) {

	// Adding Social Profiles to User
	$profile_fields['facebook'] = 'Facebook URL';
	$profile_fields['twitter'] = 'Twitter URL';
	$profile_fields['linkedin'] = 'LinkedIn URL';
	$profile_fields['pinterest'] = 'Pinterest URL';
	$profile_fields['google_plus'] = 'Google+ URL';
	$profile_fields['tumblr'] = 'Tumblr URL';
	$profile_fields['instagram'] = 'Instagram URL';
	$profile_fields['vk'] = 'VK URL';
	$profile_fields['flickr'] = 'Flickr URL';
	$profile_fields['youtube'] = 'Youtube URL';
	$profile_fields['dribbble'] = 'Dribbble URL';
	$profile_fields['vimeo_square'] = 'Vimeo URL';
	$profile_fields['github'] = 'GitHub URL';
	$profile_fields['weibo'] = 'Weibo URL';

	return $profile_fields;

}

// Custom Menu Fallback
function ivan_menu_fb($args) {
	if(isset($args['container_class']))
		echo '<div class="'.$args['container_class'].'"><div class="menu_holder centered">';

		wp_page_menu($args);

	if(isset($args['container_class']))
		echo '</div></div>';
}

// Dynamic Areas
function ivan_display_dynamic_area($ID, $header = false) {

	// runs specific code to header only...
	if($header) {

		$_id = '';

		if( is_home() ) {
			$_id = ivan_get_option('header-da-after-blog');
		}
		else if( is_singular('post') ) {
			$_id = ivan_get_option('header-da-after-single');
		}
		else if( true == ivan_is_woocommerce_activated() ) {
			if( is_shop() || is_product_category() ) {
				$_id = ivan_get_option('header-da-after-shop');
			} else if( is_product() ) {
				$_id = ivan_get_option('header-da-after-single-product');
			} 
		}

		if( $_id != '' )
			$ID = $_id;
	}

	if('' != $ID) :

		$page_data = get_page( $ID );
		if ($page_data) {
			$result = apply_filters('the_content', $page_data->post_content);

			echo apply_filters('ivan_dynamic_area_result', $result, $header);

			// Display custom row CSS by VC
			if( function_exists('ivan_vc_customizer_get_style') ) {
				$customCSS = get_post_meta( $ID , '_wpb_shortcodes_custom_css', true );
				if('' != $customCSS) {
					global $ivan_custom_css;

					$ivan_custom_css .= $customCSS;
				}
			}
		}
	endif;
}

// Enqueue Visual Composer Styles when using Dynamic Areas
add_action( 'wp_enqueue_scripts', 'ivan_enqueue_vc_to_dynamic', 40 );
function ivan_enqueue_vc_to_dynamic() {

	// Check if any dynamic area is enabled in order to enqueue the Visual Composer Style
	// ... when necessary
	if( true == ivan_get_option('header-da-after-enable') OR 
		true == ivan_get_option('footer-da-before-enable') OR
		true == ivan_get_option('footer-da-after-enable') ) :
		wp_enqueue_style('js_composer_front');
	endif;

	if( is_singular() && true == ivan_get_option('single-da-after-enable') )
		wp_enqueue_style('js_composer_front');
}

// Extended / Compact Headers
add_filter('iv_top_header_classes', 'ivan_expanded_compact_header');
add_filter('iv_header_classes', 'ivan_expanded_compact_header');
add_filter('iv_dynamic_header_classes', 'ivan_expanded_compact_header');
function ivan_expanded_compact_header( $classes ) {
	
	if( 'normal' != ivan_get_option('header-container-type') ) {
		$classes .= ' ' . ivan_get_option('header-container-type');
	}

	return $classes;
}

// Extended / Compact Content
add_filter('iv_title_wrapper_classes', 'ivan_expanded_compact_content');
add_filter('iv_content_wrapper_classes', 'ivan_expanded_compact_content');
function ivan_expanded_compact_content( $classes ) {
	
	if( 'normal' != ivan_get_option('content-container-type') ) {
		$classes .= ' ' . ivan_get_option('content-container-type');
	}

	return $classes;
}

// Extended / Compact Footer
add_filter('iv_footer_classes', 'ivan_expanded_compact_footer');
add_filter('iv_bottom_footer_classes', 'ivan_expanded_compact_footer');
add_filter('iv_dynamic_footer_classes', 'ivan_expanded_compact_footer');
function ivan_expanded_compact_footer( $classes ) {
	
	if( 'normal' != ivan_get_option('footer-container-type') ) {
		$classes .= ' ' . ivan_get_option('footer-container-type');
	}

	return $classes;
}

// Extended / Compact Aside
add_filter('iv_aside_container', 'ivan_expanded_compact_aside');
function ivan_expanded_compact_aside( $classes ) {
	
	if( 'normal' != ivan_get_option('aside-container-type') ) {
		$classes .= ' aside-' . ivan_get_option('aside-container-type');
	}

	return $classes;
}

// Boxed Style Classes
add_filter('iv_content_wrapper_classes', 'ivan_content_wrapper_boxed_style', 5, 2);
function ivan_content_wrapper_boxed_style( $classes, $location = 'page' ) {

	if( ivan_get_option('header-negative-height') == false ) {
	
		if( 'page' == $location && true == ivan_get_option('page-boxed-page') ) {
			$classes .= ' page-boxed-style';
		}

		else if( 'blog' == $location && true == ivan_get_option('blog-boxed-page') ) {
			$classes .= ' page-boxed-style';
		}

		else if( 'single' == $location && true == ivan_get_option('single-boxed-page') ) {
			$classes .= ' page-boxed-style';
		}

		else if( 'shop' == $location && true == ivan_get_option('shop-boxed-page') ) {
			$classes .= ' page-boxed-style';
		}

	}

	return $classes;
}

add_action('wp_head','ivan_display_customizer_placeholder_colors');

function ivan_display_customizer_placeholder_colors() {
	
	$color = ivan_get_option('title-wrapper-search-placeholder-color');
	if (empty($color)) {
		return;
	}
	?>
	<style>
		.iv-layout.title-wrapper.title-wrapper-normal .search-form-title input[type="text"]::-webkit-input-placeholder {
			color: <?php echo esc_attr($color);?>;
		}
		.iv-layout.title-wrapper.title-wrapper-normal .search-form-title input[type="text"]::-moz-placeholder {
			color: <?php echo esc_attr($color);?>;
		}
		.iv-layout.title-wrapper.title-wrapper-normal .search-form-title input[type="text"]:-moz-placeholder {
			color: <?php echo esc_attr($color);?>;
		}
		.iv-layout.title-wrapper.title-wrapper-normal .search-form-title input[type="text"]:-ms-input-placeholder {
			color: <?php echo esc_attr($color);?>;
		}
	</style>
<?php

}


add_action( 'wp_ajax_ff_submit', 'ivan_submit_floating_contact_form' );
add_action( 'wp_ajax_nopriv_ff_submit', 'ivan_submit_floating_contact_form' );


function ivan_set_html_content_type() {
		return 'text/html';
}

function ivan_admin_scripts() {
	
	wp_enqueue_style( 'ivan-admin-style', get_template_directory_uri() . '/framework/assets/css/admin.css', array(), null, 'all' );

}
add_action( 'admin_enqueue_scripts', 'ivan_admin_scripts');

/**
 * Remove ver variable from enqueued scripts and css files eg. from http://yourdomain/style.css?ver=1.3
 * @param string $src
 * @return string
 */
function ivan_clear_static_files_query_string( $src ){
	
	if (!ivan_get_option('clear-static-files')) {
		return $src;
	}

	$parts = explode( '?', $src );

	if ( ( strstr($parts[0],'.css') || strstr($parts[0],'.js') ) && isset($parts[1]) && strstr($parts[1], 'ver=')) {
		return $parts[0];	
	}
	return $src;
}
add_filter( 'script_loader_src', 'ivan_clear_static_files_query_string', 15, 1 );
add_filter( 'style_loader_src', 'ivan_clear_static_files_query_string', 15, 1 );


/**
 * Remove Redux demo link
 */
function ivan_remove_demo_mode_link() { 
    if ( class_exists('ReduxFrameworkPlugin') ) {
        remove_filter( 'plugin_row_meta', array( ReduxFrameworkPlugin::get_instance(), 'plugin_metalinks'), null, 2 );
    }
    if ( class_exists('ReduxFrameworkPlugin') ) {
		remove_action('admin_notices', array( ReduxFrameworkPlugin::get_instance(), 'admin_notices' ), 99);    
    }
}
add_action('init', 'ivan_remove_demo_mode_link');

/**
 * Removing Redux admin notices
 */
function ivan_remove_redux_framework_admin_notices_action() {
    ivan_remove_anonymous_object_filter(
        'admin_notices',
        'ReduxFramework',
        '_admin_notices',
		99
    );
}
add_action('admin_init', 'ivan_remove_redux_framework_admin_notices_action');

/**
* Remove an anonymous object filter.
*
* @param string $tag      Hook name.
* @param string $class    Class name
* @param string $method   Method name
* @param int    $priority Optional. Hook priority. Defaults to 10.
* @return bool
*/
function ivan_remove_anonymous_object_filter($tag, $class, $method, $priority = 10) {
   if ( !isset($GLOBALS['wp_filter'][$tag][$priority]) ) {
	   return false;
   }
   $filters = $GLOBALS['wp_filter'][$tag][$priority];

   foreach ($filters as $callback) {
	   if ( is_array($callback['function'])
		   && is_a( $callback['function'][0], $class )
		   && $method === $callback['function'][1]
	   ) {
		   return remove_filter($tag, $callback['function'], $priority);
	   }
   }

   return false;
}