<?php

/* *********************************************************************************************************************
 * Dynamic menu support
 */
add_theme_support( 'nav-menus' );
add_action( 'init', 'ishinvertotheme_register_menus' );

if ( ! function_exists( 'ishinvertotheme_register_menus' ) ) {
	function ishinvertotheme_register_menus() {
		register_nav_menus(
			array(
				'header-menu' => esc_html__( 'Main menu', 'inverto' )
			)
		);
	}
}

/* *********************************************************************************************************************
 * Add Shopping Cart to header bar
 */
if ( ! function_exists( 'ishinvertotheme_add_header_bar_shopping_cart' ) ) {
	function ishinvertotheme_add_header_bar_shopping_cart($items = null, $args = null){
		global $ishinvertotheme_options, $woocommerce;

		//var_dump( $woocommerce->cart );
		//die();

		if ( isset( $items ) && isset( $args ) ){
			// Running as a filter
			if ( $woocommerce && isset($args->theme_location) && ('header-bar-menu' == $args->theme_location ) && isset($ishinvertotheme_options['use_header_bar_cart']) && ('1' == $ishinvertotheme_options['use_header_bar_cart']) ){

				$searchboxItem = '';
				$searchboxItem .= '<li class="ish-phb-shopping-cart ish-shopping-cart"><a href="#" class="ish-cart-item ish-icon-basket-2"><span>' . esc_html__( 'Cart', 'inverto' ) . '</span> <span class="ish-count">(' . count($woocommerce->cart->cart_contents) . ')</span></a><ul class="sub-menu ish-cart-content">';

				if (  is_array( $woocommerce->cart->cart_contents ) ){

					foreach ( $woocommerce->cart->cart_contents as $product ){
						$product_obj = new WC_Product( $product['product_id'] );
						$searchboxItem .= '<li><a class="ish-cart-product" href="' . apply_filters( 'ishinvertotheme_nav_item_url', $product_obj->get_permalink() ) . '" title="' . esc_html__( 'View your shopping cart', 'inverto' ) . '">';
						$searchboxItem .= $product_obj->get_image( 'thumbnail' );
						$searchboxItem .= '<span class="ish-cart-product-title">' . $product_obj->get_title() . '</span>';
						$searchboxItem .= $product['quantity'] . ' x ' . wc_price( $product_obj->get_price() ) . $product_obj->get_price_suffix();
						$searchboxItem .= '</a></li>';
					}

				}

				$searchboxItem .= '<li class="ish-cart-subtotal-li">';
				$searchboxItem .= esc_html__( 'Subtotal:', 'inverto' );
				$searchboxItem .= ' ';
				$searchboxItem .= '<span class="ish-cart-subtotal">' . $woocommerce->cart->get_cart_total() . '</span>';
				$searchboxItem .= '</li>';

				$searchboxItem .= '<li class="ish-cart-links">';
				$searchboxItem .= '<a class="ish-icon-basket-2" href="' . apply_filters( 'ishinvertotheme_nav_item_url', wc_get_cart_url() ) . '" title="' . esc_html__( 'View your shopping cart', 'inverto' ) . '">';
				$searchboxItem .= '<span>' . esc_html__( 'View Cart', 'inverto' ) . '</span>';
				$searchboxItem .= '</a>';
				$searchboxItem .= '<a class="ish-icon-credit-card" href="' . apply_filters( 'ishinvertotheme_nav_item_url', wc_get_checkout_url() ) . '" title="' . esc_html__( 'View your shopping cart', 'inverto' ) . '">';
				$searchboxItem .= '<span>' . esc_html__( 'Checkout', 'inverto' ) . '</span>';
				$searchboxItem .= '</a>';
				$searchboxItem .= '</li>';


				$searchboxItem .= '</ul></li>';

				$items = $items . $searchboxItem;

			}

		} else {
			// Running as stand-alone function

			$items = '';

			if ( $woocommerce && isset($ishinvertotheme_options['use_header_bar_cart']) && ('1' == $ishinvertotheme_options['use_header_bar_cart']) ){

				$searchboxItem = '';
				$searchboxItem .= '<li class="ish-shopping-cart"><a href="#" class="ish-cart-item ish-icon-basket-2"><span>' . esc_html__( 'Cart', 'inverto' ) . '</span> <span class="ish-count">(' . count($woocommerce->cart->cart_contents) . ')</span></a><ul class="sub-menu ish-cart-content">';

				if (  is_array( $woocommerce->cart->cart_contents ) ){

					foreach ( $woocommerce->cart->cart_contents as $product ){
						$product_obj = new WC_Product( $product['product_id'] );
						$searchboxItem .= '<li><a class="ish-cart-product" href="' . apply_filters( 'ishinvertotheme_nav_item_url', $product_obj->get_permalink() ) . '" title="' . esc_html__( 'View your shopping cart', 'inverto' ) . '">';
						$searchboxItem .= $product_obj->get_image( 'thumbnail' );
						$searchboxItem .= '<span class="ish-cart-product-title">' . $product_obj->get_title() . '</span>';
						$searchboxItem .= $product['quantity'] . ' x ' . wc_price( $product_obj->get_price() ) . $product_obj->get_price_suffix();
						$searchboxItem .= '</a></li>';
					}

				}

				$searchboxItem .= '<li class="ish-cart-subtotal-li">';
				$searchboxItem .= esc_html__( 'Subtotal:', 'inverto' );
				$searchboxItem .= ' ';
				$searchboxItem .= '<span class="ish-cart-subtotal">' . $woocommerce->cart->get_cart_total() . '</span>';
				$searchboxItem .= '</li>';

				$searchboxItem .= '<li class="ish-cart-links">';
				$searchboxItem .= '<a class="ish-icon-basket-2" href="' . apply_filters( 'ishinvertotheme_nav_item_url', wc_get_cart_url() ) . '" title="' . esc_html__( 'View your shopping cart', 'inverto' ) . '">';
				$searchboxItem .= '<span>' . esc_html__( 'View Cart', 'inverto' ) . '</span>';
				$searchboxItem .= '</a>';
				$searchboxItem .= '<a class="ish-icon-credit-card" href="' . apply_filters( 'ishinvertotheme_nav_item_url', wc_get_checkout_url() ) . '" title="' . esc_html__( 'View your shopping cart', 'inverto' ) . '">';
				$searchboxItem .= '<span>' . esc_html__( 'Checkout', 'inverto' ) . '</span>';
				$searchboxItem .= '</a>';
				$searchboxItem .= '</li>';


				$searchboxItem .= '</ul></li>';

				$items = $items . $searchboxItem;

			}
		}

		return $items;
	}
}

if ( ! function_exists( 'ishinvertotheme_shopping_cart_update' ) ) {
	function ishinvertotheme_shopping_cart_update( $fragments ) {
		global $woocommerce;

		$searchboxItem = '';
		$searchboxItem .= '<ul class="sub-menu ish-cart-content">';

		if (  is_array( $woocommerce->cart->cart_contents ) ){

			foreach ( $woocommerce->cart->cart_contents as $product ){
				$product_obj = new WC_Product( $product['product_id'] );
				$searchboxItem .= '<li><a class="ish-cart-product" href="' . apply_filters( 'ishinvertotheme_nav_item_url', $product_obj->get_permalink() ) . '" title="' . esc_html__( 'View your shopping cart', 'inverto' ) . '">';
				$searchboxItem .= $product_obj->get_image( 'thumbnail' );
				$searchboxItem .= '<span class="ish-cart-product-title">' . $product_obj->get_title() . '</span>';
				$searchboxItem .= $product['quantity'] . ' x ' . wc_price( $product_obj->get_price() ) . $product_obj->get_price_suffix();
				$searchboxItem .= '</a></li>';
			}

		}

		$searchboxItem .= '<li class="ish-cart-subtotal-li">';
		$searchboxItem .= esc_html__( 'Subtotal:', 'inverto' );
		$searchboxItem .= ' ';
		$searchboxItem .= '<span class="ish-cart-subtotal">' . $woocommerce->cart->get_cart_total() . '</span>';
		$searchboxItem .= '</li>';

		$searchboxItem .= '<li class="ish-cart-links">';
		$searchboxItem .= '<a class="ish-icon-basket-2" href="' . apply_filters( 'ishinvertotheme_nav_item_url', wc_get_cart_url() ) . '" title="' . esc_html__( 'View your shopping cart', 'inverto' ) . '">';
		$searchboxItem .= '<span>' . esc_html__( 'View Cart', 'inverto' ) . '</span>';
		$searchboxItem .= '</a>';
		$searchboxItem .= '<a class="ish-icon-credit-card" href="' . apply_filters( 'ishinvertotheme_nav_item_url', wc_get_checkout_url() ) . '" title="' . esc_html__( 'View your shopping cart', 'inverto' ) . '">';
		$searchboxItem .= '<span>' . esc_html__( 'Checkout', 'inverto' ) . '</span>';
		$searchboxItem .= '</a>';
		$searchboxItem .= '</li>';


		$searchboxItem .= '</ul>';

		$fragments['.ish-shopping-cart .ish-cart-content'] = $searchboxItem;

		$searchboxItem = '';
		$searchboxItem .= '<span class="ish-count">(' . count($woocommerce->cart->cart_contents) . ')</span>';
		$fragments['.ish-shopping-cart .ish-cart-item .ish-count'] = $searchboxItem;

		return $fragments;

	}
}

/* *********************************************************************************************************************
 * Add Shopping Cart to main menu
 */
if ( ! function_exists( 'ishinvertotheme_add_main_menu_shopping_cart' ) ) {
	function ishinvertotheme_add_main_menu_shopping_cart($items = null, $args = null){
		global $ishinvertotheme_options, $woocommerce;

		//var_dump( $woocommerce->cart );
		//die();

		if ( !(isset($args->menu_class) && (false !== strpos( $args->menu_class, 'ish-widget-main_nav' ) ) && isset($args->theme_location) && ('header-menu' == $args->theme_location ) ) ) {
			if ( isset( $items ) && isset( $args ) ) {
				// Running as a filter
				if ( $woocommerce && isset( $args->theme_location ) && ( 'header-menu' == $args->theme_location ) && isset( $ishinvertotheme_options['use_main_nav_cart'] ) && ( '1' == $ishinvertotheme_options['use_main_nav_cart'] ) ) {

					$searchboxItem = '';
					$searchboxItem .= '<li class="ish-ph-mn-shopping-cart ish-shopping-cart"><a href="#" class="ish-cart-item ish-icon-basket-2"><span>' . esc_html__( 'Cart', 'inverto' ) . '</span> <span class="ish-count">(' . count( $woocommerce->cart->cart_contents ) . ')</span></a><ul class="sub-menu ish-cart-content">';

					if ( is_array( $woocommerce->cart->cart_contents ) ) {

						foreach ( $woocommerce->cart->cart_contents as $product ) {
							$product_obj = new WC_Product( $product['product_id'] );
							$searchboxItem .= '<li><a class="ish-cart-product" href="' . apply_filters( 'ishinvertotheme_nav_item_url', $product_obj->get_permalink() ) . '" title="' . esc_html__( 'View your shopping cart', 'inverto' ) . '">';
							$searchboxItem .= $product_obj->get_image( 'thumbnail' );
							$searchboxItem .= '<span class="ish-cart-product-title">' . $product_obj->get_title() . '</span>';
							$searchboxItem .= $product['quantity'] . ' x ' . wc_price( $product_obj->get_price() ) . $product_obj->get_price_suffix();
							$searchboxItem .= '</a></li>';
						}

					}

					$searchboxItem .= '<li class="ish-cart-subtotal-li">';
					$searchboxItem .= esc_html__( 'Subtotal:', 'inverto' );
					$searchboxItem .= ' ';
					$searchboxItem .= '<span class="ish-cart-subtotal">' . $woocommerce->cart->get_cart_total() . '</span>';
					$searchboxItem .= '</li>';

					$searchboxItem .= '<li class="ish-cart-links">';
					$searchboxItem .= '<a class="ish-icon-basket-2" href="' . apply_filters( 'ishinvertotheme_nav_item_url', wc_get_cart_url() ) . '" title="' . esc_html__( 'View your shopping cart', 'inverto' ) . '">';
					$searchboxItem .= '<span>' . esc_html__( 'View Cart', 'inverto' ) . '</span>';
					$searchboxItem .= '</a>';
					$searchboxItem .= '<a class="ish-icon-credit-card" href="' . apply_filters( 'ishinvertotheme_nav_item_url', wc_get_checkout_url() ) . '" title="' . esc_html__( 'View your shopping cart', 'inverto' ) . '">';
					$searchboxItem .= '<span>' . esc_html__( 'Checkout', 'inverto' ) . '</span>';
					$searchboxItem .= '</a>';
					$searchboxItem .= '</li>';


					$searchboxItem .= '</ul></li>';

					$items = $items . $searchboxItem;

				}

			} else {
				// Running as stand-alone function

				$items = '';

				if ( $woocommerce && isset( $ishinvertotheme_options['use_main_nav_cart'] ) && ( '1' == $ishinvertotheme_options['use_main_nav_cart'] ) ) {

					$searchboxItem = '';
					$searchboxItem .= '<li class="ish-ph-mn-shopping-cart ish-shopping-cart"><a href="#" class="ish-cart-item ish-icon-basket-2"><span>' . esc_html__( 'Cart', 'inverto' ) . '</span> <span class="ish-count">(' . count( $woocommerce->cart->cart_contents ) . ')</span></a><ul class="sub-menu ish-cart-content">';

					if ( is_array( $woocommerce->cart->cart_contents ) ) {

						foreach ( $woocommerce->cart->cart_contents as $product ) {
							$product_obj = new WC_Product( $product['product_id'] );
							$searchboxItem .= '<li><a class="ish-cart-product" href="' . apply_filters( 'ishinvertotheme_nav_item_url', $product_obj->get_permalink() ) . '" title="' . esc_html__( 'View your shopping cart', 'inverto' ) . '">';
							$searchboxItem .= $product_obj->get_image( 'thumbnail' );
							$searchboxItem .= '<span class="ish-cart-product-title">' . $product_obj->get_title() . '</span>';
							$searchboxItem .= $product['quantity'] . ' x ' . wc_price( $product_obj->get_price() ) . $product_obj->get_price_suffix();
							$searchboxItem .= '</a></li>';
						}

					}

					$searchboxItem .= '<li class="ish-cart-subtotal-li">';
					$searchboxItem .= esc_html__( 'Subtotal:', 'inverto' );
					$searchboxItem .= ' ';
					$searchboxItem .= '<span class="ish-cart-subtotal">' . $woocommerce->cart->get_cart_total() . '</span>';
					$searchboxItem .= '</li>';

					$searchboxItem .= '<li class="ish-cart-links">';
					$searchboxItem .= '<a class="ish-icon-basket-2" href="' . apply_filters( 'ishinvertotheme_nav_item_url', wc_get_cart_url() ) . '" title="' . esc_html__( 'View your shopping cart', 'inverto' ) . '">';
					$searchboxItem .= '<span>' . esc_html__( 'View Cart', 'inverto' ) . '</span>';
					$searchboxItem .= '</a>';
					$searchboxItem .= '<a class="ish-icon-credit-card" href="' . apply_filters( 'ishinvertotheme_nav_item_url', wc_get_checkout_url() ) . '" title="' . esc_html__( 'View your shopping cart', 'inverto' ) . '">';
					$searchboxItem .= '<span>' . esc_html__( 'Checkout', 'inverto' ) . '</span>';
					$searchboxItem .= '</a>';
					$searchboxItem .= '</li>';


					$searchboxItem .= '</ul></li>';

					$items = $items . $searchboxItem;

				}
			}
		}

		return $items;
	}
}

/* *********************************************************************************************************************
 * Add search form to main menu
 */
if ( ! function_exists( 'ishinvertotheme_add_search_form' ) ) {
	function ishinvertotheme_add_search_form($items, $args) {

		global $ishinvertotheme_options;

		if ( isset($args->menu_class) && (false === strpos( $args->menu_class, 'ish-widget-main_nav' ) ) && isset($args->theme_location) && ('header-menu' == $args->theme_location ) ) {
		//if ( ! ishinvertotheme_use_sidenav() ){

			if ( isset($args->theme_location) && ('header-menu' == $args->theme_location ) && isset($ishinvertotheme_options['use_navigation_search']) && ('1' == $ishinvertotheme_options['use_navigation_search']) ){
				$searchboxItem =
					'<li class="ish-ph-mn-search">' .
					$args->before .
					'<a href="#search" class="ish-icon-search-outline"><span>' . esc_html__( 'Search', 'inverto' ) . '</span></a>' . $args->after . '</li>';
				$items = $items . $searchboxItem;
			}

			if ( isset($args->theme_location) && ('header-menu' == $args->theme_location ) && ishinvertotheme_use_expandable_header() ){
				$expandableItem =
					'<li class="ish-ph-expandable_btn">' .
					$args->before .
					'<a href="#expandable" class="ish-icon-plus-outline"><span>' . esc_html__( 'Expandable', 'inverto' ) . '</span></a>' . $args->after . '</li>';
				$items = $items . $expandableItem;
			}

		}

		return $items;
	}
}


/* *********************************************************************************************************************
 * Add search form to Header Bar
 */
if ( ! function_exists( 'ishinvertotheme_add_header_bar_search_form' ) ) {
	function ishinvertotheme_add_header_bar_search_form($items, $args) {
		?>
		<?php
		global $ishinvertotheme_options;

		if ( isset($args->theme_location) && ('header-bar-menu' == $args->theme_location ) && isset($ishinvertotheme_options['use_header_bar_search']) && ('1' == $ishinvertotheme_options['use_header_bar_search']) ){
			$searchboxItem =
				'<li class="ish-phb-search">' .
				$args->before .
				'<a href="#search" class="ish-icon-search-outline"><span>' . esc_html__( 'Search', 'inverto' ) . '</span></a>' . $args->after . '</li>';
			$items = $items . $searchboxItem;
		}

		return $items;
	}
}

/* *********************************************************************************************************************
 * Create menu and search button second ul for responsive version
 */
if ( ! function_exists( 'ishinvertotheme_create_resp_nav' ) ) {
	function ishinvertotheme_create_resp_nav() {
		global $ishinvertotheme_options;

		$visibility_class = ( ishinvertotheme_use_sidenav() ) ? 'ish-ph-mn-visible' : 'ish-ph-mn-hidden';

		?>
		<ul class="ish-ph-mn-resp_nav <?php echo esc_attr( $visibility_class ); ?>">
			<!-- Resp menu button -->
			<?php if ( ! ishinvertotheme_use_sidenav() ){ ?>
				<li class="ish-ph-mn-resp_menu"><a href="#respnav" class="ish-icon-waves-outline"></a></li>
			<?php } else { ?>
				<li class="ish-ph-mn-resp_menu"><a href="#sidenav" class="ish-icon-waves-outline"></a></li>
			<?php } ?>

			<!-- Search button if enabled -->
			<?php if ( isset($ishinvertotheme_options['use_navigation_search']) && ('1' == $ishinvertotheme_options['use_navigation_search']) ) { ?>
				<li class="ish-ph-mn-search"><a href="#search" class="ish-icon-search-outline"></a></li>
			<?php } ?>

			<!-- Expandable button if enabled -->
			<?php if ( ishinvertotheme_use_expandable_header() ) { ?>
				<li class="ish-ph-expandable_btn"><a href="#expandable" class="ish-icon-plus-outline"></a></li>
			<?php } ?>

			<!-- Cart button if enabled -->
			<?php echo ishinvertotheme_add_main_menu_shopping_cart(); ?>

			<!-- Language Selector button if enabled -->
			<?php echo ishinvertotheme_add_language_selector(); ?>


		</ul>
		<?php
	}
}


/* *********************************************************************************************************************
 * Create menu and search button second ul for responsive version of Header Bar
 */
if ( ! function_exists( 'ishinvertotheme_create_header_bar_resp_nav' ) ) {
	function ishinvertotheme_create_header_bar_resp_nav() {
		global $ishinvertotheme_options;

		$visibility_class = ( ishinvertotheme_use_sidenav() ) ? 'ish-phb-visible' : 'ish-phb-hidden';

		?>
		<ul class="ish-phb-resp_nav ish-phb-hidden">
			<!-- Resp menu button -->
			<li class="ish-phb-resp_menu"><a href="#phb-respnav" class="ish-icon-waves-outline"></a></li>


			<!-- Cart button if enabled -->
			<?php echo ishinvertotheme_add_header_bar_shopping_cart(); ?>

			<!-- Language Selector button if enabled -->
			<?php echo ishinvertotheme_add_header_bar_language_selector(); ?>

			<!-- Expandable button if enabled -->
			<?php /* if ( ishinvertotheme_use_expandable_header() ) { ?>
				<li class="ish-phb-expandable_btn"><a href="#expandable" class="ish-icon-plus-outline"></a></li>
			<?php } */ ?>

			<!-- Search button if enabled -->
			<?php if ( isset($ishinvertotheme_options['use_header_bar_search']) && ('1' == $ishinvertotheme_options['use_header_bar_search']) ) { ?>
				<li class="ish-phb-search"><a href="#search" class="ish-icon-search-outline"></a></li>
			<?php } ?>

		</ul>
	<?php
	}
}


/* *********************************************************************************************************************
 * Make wp_nav_menu recognize custom post type page and highlight its ancestor
 */
add_filter( 'nav_menu_css_class', 'ishinvertotheme_current_type_nav_class', 10, 2);

if ( ! function_exists( 'ishinvertotheme_current_type_nav_class' ) ) {
	function ishinvertotheme_current_type_nav_class($css_class, $cur_page){
		global $ishinvertotheme_options, $ishinvertotheme_woo_id;

		$post_type = get_post_type();
		if($post_type != "page" && $post_type != 'post' ){
			$parent_page = (isset($ishinvertotheme_options['page_for_custom_post_type_' . $post_type])) ? $ishinvertotheme_options['page_for_custom_post_type_' . $post_type] : '-1';
			if($cur_page->object_id == $parent_page){
				$css_class[] = 'current_page_parent';
			}
			else{
				if(($key = array_search('current_page_parent', $css_class)) !== false) {
					unset($css_class[$key]);
				}
			}
		}
		elseif ( function_exists( 'is_shop') && is_shop() ){

			if ( null == $ishinvertotheme_woo_id ) {
				$ishinvertotheme_woo_id = wc_get_page_id( 'shop' );
			}
			$ish_shop_id = wc_get_page_id( 'shop' );

			// Un-highlight Original Shop Page
			if( $ish_shop_id != $ishinvertotheme_woo_id && $cur_page->object_id == $ish_shop_id) {
				if ( in_array( 'current-menu-item', $css_class ) ) {
					unset( $css_class[ array_search( 'current-menu-item', $css_class ) ] );
				}
				if ( in_array( 'current_page_item', $css_class ) ) {
					unset( $css_class[ array_search( 'current_page_item', $css_class ) ] );
				}
			}

			// HighLight Current Shop Page
			if( $cur_page->object_id == $ishinvertotheme_woo_id){
				$css_class[] = 'current-menu-item';
				$css_class[] = 'current_page_item';
			}
		}
		return $css_class;
	}
}


/* *********************************************************************************************************************
 * Add language selector
 */
if ( ! function_exists( 'ishinvertotheme_add_language_selector' ) ) {
	function ishinvertotheme_add_language_selector($items = null, $args = null){
		global $ishinvertotheme_options;

		if ( isset( $items ) && isset( $args ) ){

			// Running as a filter
			if ( isset($args->container_class) && (false !== strpos( $args->container_class, 'ish-ph-mn-center' )) && isset($ishinvertotheme_options['main_nav_languages']) && ('1' == $ishinvertotheme_options['main_nav_languages']) ){

				$cc = ( defined('ICL_LANGUAGE_CODE') && '' != ICL_LANGUAGE_CODE ) ? ' <span class="ish-language-code">(' . ICL_LANGUAGE_CODE . ')</span>' : '';

				$searchboxItem =
					'<li class="ish-ph-lng-selector">' .
					$args->before .
					'<a href="#"  class="ish-icon-globe-outline"><span>' . esc_html__( 'Language', 'inverto' ) . '</span>' . $cc . '</a>';

					$searchboxItem .= ishinvertotheme_language_selector() .

					//$args->link_before . 'Home' . $args->link_after .
					$args->after .
					'</li>';

				$items = $items . $searchboxItem;

			}

		} else {
			// Running as stand-alone function

			$items = '';

			if ( ishinvertotheme_wpml_plugin_active() && isset($ishinvertotheme_options['main_nav_languages']) && ('1' == $ishinvertotheme_options['main_nav_languages']) ){

				$cc = ( defined('ICL_LANGUAGE_CODE') && '' != ICL_LANGUAGE_CODE ) ? ' <span class="ish-language-code">(' . ICL_LANGUAGE_CODE . ')</span>' : '';

				$searchboxItem =
					'<li class="ish-ph-lng-selector">' .
					'<a href="#"  class="ish-icon-globe-outline"><span>' . esc_html__( 'Language', 'inverto' ) . '</span>' . $cc . '</a>';

				$searchboxItem .= ishinvertotheme_language_selector() .
					'</li>';

				$items = $items . $searchboxItem;

			}
		}

		return $items;
	}
}


/* *********************************************************************************************************************
 * Add language selector
 */
if ( ! function_exists( 'ishinvertotheme_add_header_bar_language_selector' ) ) {
	function ishinvertotheme_add_header_bar_language_selector($items = null, $args = null){
		global $ishinvertotheme_options;

		if ( isset( $items ) && isset( $args ) ){
			// Running as a filter
			if ( isset($args->theme_location) && ( 'header-bar-menu' == $args->theme_location ) && isset($ishinvertotheme_options['header_bar_languages']) && ('1' == $ishinvertotheme_options['header_bar_languages']) ){

				$cc = ( defined('ICL_LANGUAGE_CODE') && '' != ICL_LANGUAGE_CODE ) ? ' <span class="ish-language-code">(' . ICL_LANGUAGE_CODE . ')</span>' : '';

				$searchboxItem =
					'<li class="ish-phb-lng-selector">' .
					$args->before .
					'<a href="#"  class="ish-icon-globe-outline"><span>' . esc_html__( 'Language', 'inverto' ) . '</span>' . $cc . '</a>';

				$searchboxItem .= ishinvertotheme_language_selector();

				//$args->link_before . 'Home' . $args->link_after .
				$searchboxItem .= $args->after;

				$searchboxItem .= '</li>';

				$items = $items . $searchboxItem;

			}

		} else {
			// Running as stand-alone function

			$items = '';

			if ( ishinvertotheme_wpml_plugin_active() && isset($ishinvertotheme_options['header_bar_languages']) && ('1' == $ishinvertotheme_options['header_bar_languages']) ){

				$cc = ( defined('ICL_LANGUAGE_CODE') && '' != ICL_LANGUAGE_CODE ) ? ' <span class="ish-language-code">(' . ICL_LANGUAGE_CODE . ')</span>' : '';

				$searchboxItem =
					'<li class="ish-phb-lng-selector">' .
					'<a href="#"  class="ish-icon-globe-outline"><span>' . esc_html__( 'Language', 'inverto' ) . '</span>' . $cc . '</a>';

				$searchboxItem .= ishinvertotheme_language_selector();

				$searchboxItem .=	'</li>';

				$items = $items . $searchboxItem;

			}
		}

		return $items;
	}
}


/* *********************************************************************************************************************
 * Do not highlight Blog page in main menu when on search results page.
 */
if ( ! function_exists( 'ishinvertotheme_noCurrentNavInSearch' ) ) {
	function ishinvertotheme_noCurrentNavInSearch( $content ) {
		if ( is_search() || is_404() ) $content = preg_replace( '/ current_page[_a-z]*([\" ])/', '\1', $content );
		return $content;
	}
}
add_filter( 'wp_nav_menu', 'ishinvertotheme_noCurrentNavInSearch' );


/* *********************************************************************************************************************
 * Sticky nav on
 */
if ( ! function_exists( 'ishinvertotheme_is_sticky_nav_on') ) {
	function ishinvertotheme_is_sticky_nav_on(){

		global $ishinvertotheme_options;

		if ( isset( $ishinvertotheme_options['sticky_nav'] ) && '1' == $ishinvertotheme_options['sticky_nav'] ) {
			return 'ish-sticky-on';
		}
		else {
			return '';
		}

	}
}


/* *********************************************************************************************************************
 * Sticky resp nav on
 */
if ( ! function_exists( 'ishinvertotheme_is_sticky_nav_responsive_on') ) {
	function ishinvertotheme_is_sticky_nav_responsive_on(){

		global $ishinvertotheme_options;

		if ( isset( $ishinvertotheme_options['sticky_nav_responsive'] ) && '1' == $ishinvertotheme_options['sticky_nav_responsive'] ) {
			return '';
		}
		else {
			return 'ish-sticky_resp-off';
		}

	}
}

/* *********************************************************************************************************************
 * Sticky nav on
 */
if ( ! function_exists( 'ishinvertotheme_is_header_bar_on') ) {
	function ishinvertotheme_is_header_bar_on(){

		global $ishinvertotheme_options;

		if ( ishinvertotheme_use_header_bar() ) {
			return 'ish-header_bar-on';
		}
		else {
			return 'ish-header_bar-off';
		}

	}
}




/* *********************************************************************************************************************
 * Retina logo
 */
if ( ! function_exists( 'ishinvertotheme_is_retina_logo') ) {
	function ishinvertotheme_is_retina_logo( $header_class ){

		global $ishinvertotheme_options;

		if ( 'ish-alt-style' == $header_class ){
			return ( isset( $ishinvertotheme_options['logo_retina_image_alternative'] ) && '' != $ishinvertotheme_options['logo_retina_image_alternative'] ) || ( isset( $ishinvertotheme_options['logo_retina_image'] ) && '' != $ishinvertotheme_options['logo_retina_image'] );
		}

		return ( isset( $ishinvertotheme_options['logo_retina_image'] ) && '' != $ishinvertotheme_options['logo_retina_image'] );

	}
}


/* *********************************************************************************************************************
 * Logo
 */
if ( ! function_exists( 'ishinvertotheme_is_logo') ) {
	function ishinvertotheme_is_logo( $header_class ){

		global $ishinvertotheme_options;

		if ( 'ish-alt-style' == $header_class ){
			return ( isset( $ishinvertotheme_options['logo_image_alternative'] ) && '' != $ishinvertotheme_options['logo_image_alternative'] ) || ( isset( $ishinvertotheme_options['logo_image'] ) && '' != $ishinvertotheme_options['logo_image'] );
		}
		else {
			return ( isset( $ishinvertotheme_options['logo_image'] ) && '' != $ishinvertotheme_options['logo_image'] );
		}



	}
}

/* *********************************************************************************************************************
 * Get Logo
 */
if ( ! function_exists( 'ishinvertotheme_get_logo') ) {
	function ishinvertotheme_get_logo( $header_class ){

		global $ishinvertotheme_options;

		if ( 'ish-alt-style' == $header_class ){
			if ( isset( $ishinvertotheme_options['logo_image_alternative'] ) && '' != $ishinvertotheme_options['logo_image_alternative'] ){
				return $ishinvertotheme_options['logo_image_alternative'];
			} else if ( isset( $ishinvertotheme_options['logo_image'] ) && '' != $ishinvertotheme_options['logo_image'] ){
				return $ishinvertotheme_options['logo_image'];
			}
		}
		else {
			if  ( isset( $ishinvertotheme_options['logo_image'] ) && '' != $ishinvertotheme_options['logo_image'] ){
				return $ishinvertotheme_options['logo_image'];
			}
		}

		return '';

	}
}


/* *********************************************************************************************************************
 * Use image logo
 */
if ( ! function_exists( 'ishinvertotheme_use_logo') ) {
	function ishinvertotheme_use_logo(){

		global $ishinvertotheme_options;
		return ( isset($ishinvertotheme_options['logo_as_image']) && '1' == $ishinvertotheme_options['logo_as_image']);

	}
}

if ( ! function_exists( 'ishinvertotheme_empty_menu_fallback') ) {
	function ishinvertotheme_empty_menu_fallback(){

		echo '<ul id="mainnav" class="ish-ph-mn-main_nav"><li class="ish-no-menu">';
		if ( is_user_logged_in() ){
			echo '<a href="' . site_url() . '/wp-admin/nav-menus.php">' . esc_html__( 'No menu set under "Appearance -> Menus"' , 'inverto' ) . '</a>';
		}
		else{
			echo '<a href="#">' . esc_html__( 'No menu set under "Appearance -> Menus"' , 'inverto' ) . '</a>';
		}
		echo '</li></ul>';

	}
}

if ( ! function_exists( 'ishinvertotheme_empty_header_bar_menu_fallback') ) {
	function ishinvertotheme_empty_header_bar_menu_fallback(){

		echo '<ul id="top_bar_nav" class="ish-top_nav"><li class="ish-no-menu">';
		if ( is_user_logged_in() ){
			echo '<a href="' . site_url() . '/wp-admin/themes.php?page=optionsframework">' . esc_html__( 'No menu set under "Theme Options -> Header Options -> Header Top Bar"' , 'inverto' ) . '</a>';
		}
		else{
			echo '<a href="#">' . esc_html__( 'No menu set under "Theme Options -> Header Options -> Header Top Bar"' , 'inverto' ) . '</a>';
		}
		echo '</li></ul>';

	}
}


