<?php

/**
 * Filter which handles the classes for "part_content"
 *
 * Checks if sidebar is used on the current page based on the local (page) settings and global (Theme Options)
 * setting
 *
 * @uses ishinvertotheme_has_sidebar()
 *
 * @param string $classes
 *
 * @return string - The modified classes
 */
if ( ! function_exists( 'ishinvertotheme_part_content_classes' ) ) {
	function ishinvertotheme_part_content_classes( $classes, $id = null ){
		global $ishinvertotheme_id_404;

		if ( is_404() ){
			$id = $ishinvertotheme_id_404;
		}

		if ( ishinvertotheme_has_sidebar( $id ) ){
			$classes .= ' ish-with-sidebar';
		} else {
			$classes .= ' ish-without-sidebar';
		}

		return $classes;
	}
}

if ( ! function_exists( 'ishinvertotheme_the_content_home_separator' ) ) {
	function ishinvertotheme_the_content_home_separator( $content ){

		global $ish_last_row_html;

		if ( is_home() && ! empty($content) ) {

			// Ensure no error will occur
			if ( !isset($ish_last_row_html) || empty($ish_last_row_html)){ $ish_last_row_html = ''; }

			// Find the first HTML tag end
			$last_row_closing_pos = strpos( $ish_last_row_html, '>');

			if ( is_numeric( $last_row_closing_pos ) ){

				// Other content added after the last row (maybe from a plugin or filter) - show separator in this case
				$check_pos  = strrpos( $content, $ish_last_row_html);
				if ( is_numeric( $check_pos ) && ( $check_pos + strlen($ish_last_row_html) + 1  < strlen($content) ) ){
					return $content;
				}

				// Section
				$check_pos = strpos( $ish_last_row_html, 'ish-row_section');
				if ( is_numeric( $check_pos ) && ($check_pos < $last_row_closing_pos) ){
					return $content;
				}

				// Background Color
				$check_pos = strpos( $ish_last_row_html, 'ish-color');
				if ( is_numeric( $check_pos ) && ($check_pos < $last_row_closing_pos) ){
					return $content;
				}

				// Background Image
				$check_pos = strpos( $ish_last_row_html, 'background-image:');
				if ( is_numeric( $check_pos ) && ($check_pos < $last_row_closing_pos) ){
					return $content;
				}

				// Manual Background Color
				$check_pos = strpos( $ish_last_row_html, 'background-color:');
				if ( is_numeric( $check_pos ) && ($check_pos < $last_row_closing_pos) ){
					return $content;
				}

				// Video BG
				$check_pos = strpos( $ish_last_row_html, 'ish-videobg');
				if ( is_numeric( $check_pos ) && ($check_pos < $last_row_closing_pos) ){
					return $content;
				}

				// Top SVG Decoration
				$check_pos = strpos( $ish_last_row_html, 'ish-row-svg-top');
				if ( is_numeric( $check_pos ) && ($check_pos < $last_row_closing_pos) ){
					return $content;
				}

				// BG SVG Decoration
				$check_pos = strpos( $ish_last_row_html, 'ish-row-svg-bg');
				if ( is_numeric( $check_pos ) && ($check_pos < $last_row_closing_pos) ){
					return $content;
				}
			}

			$separator =    '<div class="ish-sc_separator ish-separator-text ish-separator-double ish-separator-home">
							<span class="ish-line ish-left"><span class="ish-line-border"></span></span>
						</div>';
			$pos = strrpos($content, '</div></div>');
			$content_before = substr( $content, 0, $pos );
			$content_after = substr( $content, $pos );

			$content = $content_before . $separator . $content_after;

		}

		return $content;

	}
}

$ish_content_opened = false;

if ( ! function_exists( 'ishinvertotheme_the_content_line_open' ) ) {
	function ishinvertotheme_the_content_line_open( $content ){

		// Wrap the non-visual-composer content into a row
		if ( ( ( is_singular() || is_home() ) && is_main_query() ) ) {

			if ( false === strpos( $content, 'wpb_row' ) && '' != $content ){
				// if [vc_row] shortcode has not been used
				$content = '<div class="wpb_row vc_row-fluid ish-row-notfull ish-row_notsection"><div class="ish-vc_row_inner">' . $content . '</div></div>';
			}
		}

		// Prepare opening and closing tags for content entered by external plugins which will be closed later
		return '</div></div>' . $content . '<div class="wpb_row vc_row-fluid ish-row-notfull ish-row_notsection ish-maybe-empty"><div class="ish-vc_row_inner">';
	}
}

if ( ! function_exists( 'ishinvertotheme_the_content_line_close' ) ) {
	function ishinvertotheme_the_content_line_close( $content ){
		$detect_before = '</div></div>';
		$detect_after = '<div class="wpb_row vc_row-fluid ish-row-notfull ish-row_notsection ish-maybe-empty"><div class="ish-vc_row_inner">';
		$insert_before = str_replace( 'ish-maybe-empty', 'ish-maybe-empty ish-decor-padding-0 ', $detect_after );

		$length_before = strlen( $detect_before );
		$length_after = strlen( $detect_after );

		$content_start =  substr( $content, 0, strlen( $detect_before ) );
		$content_end =  substr( $content, -1 * ( strlen( $detect_after ) ) );

		if ( $detect_before == $content_start ) {
			$content = substr( $content, $length_before, strlen( $content ) );
		} else{
			$content = $insert_before . $content;
		}

		if ( $detect_after == $content_end ) {
			$content = substr( $content, 0, strlen( $content ) - $length_after );
		} else{
			$content = $content . $detect_before;
		}

		// Close the wrappers which were opened in the "ishinvertotheme_the_content_line_open" function
		return $content;
	}
}

if ( ! function_exists( 'ishinvertotheme_taglines_separator' ) ) {
	function ishinvertotheme_taglines_separator( $content ){

		global $ishinvertotheme_options, $ish_show_taglines_separator;

		// No Breadcrumbs
		if ( isset($ish_show_taglines_separator) && false == $ish_show_taglines_separator ){
			return $content;
		}

		// Taglines and Content different colors
		if ( $ishinvertotheme_options['tagline_colors']['bg'] != $ishinvertotheme_options['body_color'] ){
			return $content;
		}

		// Taglines Pattern set
		if ( 1 == $ishinvertotheme_options['use_lead_pattern'] && '' != $ishinvertotheme_options['lead_bg_pattern'] ){
			return $content;
		}

		// Taglines BG Image set
		if ( 0 == $ishinvertotheme_options['use_lead_pattern'] && '' != $ishinvertotheme_options['lead_bg_image'] ){
			return $content;
		}

		$first_row_closing_pos = strpos( $content, '>');

		if ( is_numeric( $first_row_closing_pos ) ){

			// Section
			$check_pos = strpos( $content, 'ish-row_section');
			if ( is_numeric( $check_pos ) && ($check_pos < $first_row_closing_pos) ){
				return $content;
			}

			// Background Color
			$check_pos = strpos( $content, 'ish-color');
			if ( is_numeric( $check_pos ) && ($check_pos < $first_row_closing_pos) ){
				return $content;
			}

			// Background Image
			$check_pos = strpos( $content, 'background-image:');
			if ( is_numeric( $check_pos ) && ($check_pos < $first_row_closing_pos) ){
				return $content;
			}

			// Manual Background Color
			$check_pos = strpos( $content, 'background-color:');
			if ( is_numeric( $check_pos ) && ($check_pos < $first_row_closing_pos) ){
				return $content;
			}

			// Video BG
			$check_pos = strpos( $content, 'ish-videobg');
			if ( is_numeric( $check_pos ) && ($check_pos < $first_row_closing_pos) ){
				return $content;
			}

			// Top SVG Decoration
			$check_pos = strpos( $content, 'ish-row-svg-top');
			if ( is_numeric( $check_pos ) && ($check_pos < $first_row_closing_pos) ){
				return $content;
			}

			// BG SVG Decoration
			$check_pos = strpos( $content, 'ish-row-svg-bg');
			if ( is_numeric( $check_pos ) && ($check_pos < $first_row_closing_pos) ){
				return $content;
			}


		}

		$separator = '<div class="wpb_row vc_row-fluid ish-row-notfull ish-resp-centered ish-row_section ish-taglines-separator-row" style=""><div class="ish-vc_row_inner">
	<div class="vc_col-sm-12 wpb_column column_container" style="">
		<div class="wpb_wrapper">
			<div class="ish-sc_separator ish-separator-text ish-separator-double ish-taglines-separator"><span class="ish-line ish-left"><span class="ish-line-border"></span></span></div>
		</div>
	</div>
</div></div>';

		$ish_show_taglines_separator = false;

		$content = $separator . $content;

		// Close the wrappers which were opened in the "ishinvertotheme_the_content_line_open" function
		return $content;
	}
}



if ( ! function_exists( 'ishinvertotheme_the_content_remove_decor_padding_classes' ) ) {
	function ishinvertotheme_the_content_remove_decor_padding_classes( $content ){

		global $ishinvertotheme_rows_replace;
		$content = str_replace( $ishinvertotheme_rows_replace , '', $content );

		return $content;
	}
}

if ( ! function_exists( 'ishinvertotheme_tag_cloud_buttonize' ) ) {
	function ishinvertotheme_tag_cloud_buttonize( $content, $args ){
		//xdebug_var_dump( $args );
		return $content;
	}
}

if ( ! function_exists( 'ishinvertotheme_add_video_wmode_transparent' ) ) {
	function ishinvertotheme_add_video_wmode_transparent( $html, $url, $attr ) {
		if ( strpos( $html, "<embed src=" ) !== false ) {
			return str_replace( '</param><embed', '</param><param name="wmode" value="opaque"></param><embed wmode="opaque" ', $html );
		}
		elseif ( strpos ( $html, 'feature=oembed' ) !== false ) {
			return str_replace( 'feature=oembed', 'feature=oembed&wmode=opaque', $html );
		}
		else {
			return $html;
		}
	}
}

/**
 * Make Page for posts editable again (override the WordPress 4.2 "You are currently editing the page that shows your latest posts." notice )
 */

if ( ! function_exists( 'ishinvertotheme_allow_posts_page_editing') ) {
	function ishinvertotheme_allow_posts_page_editing() {
		global $post;

		if ( isset($post) && $post->ID == get_option( 'page_for_posts' ) ) {

			// Remove notice
			//remove_action( 'edit_form_after_title', '_wp_posts_page_notice' );

			// Enable page editing
			add_post_type_support( $post->post_type, 'editor' );
		}
	}
}
add_action( 'admin_head', 'ishinvertotheme_allow_posts_page_editing', 10);

if ( ! function_exists( 'ishinvertotheme_fix_bundled_vc_problem') ) {
	/**
	 * Filter which fires very early in WordPress to avoid too old assets plugin crashing the whole website with fatal error.
	 */
	function ishinvertotheme_fix_bundled_vc_problem() {

		if ( is_admin() ) {
			// Locate the plugin.
			$version_to_check = '1.6';
			$plugin_name      = 'ishyoboy-inverto-assets/ishyoboy-inverto-assets.php';
			$plugin_file      = WP_PLUGIN_DIR . '/' . $plugin_name;

			// Check plugin version if plugin exists.
			if ( file_exists( $plugin_file ) ) {

				// Include all plugin related functions.
				include_once( ABSPATH . 'wp-admin/includes/plugin.php' );

				if ( is_plugin_active( $plugin_name ) ) {
					$data = get_plugin_data( $plugin_file, false, false );

					// Only continue if we were able to get Plugin version.
					if ( isset( $data ) && isset( $data['Version'] ) ) {

						// Deactivate plugin if its version is lower than the one where VC becomes included as plugin.
						if ( version_compare( $data['Version'], $version_to_check, '<' ) ) {

							// Deactivate the plugin to avoid fatal errors.
							deactivate_plugins( $plugin_name, true );

							// Redirect as the error is visible the first time.
							if ( is_admin() ) {
								wp_redirect( admin_url() );
							} else {
								wp_redirect( home_url() );
							}
						}
					}
				}
			}
		}
	}
}
add_action( 'registered_taxonomy', 'ishinvertotheme_fix_bundled_vc_problem' );

/*
 * Comments Form HTML code
 * */

if ( ! function_exists( 'ishinvertotheme_comment_form_field') ) {
	function ishinvertotheme_comment_form_field( $field ) {
		return '<div class="ish-grid4">' . $field . '</div>';
	}
}
if ( ! function_exists( 'ishinvertotheme_comment_form_before_fields') ) {
	function ishinvertotheme_comment_form_before_fields() {
		echo '<div class="ish-row">';
	}
}
if ( ! function_exists( 'ishinvertotheme_comment_form_after_fields') ) {
	function ishinvertotheme_comment_form_after_fields() {
		echo '</div>';
	}
}
if ( ! function_exists( 'ishinvertotheme_comment_form_field_comment') ) {
	function ishinvertotheme_comment_form_field_comment( $field ) {
		return '<div class="ish-row"><div class="ish-grid12">' . $field . '</div></div>';
	}
}
if ( ! function_exists( 'ishinvertotheme_comment_form_submit_field') ) {
	function ishinvertotheme_comment_form_submit_field( $field ) {
		return '<div class="ish-row"><div class="ish-grid4">' . $field . '</div><div class="ish-grid4"></div></div>';
	}
}
if ( ! function_exists( 'ishinvertotheme_comment_form_defaults') ) {
	function ishinvertotheme_comment_form_defaults( $defaults ) {
		$defaults['submit_button'] = '<button name="%1$s" type="submit" id="%2$s" class="%3$s" value="%4$s" />%4$s</button>';
		$defaults['submit_field'] = '%1$s %2$s';
		return $defaults;
	}
}
add_filter( 'comment_form_field_author', 'ishinvertotheme_comment_form_field');
add_filter( 'comment_form_field_url', 'ishinvertotheme_comment_form_field');
add_filter( 'comment_form_field_email', 'ishinvertotheme_comment_form_field');
add_action( 'comment_form_before_fields', 'ishinvertotheme_comment_form_before_fields' );
add_action( 'comment_form_after_fields', 'ishinvertotheme_comment_form_after_fields' );
add_filter( 'comment_form_field_comment', 'ishinvertotheme_comment_form_field_comment' );
add_filter( 'comment_form_submit_field', 'ishinvertotheme_comment_form_submit_field' );
add_filter( 'comment_form_defaults', 'ishinvertotheme_comment_form_defaults' );
