<?php

/**
 * Register all shortcodes into TinyMCE
 */
function ishinvertotheme_register_tinymce_buttons() {
	if ( current_user_can('edit_posts') || current_user_can('edit_pages') )
	{
		add_filter( 'mce_external_plugins', 'ishinvertotheme_add_plugin');
		add_filter( 'mce_buttons', 'ishinvertotheme_register_buttons');
	}
}
add_action( 'init', 'ishinvertotheme_register_tinymce_buttons');

function ishinvertotheme_add_plugin($plugin_array) {

	$plugin_array['ishyoboy_text_highlight'] = get_template_directory_uri() . '/assets/framework/js/tinymce.js';

	return $plugin_array;

}

function ishinvertotheme_register_buttons( $buttons ) {
	array_push( $buttons, "ishyoboy_color_palette" );
	return $buttons;
}


/*
 *  Adds a custom stylesheet to the tinymce editor.
 */
function ishinvertotheme_register_tinymce_editor_styles( $url ) {

	if ( !empty($url) )
		$url .= ',';

	$url .= get_template_directory_uri() . '/assets/framework/css/tinymce.css';

	return $url;

}
add_filter( 'mce_css', 'ishinvertotheme_register_tinymce_editor_styles' );

function ishinvertotheme_register_admin_tinymce_styles() {

	wp_register_style( 'ishinvertotheme-tinymce', get_template_directory_uri() . '/assets/framework/css/tinymce.css' );
	wp_enqueue_style( 'ishinvertotheme-tinymce' );

}
add_action( 'admin_init', 'ishinvertotheme_register_admin_tinymce_styles' );

if (! function_exists( 'ishinvertotheme_editor_colors_style') ) {
	function ishinvertotheme_editor_colors_style() {

		global $ishinvertotheme_options;

		echo '<style type="text/css">';

		for ($i = 1; $i <= ISHINVERTOTHEME_COLORS_COUNT; $i++ ){

			if ( isset( $ishinvertotheme_options['color' . $i] ) ){
				// Necessary for the colored Drop Down Menu
				echo '.mce-ico.mce-i-ish-color_color' . $i . ':before { color: ' . $ishinvertotheme_options['color' . $i] . ";}\n";

				// Necessary for highlighting the text in Visual Composer elements
				echo '.ish-highlight.ish-text-color' . $i . '{ color: ' . $ishinvertotheme_options['color' . $i] . ";}\n";
				echo '.ish-highlight.ish-color' . $i . '{ background-color: ' . $ishinvertotheme_options['color' . $i] . ";}\n";
			}

		}

		echo '</style>' . "\n";

	}
}
add_action( 'admin_enqueue_scripts', 'ishinvertotheme_editor_colors_style');


if ( ! function_exists( 'ishinvertotheme_dynamic_editor_styles' ) ) {
	function ishinvertotheme_dynamic_editor_styles() {

		add_editor_style(
			array(
				add_query_arg( 'action', 'ishinvertotheme_editor_styles', admin_url( 'admin-ajax.php' ) ),
			)
		);
	}
}
add_action( 'after_setup_theme', 'ishinvertotheme_dynamic_editor_styles' );


if ( ! function_exists( 'ishinvertotheme_editor_styles_callback' ) ) {
	function ishinvertotheme_editor_styles_callback() {

		global $ishinvertotheme_options;

		header("Content-type: text/css; charset: UTF-8");

		// Necessary for highlighting the text in the regular MCE Editor
		for ($i = 1; $i <= ISHINVERTOTHEME_COLORS_COUNT; $i++ ){

			if ( isset( $ishinvertotheme_options['color' . $i] ) ){
				echo '.ish-highlight.ish-text-color' . $i . '{ color: ' . $ishinvertotheme_options['color' . $i] . ";}\n";
			}

		}

		for ($i = 1; $i <= ISHINVERTOTHEME_COLORS_COUNT; $i++ ){

			if ( isset( $ishinvertotheme_options['color' . $i] ) ){
				echo '.ish-highlight.ish-color' . $i . '{ background-color: ' . $ishinvertotheme_options['color' . $i] . ";}\n";
			}

		}

		die();
	}
}

add_action( 'wp_ajax_ishinvertotheme_editor_styles', 'ishinvertotheme_editor_styles_callback' );
add_action( 'wp_ajax_nopriv_ishinvertotheme_editor_styles', 'ishinvertotheme_editor_styles_callback' ); //- Enable to be called in the front-end
