<?php

/*******************************************************************************************************************
 * Add custom meta boxes
 */

// Reading time
add_ishyo_meta_box('post_settings', array(
	'title'     => esc_html__( 'Post Settings', 'inverto' ),
	'pages'		=> apply_filters( 'ish_metabox_posttypes', array('post'), 'post_settings'),
	'context'   => 'normal',
	'priority'  => 'high',
	'fields'    => array(
		array(
			'name' => esc_html__( 'Reading Time', 'inverto' ),
			'id' => 'post_reading_time',
			'desc' => esc_html__( 'Minutes necessary to read the article.', 'inverto' ),
			'type' => 'text'
		)
	)
));


add_ishyo_meta_box('iyb_meta_post_link', array(
	'title'     => esc_html__( 'Link settings', 'inverto' ),
	'pages'		=> apply_filters( 'ish_metabox_posttypes', array('post'), 'iyb_meta_post_link'),
	'context'   => 'normal',
	'priority'  => 'high',
	'fields'    => array(
		array(
			'name' => esc_html__( 'URL', 'inverto' ),
			'id' => 'post_url',
			'desc' => esc_html__( 'Add an URL link.', 'inverto' ),
			'type' => 'text'
		),
		array(
			'name' => esc_html__( 'Link Text', 'inverto' ),
			'id' => 'post_url_text',
			'desc' => esc_html__( 'Add text for the URL link.', 'inverto' ),
			'type' => 'text'
		)
	)
));

add_ishyo_meta_box('iyb_meta_post_quote', array(
	'title'     => esc_html__( 'Quote settings', 'inverto' ),
	'pages'		=> apply_filters( 'ish_metabox_posttypes', array('post'), 'iyb_meta_post_quote'),
	'context'   => 'normal',
	'priority'  => 'high',
	'fields'    => array(
		array(
			'name' => esc_html__( 'Quote', 'inverto' ),
			'id' => 'post_quote',
			'desc' => esc_html__( 'Add a quote', 'inverto' ),
			'type' => 'textarea'
		),
		array(
			'name' => esc_html__( 'Quote Source', 'inverto' ),
			'id' => 'post_quote_source',
			'desc' => esc_html__( 'Add the quote source', 'inverto' ),
			'type' => 'text'
		),
		array(
			'name' => esc_html__( 'URL', 'inverto' ),
			'id' => 'post_quote_url',
			'desc' => esc_html__( 'Add an external URL', 'inverto' ),
			'type' => 'text'
		)
	)
));

add_ishyo_meta_box('iyb_meta_post_audio', array(
	'title'     => esc_html__( 'Audio settings', 'inverto' ),
	'pages'		=> apply_filters( 'ish_metabox_posttypes', array('post'), 'iyb_meta_post_audio'),
	'context'   => 'normal',
	'priority'  => 'high',
	'fields'    => array(
		array(
			'name' => esc_html__( 'Adio file URL', 'inverto' ),
			'id' => 'post_audio',
			'default' => '',
			'desc' => esc_html__( 'Please enter the URL of the audio file.', 'inverto' ),
			'type' => 'text'
		)
	)
));

add_ishyo_meta_box('iyb_meta_post_video', array(
	'title'     => esc_html__( 'Video settings', 'inverto' ),
	'pages'		=> apply_filters( 'ish_metabox_posttypes', array('post'), 'iyb_meta_post_video'),
	'context'   => 'normal',
	'priority'  => 'high',
	'fields'    => array(
		array(
			'name' => esc_html__( 'Embedded or Selfhosted video', 'inverto' ),
			'id' => 'post_embedded_video',
			'default' => 'true',
			'desc' => esc_html__( 'Use embedded video.', 'inverto' ),
			'type' => 'checkbox',
		),
		array(
			'name' => esc_html__( 'URL or Embedded Code', 'inverto' ),
			'id' => 'post_video',
			'desc' => esc_html__( 'Enter the URL or embed code of Vimeo.com or YouTube.com streaming services.', 'inverto' ) . '<br>' . esc_html__( 'To get the code, go to the external video page, click "share" button and copy the Embed code.', 'inverto' ),
			'type' => 'textarea'
		),
		array(
			'name' => esc_html__( 'MP4 file URL', 'inverto' ),
			'id' => 'post_video_mp4',
			'default' => '',
			'desc' => esc_html__( 'Please enter the URL of the .mp4 video file.', 'inverto' ),
			'type' => 'text'
		),
		array(
			'name' => esc_html__( 'WebM file URL', 'inverto' ),
			'id' => 'post_video_webm',
			'default' => '',
			'desc' => esc_html__( 'Please enter the URL of the .webm video file.', 'inverto' ),
			'type' => 'text'
		),
		array(
			'name' => esc_html__( 'Poster image', 'inverto' ),
			'id' => 'post_video_poster',
			'default' => '',
			'desc' => esc_html__( 'Please enter the URL of the poster image file.', 'inverto' ),
			'type' => 'text',
			'std' => ''
		),
	)
));

$pages_arr = array('page', 'post', 'portfolio-post');
if ( ishinvertotheme_woocommerce_plugin_active() ){
	$pages_arr[] = 'product';
}

add_ishyo_meta_box('taglines_settings', array(
	'title'     => esc_html__( 'Title/Taglines Area Settings', 'inverto' ),
	'pages'		=> apply_filters( 'ish_metabox_posttypes', $pages_arr, 'taglines_settings'),
	'context'   => 'after_title',
	'priority'  => 'high',
	'fields'    => array(
		array(
			'name' => esc_html__( 'Hide Title', 'inverto' ),
			'id' => 'hide_title',
			'default' => 'false',
			'desc' => esc_html__( 'Hide Tile/Taglines Area when viewing detail (single) page.', 'inverto' ),
			'type' => 'checkbox',
		),
		array(
			'name' => esc_html__( 'Tile Position', 'inverto' ),
			'id' => 'title_area_style',
			'default' => '',
			'desc' => '',
			'type' => 'radio',
			'options' => Array(
				'' => esc_html__( 'Default (Theme Options)', 'inverto' ),
				'left' => esc_html__( 'Left aligned', 'inverto' ),
				'box' => esc_html__( 'Centered box', 'inverto' ),
			),
		),
		array(
			'name' => esc_html__( 'Replace Tile', 'inverto' ),
			'id' => 'use_taglines',
			'default' => 'false',
			'desc' => esc_html__( 'Use custom taglines instead of the title.', 'inverto' ),
			'type' => 'checkbox',
		),
		array(
			'name' => esc_html__( 'Main Tagline', 'inverto' ),
			'id' => 'tagline_1',
			'default' => '',
			'desc' => '', //esc_html__( '', 'inverto' ),
			'type' => 'text',
		),
		array(
			'name' => esc_html__( 'Sub Tagline', 'inverto' ),
			'id' => 'tagline_2',
			'default' => '',
			'desc' => '', //esc_html__( '', 'inverto' ),
			'type' => 'text',
		),
		array(
			'name' => esc_html__( 'Additional Text', 'inverto' ),
			'id' => 'tagline_additional',
			'default' => '',
			'desc' => '', //esc_html__( '', 'inverto' ),
			'type' => 'textarea',
		),
		array(
			'name' => esc_html__( 'BG Image', 'inverto' ),
			'id' => 'use_bg_image',
			'default' => 'false',
			'desc' => esc_html__( 'Use featured image as a background for the Title/Taglines area.', 'inverto' ),
			'type' => 'checkbox',
		),
		array(
			'name' => esc_html__( 'Image Parallax', 'inverto' ),
			'id' => 'bg_image_parallax',
			'default' => '',
			'desc' => '',
			'type' => 'radio',
			'options' => Array(
				'' => esc_html__( 'No parallax', 'inverto' ),
				'static' => esc_html__( 'Static', 'inverto' ),
				'dynamic' => esc_html__( 'Dynamic', 'inverto' ),
			),
		),
		array(
			'name' => esc_html__( 'Custom Colors', 'inverto' ),
			'id' => 'use_colors',
			'default' => 'false',
			'desc' => esc_html__( 'Use custom colors in the Title/Taglines Area.', 'inverto' ),
			'type' => 'checkbox',
		),
		array(
			'name' => esc_html__( 'BG color', 'inverto' ),
			'id' => 'title_color',
			'default' => '',
			'desc' => '', //esc_html__( 'Used in Taglines and Full-width overview page.', 'inverto' ),
			'type' => 'color_selector',
		),
		array(
			'name' => esc_html__( 'Text color', 'inverto' ),
			'id' => 'title_text_color',
			'default' => '',
			'desc' => '', //esc_html__( 'Used in Taglines and Full-width overview pages.', 'inverto' ),
			'type' => 'color_selector',
		),
		array(
			'name' => esc_html__( 'Color Opacity', 'inverto' ),
			'id' => 'title_color_opacity',
			'default' => '',
			'desc' => esc_html__( 'Number (0 - 100) in %. 100 - visible, 0 - invisible. Leave empty to use default value.', 'inverto' ),
			'type' => 'text',
		),

	)
));

$pages_arr = array('post');
add_ishyo_meta_box('ishyoboy_color_settings', array(
	'title'     => esc_html__( 'Color Settings', 'inverto' ),
	'pages'		=> apply_filters( 'ish_metabox_posttypes', $pages_arr, 'ishyoboy_color_settings'),
	'context'   => 'normal',
	'priority'  => 'high',
	'fields'    => array(
		array(
			'name' => esc_html__( 'Background color', 'inverto' ),
			'id' => 'color',
			'default' => '',
			'desc' => esc_html__( 'Used on overview page.', 'inverto' ),
			'type' => 'color_selector',
		),
		array(
			'name' => esc_html__( 'Text color', 'inverto' ),
			'id' => 'text_color',
			'default' => '',
			'desc' => esc_html__( 'Used on overview page.', 'inverto' ),
			'type' => 'color_selector',
		),
		/*array(
			'name' => esc_html__( 'Masonry size', 'inverto' ),
			'id' => 'masonry_size',
			'default' => '',
			'desc' => esc_html__( 'Used for Masonry Grid Blog overview pages.', 'inverto' ),
			'type' => 'radio_random',
			'options' => array(
				'1_1' => esc_html__( '1 x 1', 'inverto' ),
				'1_2' => esc_html__( '1 x 2', 'inverto' ),
				'2_1' => esc_html__( '2 x 1', 'inverto' ),
				'2_2' => esc_html__( '2 x 2', 'inverto' ),
			)
		),*/
		array(
			'name' => esc_html__( 'Color Opacity', 'inverto' ),
			'id' => 'overview_color_opacity',
			'default' => '',
			'desc' => esc_html__( 'Overview page color opacity in %. 100 - visible, 0 - invisible. Leave empty to use default value.', 'inverto' ),
			'type' => 'text',
		),
	)
));

/*
$pages_arr = array('page');
if ( ishinvertotheme_woocommerce_plugin_active() ){
	$pages_arr[] = 'product';
}

add_ishyo_meta_box('ishyoboy_color_settings', array(
	'title'     => esc_html__( 'Color Settings', 'inverto' ),
	'pages'		=> apply_filters( 'ish_metabox_posttypes', $pages_arr, 'ishyoboy_color_settings'),
	'context'   => 'normal',
	'priority'  => 'high',
	'fields'    => array(
		array(
			'name' => esc_html__( 'Background color', 'inverto' ),
			'id' => 'color',
			'default' => '',
			'desc' => esc_html__( 'Used in Taglines area.', 'inverto' ),
			'type' => 'color_selector',
		),
		array(
			'name' => esc_html__( 'Text color', 'inverto' ),
			'id' => 'text_color',
			'default' => '',
			'desc' => esc_html__( 'Used in Taglines area.', 'inverto' ),
			'type' => 'color_selector',
		)
	)
));*/

$pages_arr = array('page', 'post', 'portfolio-post');
if ( ishinvertotheme_woocommerce_plugin_active() ){
	$pages_arr[] = 'product';
}

add_ishyo_meta_box('page_settings', array(
	'title'     => esc_html__( 'Page Settings', 'inverto' ),
	'pages'		=> apply_filters( 'ish_metabox_posttypes', $pages_arr, 'page_settings'),
	'context'   => 'side',
	'priority'  => 'default',
	'fields'    => array(
		array(
			'name' => esc_html__( 'Show breadcrumbs:', 'inverto' ),
			'id' => 'show_breadcrumbs',
			'default' => '',
			'desc' => esc_html__( 'To show/hide the breadcrumbs on all pages go to ', 'inverto' ) . '<a href="' . admin_url('themes.php?page=optionsframework') . '" target="_blank">Theme Options</a>',
			'type' => 'select',
			'options' => array(
				''		            => esc_html__( 'Default setting', 'inverto' ),
				//'none'              => esc_html__( 'Hide', 'inverto' ),
				//'breadcrumbs'       => esc_html__( 'Show', 'inverto' ),

				'none'              => esc_html__( 'None', 'inverto' ),
				'breadcrumbs'       => esc_html__( 'Breadcrumbs only', 'inverto' ),
				'icons'             => esc_html__( 'Social Icons only', 'inverto' ),
				'breadcrumbs-icons' => esc_html__( 'Breadcrumbs & Social Icons', 'inverto' ),
			)
		),
		array(
			'name' => esc_html__( 'Page Boxed / Unboxed layout:', 'inverto' ),
			'id' => 'boxed_layout',
			'default' => '',
			'desc' => esc_html__( 'To change the layout of the whole website go to ', 'inverto' ) . '<a href="' . admin_url('themes.php?page=optionsframework') . '" target="_blank">Theme Options</a>',
			'type' => 'select',
			'options' => array(
				''		    => esc_html__( 'Default setting', 'inverto' ),
				'boxed'		=> esc_html__( 'Boxed', 'inverto' ),
				'unboxed'	=> esc_html__( 'Unboxed', 'inverto' ),
			)
		)
	)
));

$pages_arr = array('page', 'post', 'portfolio-post');
if ( ishinvertotheme_woocommerce_plugin_active() ){
	$pages_arr[] = 'product';
}

/* // MOVED TO CPT
add_ishyo_meta_box('slides_urls', array(
	'title'     => esc_html__( 'Slide Settings', 'inverto' ),
	'pages'		=> array('slides'),
	'context'   => 'side',
	'priority'  => 'default',
	'fields'    => array(
		array(
			'name' => esc_html__( 'Slide type', 'inverto' ),
			'id' => 'slide_type',
			'default' => 'content',
			'desc' => '',//esc_html__( 'Choose how the lead content will be displayed. The "unboxed" version is usually used for full-width slider shortcodes.', 'inverto' ),
			'type' => 'radio',
			'options' => array(
				'content' => esc_html__( 'Content', 'inverto' ),
				'image' => esc_html__( 'Image', 'inverto' ),
			)
		),
		array(
			'name' => esc_html__( 'Slide url link', 'inverto' ),
			'id' => 'slide_url',
			'default' => '',
			'desc' => esc_html__( 'Enter the url which the slide will link to. E.g. http://www.ishyoboy.com', 'inverto' ),
			'type' => 'text',
		),
		array(
			'name' => esc_html__( 'New window', 'inverto' ),
			'id' => 'slide_url_nw',
			'default' => 'true',
			'desc' => esc_html__( 'Open link in a new window.', 'inverto' ),
			'type' => 'checkbox'
		)
	)
));
*/

$pages_arr = array('page', 'post', 'portfolio-post');
if ( ishinvertotheme_woocommerce_plugin_active() ){
	$pages_arr[] = 'product';
}

// Page Header options
add_ishyo_meta_box('header', array(
	'title'     => esc_html__( 'Header', 'inverto' ),
	'pages'		=> apply_filters( 'ish_metabox_posttypes', $pages_arr, 'header'),
	'context'   => 'side',
	'priority'  => 'default',
	'fields'    => array(
		array(
			'name' => esc_html__( 'Header Colors Style', 'inverto' ),
			'id' => 'header_colors',
			'default' => '',
			'desc' => '', //esc_html__( '', 'inverto' ),
			'type' => 'select',
			'options' => array(
				''		    => esc_html__( 'Default Style', 'inverto' ),
				'alternative'	=> esc_html__( 'Alternative Style', 'inverto' ),
			),
		),
	)
));

$pages_arr = array('page');

// Page Main Navigation options
add_ishyo_meta_box('mainnav', array(
	'title'     => esc_html__( 'Main Navigation', 'inverto' ),
	'pages'		=> apply_filters( 'ish_metabox_posttypes', $pages_arr, 'mainnav'),
	'context'   => 'side',
	'priority'  => 'default',
	'fields'    => array(
		array(
			'name' => esc_html__( 'Navigation Position', 'inverto' ),
			'id' => 'mainnav_pos',
			'default' => '',
			'desc' => '', //esc_html__( '', 'inverto' ),
			'type' => 'select',
			'options' => array(
				''		    => esc_html__( 'Default setting', 'inverto' ),
				'center'	=> esc_html__( 'Center', 'inverto' ),
				'left'		=> esc_html__( 'Left', 'inverto' ),
				'right'		=> esc_html__( 'Right', 'inverto' ),
			),
		),
		array(
			'name' => esc_html__( 'Navigation Menu', 'inverto' ),
			'desc' => '',
			'id' => 'mainnav_menu',
			'default' => '',
			'type' => 'menu_select'
		),
		array(
			'name' => esc_html__( 'Side Navigation Sidebar', 'inverto' ),
			'desc' => '',
			'id' => 'mainnav_sidebar',
			'default' => 'sidebar-sidenav',
			'type' => 'sidebar_select'
		)
	)
));


$pages_arr = array('page', 'post', 'portfolio-post');
if ( ishinvertotheme_woocommerce_plugin_active() ){
	$pages_arr[] = 'product';
}

// Page, Blog & Portfolio Sidebars
add_ishyo_meta_box('blog_sidebars', array(
	'title'     => esc_html__( 'Sidebar', 'inverto' ),
	'pages'		=> apply_filters( 'ish_metabox_posttypes', $pages_arr, 'blog_sidebars'),
	'context'   => 'side',
	'priority'  => 'default',
	'fields'    => array(
		array(
			'name' => esc_html__( 'Sidebar position', 'inverto' ),
			'id' => 'sb_pos',
			'default' => '',
			'desc' => '', //esc_html__( '', 'inverto' ),
			'type' => 'select',
			'options' => array(
				''		    => esc_html__( 'Default setting', 'inverto' ),
				'none'		=> esc_html__( 'No Sidebar', 'inverto' ),
				'left'		=> esc_html__( 'Left', 'inverto' ),
				'right'		=> esc_html__( 'Right', 'inverto' ),
			),
		),
		array(
			'name' => esc_html__( 'Sidebar', 'inverto' ),
			'desc' => '', //esc_html__( '<strong>IMPORTANT:</strong><br>Page breaks and Sections will be removed if a sidebar is added.', 'inverto' ),
			'id' => 'sidebar',
			'default' => '',
			'type' => 'sidebar_select'
		)
	)
));


/*
$pages_arr = array('page', 'post', 'portfolio-post');
if ( ishinvertotheme_woocommerce_plugin_active() ){
	$pages_arr[] = 'product';
}

// Expandable header
add_ishyo_meta_box('expandable_header', array(
	'title'     => 'Expandable header',
	'pages'		=> $pages_arr,
	'context'   => 'side',
	'priority'  => 'default',
	'fields'    => array(
		array(
			'name' => esc_html__( 'Make header expandable:', 'inverto' ),
			'id' => 'use_header_sidebar',
			'default' => '',
			'desc' => '', //esc_html__( '', 'inverto' ),
			'type' => 'select',
			'options' => array(
				''		=> 'Default setting',
				'0'		=> 'Disable',
				'1'		=> 'Enable'
			)
		),
		array(
			'name' => esc_html__( 'Use expandable sidebar:', 'inverto' ),
			'id' => 'header_sidebar',
			'default' => '',
			'type' => 'sidebar_select'
		),
		array(
			'name' => esc_html__( 'Defaulf expandable state:', 'inverto' ),
			'id' => 'header_sidebar_on',
			'default' => '0',
			'desc' => '', //esc_html__( '', 'inverto' ),
			'type' => 'select',
			'options' => array(
				'0'		=> 'Closed',
				'1'		=> 'Opened'
			)
		)
	)
));
/**/


$pages_arr = array('page', 'post', 'portfolio-post');
if ( ishinvertotheme_woocommerce_plugin_active() ){
	$pages_arr[] = 'product';
}

// Footer widget area
add_ishyo_meta_box('footer_widgets', array(
	'title'     => esc_html__( 'Footer Widget Area', 'inverto' ),
	'pages'		=> apply_filters( 'ish_metabox_posttypes', $pages_arr, 'footer_widgets'),
	'context'   => 'side',
	'priority'  => 'default',
	'fields'    => array(
		array(
			'name' => esc_html__( 'Footer widget area:', 'inverto' ),
			'id' => 'use_fw_area',
			'default' => '',
			'desc' => '', //esc_html__( '', 'inverto' ),
			'type' => 'select',
			'options' => array(
				''		=> esc_html__( 'Default setting', 'inverto' ),
				'0'		=> esc_html__( 'Disable', 'inverto' ),
				'1'		=> esc_html__( 'Enable', 'inverto' ),
			)
		),
		array(
			'name' => esc_html__( 'Use footer sidebar:', 'inverto' ),
			'id' => 'footer_sidebar',
			'default' => 'sidebar-footer',
			'type' => 'sidebar_select'
		),
	)
));

/* // MOVED TO CPT
add_ishyo_meta_box('portfolio_images_box', array(
	'title'     => esc_html__( 'Portfolio Gallery', 'inverto' ),
	'pages'		=> array('portfolio-post'),
	'context'   => 'side',
	'priority'  => 'default',
	'fields'    => array(
		array(
			'name' => '', //esc_html__( 'Upload images', 'inverto' ),
			'id' => 'porfolio_images',
			'default' => '',
			'desc' => '',
			'type' => 'images2',
		)
	)
));*/