<?php

if ( ! function_exists( 'ishinvertotheme_framework_init' ) ) {
	function ishinvertotheme_framework_init() {

		global $pagenow;

		if ( is_admin() && isset($_GET['activated'] ) && "themes.php" == $pagenow ){
			flush_rewrite_rules();
			// header( 'Location: ' . esc_url( home_url( '/' ) ) . '/wp-admin/themes.php?page=optionsframework' );
		}

	}
}
add_action( 'init', 'ishinvertotheme_framework_init', 2 );

if ( ! function_exists( 'ishinvertotheme_options_enqueue_scripts' ) ) {
	function ishinvertotheme_options_enqueue_scripts() {

		if ( function_exists( 'wp_enqueue_media' ) ) {
			wp_enqueue_media();
		}
		wp_enqueue_script('media-upload');

		wp_enqueue_style( 'wp-color-picker' );

		wp_register_style( 'ishinvertotheme_fontello', get_template_directory_uri() . '/assets/frontend/css/ish-fontello.css');
		wp_enqueue_style('ishinvertotheme_fontello');

		wp_register_style( 'ishinvertotheme_framework_styles', get_template_directory_uri() . '/assets/framework/css/framework-styles.css' );
		wp_enqueue_style('ishinvertotheme_framework_styles');

		wp_register_script( 'ishinvertotheme_upload', get_template_directory_uri() . '/assets/framework/js/upload.js', array('jquery','media-upload','thickbox') );
		wp_enqueue_script('ishinvertotheme_upload');

		ishinvertotheme_output_theme_colors_css();

	}
}
add_action( 'admin_enqueue_scripts', 'ishinvertotheme_options_enqueue_scripts');


if ( ! function_exists( 'ishinvertotheme_enqueue_vc_scripts' ) ) {
	function ishinvertotheme_enqueue_vc_scripts() {

		wp_register_script( 'ishinvertotheme_vc', get_template_directory_uri() . '/assets/framework/js/vc.js', array('vc-backend-min-js'), false, true );
		wp_enqueue_script('ishinvertotheme_vc');

	}
}
add_action( 'admin_print_scripts', 'ishinvertotheme_enqueue_vc_scripts');

if( is_admin() )
{
	add_action( 'admin_print_scripts', 'ishinvertotheme_set_javascritp_paths');
}

/**
 * Hooks
 */
if ( ! function_exists( 'ishinvertotheme_meta_head' ) ) {
	function ishinvertotheme_meta_head() {
		do_action( 'ishinvertotheme_meta_head' );
	}
}

if ( ! function_exists( 'ishinvertotheme_register_after_title_area' ) ) {
	function ishinvertotheme_register_after_title_area() {
		global $post;

		echo '<div id="postbox-container-3" class="postbox-container ishyoboy-postbox-container">';
		echo '<div id="normal-sortables" class="meta-box-sortables ui-sortable">';

		do_meta_boxes( null, 'after_title', $post );

		echo '</div>';
		echo '</div>';

	}
}
add_action( 'edit_form_after_title', 'ishinvertotheme_register_after_title_area');