<?php

if ( is_admin() ){
	add_action( 'init', 'of_options' );
}

if (! function_exists( 'of_options')) {

    function of_options() {

        global $ishinvertotheme_fonts, $ishinvertotheme_default_colors, $of_pages, $of_sidebars, $of_menus, $of_categories, $ish_bg_images, $ish_alt_stylesheets, $ish_alt_stylesheets_imgs, $ish_googleFontsArray, $ish_regular_fonts, $ish_regular_variants;
	    $of_categories = array();
	    $of_pages = array();
	    $of_sidebars = array();
	    $of_menus = array();
	    $ish_bg_images = array();
	    $ish_alt_stylesheets = array();
	    $ish_alt_stylesheets_imgs = array();
	    $ish_googleFontsArray = array();
	    $ish_regular_fonts = array();
	    $ish_regular_fonts = array();
	    $ish_regular_variants = array();

	    $social_icons = null;
	    $social_icons_bar = null;


		//Access the WordPress Categories via an Array
		$of_categories = array();
		$of_categories_obj = get_categories('hide_empty=0');
		foreach ($of_categories_obj as $of_cat) {
		    $of_categories[$of_cat->cat_ID] = $of_cat->cat_name;}
		$categories_tmp = array_unshift($of_categories, 'Select a category:');

		//Access the WordPress Pages via an Array
		$of_pages = array();
        $of_pages_obj = get_pages();

        $of_pages['-1'] = esc_html__( 'Select a page', 'inverto' );
		foreach ($of_pages_obj as $of_page) {
		    $of_pages[$of_page->ID] = $of_page->post_title;
        }

        //Sidebars
        $of_sidebars = array();
        foreach ($GLOBALS['wp_registered_sidebars'] as $sidebar){
            $of_sidebars[ $sidebar['id'] ] =  $sidebar['name'];
        }

        //Menus
        $menus = get_terms( 'nav_menu', array( 'hide_empty' => false, 'taxonomy' => 'tax_nav_menu' ) );
        $of_menus = array(
            '' => esc_html__( 'Select a menu', 'inverto' ),
            'none' => esc_html__( 'No menu', 'inverto' ),
        );
        foreach ( $menus as $menu ) {
            $of_menus[$menu->slug] = $menu->name;
        }

        // Breadcrumbs Social icons
        $social_icons = '[ish_icon icon="ish-icon-email" icon_url="mailto:hi@inverto-theme.com" text_color="color2" active_text_color="color5" type="simple" global_atts="yes" tooltip="Write us: hi@inverto-theme.com" tooltip_color="color5" tooltip_text_color="color4"]

[ish_icon icon="ish-icon-phone-1" icon_url="tel:+3312345678" text_color="color2" active_text_color="color5" type="simple" global_atts="yes" tooltip="Call us: +33 123 456 78" tooltip_color="color5" tooltip_text_color="color4"]

[ish_icon icon="ish-icon-skype" icon_url="skype:inverto-theme" text_color="color2" active_text_color="color5" type="simple" global_atts="yes" tooltip="Skype us: inverto-theme" tooltip_color="color5" tooltip_text_color="color4"]';


	    // Header Bar Social Icons
	    $social_icons_bar = '[ish_icon icon="ish-icon-twitter" icon_url="//twitter.com/ishyoboydotcom" text_color="color2" active_text_color="color17" type="simple" global_atts="yes" tooltip="Twitter" tooltip_color="color17" tooltip_text_color="color4"]

[ish_icon icon="ish-icon-facebook" icon_url="//www.facebook.com/ishyoboydotcom" text_color="color2" active_text_color="color13" type="simple" global_atts="yes" tooltip="Facebook" tooltip_color="color13" tooltip_text_color="color4"]

[ish_icon icon="ish-icon-dribbble" icon_url="//dribbble.com/MattImling" text_color="color2" active_text_color="color14" type="simple" global_atts="yes" tooltip="Dribbble" tooltip_color="color14" tooltip_text_color="color4"]

[ish_icon icon="ish-icon-behance" icon_url="//www.behance.net/MattImling" text_color="color2" active_text_color="color15" type="simple" global_atts="yes" tooltip="Behance" tooltip_color="color15" tooltip_text_color="color4"]

[ish_icon icon="ish-icon-email" icon_url="//eepurl.com/C-X7v" text_color="color2" active_text_color="color5" type="simple" global_atts="yes" tooltip="Subscribe to our newsletter" tooltip_color="color5" tooltip_text_color="color4"]';

	    //
	    //$footer_legals_area = '<p style="text-align: center;">Proudly powered by <a href="http://wordpress.org" title="WordPress">WordPress</a> ~ Created by <a href="http://ishyoboy.com" title="IshYoBoy.com">IshYoBoy.com</a></p>';
	    $footer_legals_area = '<div class="ish-grid12" style="text-align: center"><a href="//themes.ishyoboy.com/inverto" title="Inverto">Inverto</a> Theme <span class="ish-spacer">/</span> Proudly powered by <a href="//wordpress.org" title="WordPress">WordPress</a> <span class="ish-spacer">/</span> Created by <a href="//ishyoboy.com" title="IshYoBoy.com">IshYoBoy.com</a></div>';

	    // Social Share code
	    $social_share = '<!-- AddThis Button BEGIN --><div class="addthis_toolbox addthis_default_style"><a class="addthis_button_facebook"></a><a class="addthis_button_twitter"></a><a class="addthis_button_google_plusone_share"></a><!--<a class="addthis_button_linkedin"></a>--><!--<a class="addthis_button_pinterest_share"></a>--><!--<a class="addthis_button_digg"></a>--><!--<a class="addthis_button_reddit"></a>--><!--<a class="addthis_button_xing"></a>--><!--<a class="addthis_button_gmail"></a>--><!--<a class="addthis_button_pocket"></a>--><!--<a class="addthis_button_compact"></a>--><a class="addthis_counter addthis_bubble_style"></a></div><script type="text/javascript" src="//s7.addthis.com/js/300/addthis_widget.js"></script><!-- AddThis Button END -->';
	    $social_share_icons = '[ish_icon icon="ish-icon-facebook" icon_url="https://www.facebook.com/sharer/sharer.php?u=##CURRENT_PAGE##" text_color="color2" active_text_color="color13" type="simple" global_atts="yes" tooltip="Share on Facebook" tooltip_color="color13" tooltip_text_color="color4"]

[ish_icon icon="ish-icon-gplus" icon_url="https://plus.google.com/share?url=##CURRENT_PAGE##" text_color="color2" active_text_color="color16" type="simple" global_atts="yes" tooltip="Share on Google+" tooltip_color="color16" tooltip_text_color="color4"]

[ish_icon icon="ish-icon-twitter" icon_url="https://twitter.com/home?status=This%20is%20worth%20reading:%20##CURRENT_PAGE##" text_color="color2" active_text_color="color17" type="simple" global_atts="yes" tooltip="Share on Twitter" tooltip_color="color17" tooltip_text_color="color4"]

[ish_icon icon="ish-icon-email" icon_url="mailto:?&subject=Check%20this%20link&body=This%20is%20worth%20reading:%20##CURRENT_PAGE##" text_color="color2" active_text_color="color1" type="simple" global_atts="yes" tooltip="Share via e-mail" tooltip_color="color1" tooltip_text_color="color4"]';

		//Sample Homepage blocks for the layout manager (sorter)
		$of_options_homepage_blocks = array
		(
			"disabled" => array (
				"placebo" 		=> 'placebo', //REQUIRED!
				"block_one"		=> 'Block One',
				"block_two"		=> 'Block Two',
				"block_three"	=> 'Block Three',
			),
			"enabled" => array (
				'placebo' => 'placebo', //REQUIRED!
				'block_four'	=> 'Block Four',
			),
		);

        //$googleFonts = array('none' => esc_html__( 'Select a font', 'inverto' ) );
        $googleFonts = json_decode(ishinvertotheme_get_google_fonts());
        $ish_googleFontsArray = array('none' => esc_html__( 'Select a font', 'inverto' ) );

        foreach ($googleFonts as $key => $details) {
            $ish_googleFontsArray[$key] = $key;
        }

        $ish_regular_fonts = array(
            'arial'     =>  'Arial',
            'verdana'   =>  'Verdana, Geneva',
            'trebuchet' =>  'Trebuchet',
            'georgia'   =>  'Georgia',
            'times'     =>  'Times New Roman',
            'tahoma'    =>  'Tahoma, Geneva',
            'palatino'  =>  'Palatino',
            'helvetica' =>  'Helvetica'
        );

        $ish_regular_variants = array(
            'normal'        =>  'Normal',
            'italic'        =>  'Italic',
            'bold'          =>  'Bold',
            'bold italic'   =>  'Bold Italic'
        );

	    // FONT SETTINGS
	    global $ishinvertotheme_options;
	    $ish_default_fonts = $ishinvertotheme_fonts;
	    ishinvertotheme_load_font_settings('body_font', $ishinvertotheme_options);
	    ishinvertotheme_load_font_settings('body_font_2', $ishinvertotheme_options);
	    ishinvertotheme_load_font_settings('header_font', $ishinvertotheme_options);
	    ishinvertotheme_load_font_settings('h1_font', $ishinvertotheme_options);
	    ishinvertotheme_load_font_settings('h2_font', $ishinvertotheme_options);
	    ishinvertotheme_load_font_settings('h3_font', $ishinvertotheme_options);
	    ishinvertotheme_load_font_settings('h4_font', $ishinvertotheme_options);
	    ishinvertotheme_load_font_settings('h5_font', $ishinvertotheme_options);
	    ishinvertotheme_load_font_settings('h6_font', $ishinvertotheme_options);
	    $ish_saved_fonts = $ishinvertotheme_fonts;
	    $ishinvertotheme_fonts = $ish_default_fonts;

        //Stylesheets Reader
		$alt_stylesheet_path = LAYOUT_PATH;
		$ish_alt_stylesheets = array();
        $ish_alt_stylesheets_imgs = array();


	    if ( is_dir($alt_stylesheet_path) )
		{
		    if ($alt_stylesheet_dir = opendir($alt_stylesheet_path) )
		    {
		        while ( ($alt_stylesheet_file = readdir($alt_stylesheet_dir)) !== false )
		        {
		            if(stristr($alt_stylesheet_file, '.php') !== false)
		            {
		                $ish_alt_stylesheets[$alt_stylesheet_file] = ucfirst(substr($alt_stylesheet_file, 0, -4));
                        $ish_alt_stylesheets_imgs[$alt_stylesheet_file] = get_template_directory_uri() . '/admin/layouts/' . substr($alt_stylesheet_file, 0, -4).'.png';
		            }
		        }
		    }
		}

        asort($ish_alt_stylesheets);
        asort($ish_alt_stylesheets_imgs);

        $ish_bg_images_path = get_template_directory() . '/assets/frontend/images/bg-patterns'; // change this to where you store your bg images
        $ish_bg_images_url = get_template_directory_uri() . '/assets/frontend/images/bg-patterns'; // change this to where you store your bg images

	    $ish_bg_images = array();
	    $ish_bg_images_first = array( '' => get_template_directory_uri() . '/assets/frontend/images/none.png');

		if ( is_dir($ish_bg_images_path) ) {
		    if ($ish_bg_images_dir = opendir($ish_bg_images_path) ) {
		        while ( ($ish_bg_images_file = readdir($ish_bg_images_dir)) !== false ) {
		            if( (stristr($ish_bg_images_file, '.png') !== false || stristr($ish_bg_images_file, '.jpg') !== false || stristr($ish_bg_images_file, '.gif') !== false )) {
		                $ish_bg_images[$ish_bg_images_file] = $ish_bg_images_url . '/' . $ish_bg_images_file;
		            }
		        }
		    }
		}

        asort($ish_bg_images);
        $ish_bg_images = array_merge($ish_bg_images_first, $ish_bg_images);

        /*-----------------------------------------------------------------------------------*/
        /* The Options Array */
        /*-----------------------------------------------------------------------------------*/

        // Set the Options Array
        global $of_options;
        $of_options = array();

	    do_action( 'ish_theme_options_before_general_options' );

		/* *************************************************************************************************************
         * 1. General Settings
         */
	    $of_options[] = array(  'name'  => esc_html__( 'General Options', 'inverto' ),
		                        'class' => 'generaloptions',
		                        'type'  => 'heading');

	        // BOXED / UNBOXED *****************************************************************************************
		    $url =  ADMIN_DIR . 'assets/images/';
		    $of_options[] = array(  'name'      => esc_html__( 'Boxed / Unboxed Layout', 'inverto' ),
                                    'desc'      => esc_html__( 'Default layout of the theme. Either boxed with a background image or unboxed (full-width).', 'inverto' ),
                                    'id'        => 'boxed_layout',
                                    'std'       => ISHINVERTOTHEME_DEFAULT_BOXED_LAYOUT,
                                    'type'      => 'images',
                                    'options'   => Array(
                                        'boxed'     => $url . '3cm.png',
                                        'unboxed'   => $url . '1col.png'
                                    ));

	        // PAGE WIDTH **********************************************************************************************
            $of_options[] = array(  'name'  => esc_html__( 'Page Width', 'inverto' ),
                                    'desc'  => esc_html__( 'Choose one of the pre-defined widths or enter custom one.', 'inverto' ),
                                    'id'    => 'use_predefined_page_width',
                                    'std'   => 1,
                                    'on'    => esc_html__( 'Predefined', 'inverto' ),
                                    'off'   => esc_html__( 'Custom', 'inverto' ),
                                    'folds' => 0,
                                    'type'  => 'switch');

            $of_options[] = array(  'name'      => '', //esc_html__( 'Page Width', 'inverto' ),
                                    'desc'      => '', //esc_html__( '', 'inverto' ),
                                    'id'        => 'predefined_page_width',
                                    'std'       => ISHINVERTOTHEME_PAGE_WIDTH,
                                    'type'      => 'radio',
                                    'fold'      => 'use_predefined_page_width',
                                    'options'   => array(
	                                    ISHINVERTOTHEME_PAGE_WIDTH  => esc_html__( 'Full Width', 'inverto' ) . ' (100%)',
	                                    '1240'  => esc_html__( 'Wide Screen', 'inverto' ) . ' (1240px)',
                                        '960'           => esc_html__( 'NoteBook', 'inverto' ) . ' (960px)',
                                    ));

            $of_options[] = array(  'name'  => '', //esc_html__( '', 'inverto' ),
                                    'desc'  => 'px',
                                    'id'    => 'custom_page_width',
                                    'std'   => ISHINVERTOTHEME_PAGE_WIDTH_PIXELS,
                                    'fold'  => 'off_' . 'use_predefined_page_width',
                                    'type'  => 'text');

	        // WEBSITE BORDER ******************************************************************************************
	        $of_options[] = array(  'name'  => esc_html__( 'Website Border', 'inverto' ),
                                    'desc'  => esc_html__( 'Add border around the whole website content.', 'inverto' ),
                                    'id'    => 'use_website_border',
							        'on'    => esc_html__( 'Yes', 'inverto' ),
							        'off'   => esc_html__( 'No', 'inverto' ),
                                    'std'   => 0,
                                    'type'  => 'switch');

            // RESPONSIVE LAYOUT ***************************************************************************************
	        $of_options[] = array(  'name'  => esc_html__( 'Responsive layout', 'inverto' ),
                                    'desc'  => esc_html__( 'Make the page width fit the screen of every device or set it to never resize.', 'inverto' ),
                                    'id'    => 'use_responsive_layout',
                                    'std'   => 1,
                                    'on'    => esc_html__( 'Responsive', 'inverto' ),
                                    'off'   => esc_html__( 'Fixed', 'inverto' ),
                                    'folds' => 1,
                                    'type'  => 'switch');

            $of_options[] = array(  'name'  => '', //esc_html__( '', 'inverto' ),
                                    'desc'  => esc_html__( 'px - from this point the layout will change to a mobile version.', 'inverto' ),
                                    'id'    => 'responsive_layout_breakingpoint',
                                    'std'   => ISHINVERTOTHEME_BREAKINGPOINT,
                                    'fold'  => 'use_responsive_layout',
                                    'type'  => 'text');

	        $of_options[] = array(  'name'  => '', //esc_html__( '', 'inverto' ),
                                    'desc'  => esc_html__( 'Center the content in responsive layout', 'inverto' ),
                                    'id'    => 'responsive_content_centering',
							        'on'    => esc_html__( 'Yes', 'inverto' ),
							        'off'   => esc_html__( 'No', 'inverto' ),
		                            'fold'  => 'use_responsive_layout',
                                    'std'   => 1,
                                    'type'  => 'switch');

            // NICESCROLL **********************************************************************************************
            $of_options[] = array(  'name'  => esc_html__( 'SmoothScroll', 'inverto' ),
                                    'desc'  => esc_html__( 'Enable smoothscroll functionality for smoother page scrolling effect (Google Chrome only).', 'inverto' ),
                                    'id'    => 'nicescroll_enabled',
                                    'std'   => 0,
                                    'type'  => 'switch');

	        // SITE PRELOADER ******************************************************************************************
            $of_options[] = array(  'name'  => esc_html__( 'Content Preloader', 'inverto' ),
                                    'desc'  => esc_html__( 'Enable preloader animation for smoother switching between pages', 'inverto' ),
                                    'id'    => 'preloader_enabled',
                                    'std'   => 0,
                                    'type'  => 'switch');

			// BREADCRUMBS **********************************************************************************************
	        $of_options[] = array(  'name'  => esc_html__( 'Breadcrumbs Bar', 'inverto' ),
                                    'desc'  => esc_html__( 'Display a breadcrumbs navigation in the content of each page.', 'inverto' ),
                                    'id'    => 'show_breadcrumbs',
									'std' => 'breadcrumbs-icons',
									'type' => 'select',
									'options' => Array(
										//'none'              => esc_html__( 'No', 'inverto' ),
										//'breadcrumbs'       => esc_html__( 'Yes', 'inverto' ),

										'none'              => esc_html__( 'None', 'inverto' ),
										'breadcrumbs'       => esc_html__( 'Breadcrumbs only', 'inverto' ),
										'icons'             => esc_html__( 'Social Icons only', 'inverto' ),
										'breadcrumbs-icons' => esc_html__( 'Breadcrumbs & Social Icons', 'inverto' ),
									),
			);

	        $of_options[] = array(  'name'  => esc_html__( 'Breadcrumbs Bar Icons', 'inverto' ),
	                                'class' => 'ish-sub-section',
                                    'desc'  => esc_html__( 'Social icons: Paste the social icons using the [ish_icon] shortcode', 'inverto' ),
                                    'id'    => 'social_icons',
                                    'std'   => $social_icons,
                                    'type'  => 'textarea');

	        // 404 PAGE ************************************************************************************************
            $of_options[] = array(  'name' => esc_html__( '404 Error page', 'inverto' ),
                                    'desc' => esc_html__( 'Select a page to be displayed instead of the standard 404 Not Found page.', 'inverto' ),
                                    'id' => 'use_page_for_404',
                                    'std' => '0',
                                    'folds' => '1',
                                    'type' => 'switch');

            $of_options[] = array(  'name' => '', //esc_html__( '', 'inverto' ),
                                    'desc' => esc_html__( 'The page which will be displayed instead of the standard 404 page.', 'inverto' ),
                                    'id' => 'page_for_404',
                                    'std' => '',
                                    'fold' => 'use_page_for_404',
                                    'type' => 'select',
                                    'options' => $of_pages );

            // REGULAR PAGES SIDEBAR ***********************************************************************************
            $of_options[] = array(  'name' => esc_html__( 'Regular Pages Sidebar', 'inverto' ),
                                    'desc' => esc_html__( "Display the sidebar on each page by default. This settings can be overridden in each page's settings.", 'inverto' ),
                                    'id' => 'show_page_sidebar',
                                    'std' => 0,
                                    'folds' => 1,
                                    'type' => 'switch');

            $of_options[] = array(  'name' => '', //'name' => esc_html__( 'Regular Pages Sidebar position', 'inverto' ),
                                    'desc'  => esc_html__( 'Choose whether to display the sidebar on the left or on the right side of the page.', 'inverto' ),
                                    'id'    => 'page_sidebar_position',
                                    'std'   => 'right',
                                    'fold'  => 'show_page_sidebar',
                                    'type'  => 'select',
                                    'options' => array('left' => 'Left', 'right' => 'Right') );

            $of_options[] = array(  'name' => '', //'name' => esc_html__( 'Regular Pages Sidebar', 'inverto' ),
                                    'desc' => esc_html__( 'Select which sidebar will be displayed on each page by default.', 'inverto' ),
                                    'id' => 'page_sidebar',
                                    'std' => 'sidebar-main',
                                    'fold' => 'show_page_sidebar',
                                    'type' => 'select',
                                    'options' => $of_sidebars);

            // ADDTHIS SHARE *******************************************************************************************
	        /*$of_options[] = array(  'name' => esc_html__( 'Social Sharing Code', 'inverto' ),
                                    'desc' => esc_html__( 'Paste your addthis sharing code from https://www.addthis.com/get/sharing', 'inverto' ),
                                    'id' => 'addthis_share',
                                    'std' => $social_share,
                                    'type' => 'textarea');*/

	        $of_options[] = array(  'name'  => esc_html__( 'Social Share Bar & Blog Detail Icons', 'inverto' ),
                                    'desc'  => esc_html__( 'Social icons: Paste the social icons using the [ish_icon] shortcode', 'inverto' ),
                                    'id'    => 'addthis_share',
                                    'std'   => $social_share_icons,
                                    'type'  => 'textarea');

            // CUSTOM CSS **********************************************************************************************
            $of_options[] = array(  'name'  => esc_html__( 'Custom CSS', 'inverto' ),
                                    'desc'  => esc_html__( 'Quickly add some CSS to your theme by adding it to this block.', 'inverto' ),
                                    'id'    => 'custom_css',
                                    'std'   => '',
                                    'type'  => 'textarea');

            // BACK TO TOP LINK
            $of_options[] = array(  'name' => esc_html__( 'Back-to-top link', 'inverto' ),
                                    'desc' => esc_html__( 'Display back to top link in the right bottom corner of each page.', 'inverto' ),
                                    'id' => 'show_back_to_top',
                                    'std' => 1,
                                    'type' => 'switch');

            // CUSTOM SCRIPTS ******************************************************************************************
            /* $of_options[] = array(  'name' => esc_html__( 'Custom Scripts', 'inverto' ),
                                    'desc' => esc_html__( 'Quickly add some JavaScript includes to your theme by adding it to this block.', 'inverto' ),
                                    'id' => 'custom_scripts',
                                    'std' => '',
                                    'type' => 'textarea'); */

	    do_action( 'ish_theme_options_after_general_options' );
	    do_action( 'ish_theme_options_before_header_options' );

        /* *************************************************************************************************************
         * 2. Header Options
         */
        $of_options[] = array(  'name'  => esc_html__( 'Header Options', 'inverto' ),
                                'class' => 'headeroptions',
                                'type'  => 'heading');

	        // SITE LOGO ***********************************************************************************************
            $of_options[] = array(  'name'  => esc_html__( 'Site Logo', 'inverto' ),
                                    'desc'  => esc_html__( 'Use image logo instead of a simple Site Title and if not empty, Tagline.', 'inverto' ),
                                    'id'    => 'logo_as_image',
                                    'std'   => 0,
                                    'folds' => 1,
                                    'type'  => 'switch');

            $of_options[] = array(  'name'  => esc_html__( 'Logo', 'inverto' ), // Display just hr
                                    'class' => 'ish-sub-section',
                                    'desc'  => esc_html__( 'Select an image for the Site Logo.', 'inverto' ),
                                    'id'    => 'logo_image',
                                    'std'   => '',
                                    'fold'  => 'logo_as_image',
                                    'mod'   => 'min',
                                    'type'  => 'media');

            $of_options[] = array(  'name'  => esc_html__( 'Retina Logo', 'inverto' ), // Display just hr
                                    'class' => 'ish-sub-section',
                                    'desc'  => esc_html__( '2x bigger than the normal logo.', 'inverto' ) .'<br><br><span style="color: #FF0000;">' . '<strong>' . esc_html__( 'IMPORTANT:', 'inverto' ) . '</strong><br>' . esc_html__( 'The Site Logo must be set.', 'inverto' ) . '</span>',
                                    'id'    => 'logo_retina_image',
                                    'std'   => '',
                                    'fold'  => 'logo_as_image',
                                    'mod'   => 'min',
                                    'type'  => 'media');

	        $of_options[] = array(  'name'  => esc_html__( 'Alternative Header Style - Logo', 'inverto' ), // Display just hr
                                    'class' => 'ish-sub-section',
                                    'desc'  => esc_html__( 'Standard logo used, if not set.', 'inverto' ),
                                    'id'    => 'logo_image_alternative',
                                    'std'   => '',
                                    'fold'  => 'logo_as_image',
                                    'mod'   => 'min',
                                    'type'  => 'media');

            $of_options[] = array(  'name'  => esc_html__( 'Alternative Header Style - Retina Logo', 'inverto' ), // Display just hr
                                    'class' => 'ish-sub-section',
                                    'desc'  => esc_html__( 'Standard Retina logo used, if not set.', 'inverto' ),
                                    'id'    => 'logo_retina_image_alternative',
                                    'std'   => '',
                                    'fold'  => 'logo_as_image',
                                    'mod'   => 'min',
                                    'type'  => 'media');

	        // HEADER HEIGHT *******************************************************************************************
	        $of_options[] = array(  'name'  => esc_html__( 'Header Height', 'inverto' ),
                                    'desc'  => esc_html__( 'px - the height of the header area.', 'inverto' ),
                                    'id'    => 'header_height',
                                    'std'   => ISHINVERTOTHEME_DEFAULT_HEADER_HEIGHT,
                                    'type'  => 'text');

            // RESPONSIVE LAYOUT MENU **********************************************************************************
	        $of_options[] = array(  'name'  => esc_html__( 'Header navigation responsive layout', 'inverto' ),
                                    'desc'  => esc_html__( 'px - from this point the main navigation will change to a mobile version. Works only if \'General Options -> Responsive layout\' is set to \'Responsive\'', 'inverto' ),
                                    'id'    => 'responsive_nav_breakingpoint',
                                    'std'   => ISHINVERTOTHEME_NAV_BREAKINGPOINT,
                                    'type'  => 'text');


	        // SIDENAV *************************************************************************************************
            /*$of_options[] = array(  'name'  => esc_html__( 'Side Navigation', 'inverto' ),
                                    'desc'  => esc_html__( 'Transform main navigation to side navigation.', 'inverto' ),
                                    'id'    => 'use_sidenav',
                                    'std'   => '1',
                                    'type'  => 'switch');*/

	        $of_options[] = array(  'name'      => esc_html__( 'Main Navigation', 'inverto' ),
                                    'desc'      => esc_html__( 'Position - Choose whether to display the Main Navigation on the top, left or right side of the page.', 'inverto' ),
                                    'id'        => 'mainnav_position',
                                    'std'       => '', // '', left, right
                                    'type'      => 'select',
                                    'options'   => array(
	                                    ''  => 'Center',
	                                    'left' => 'Left',
	                                    'right'  => 'Right',
                                    ));

	        $of_options[] = array(  'name'      => '',
                                    'desc'      => esc_html__( 'Sidebar - Select which sidebar to use in the Main Navigation Sidebar if position set to "Left" or "Right".', 'inverto' ),
                                    'id'        => 'mainnav_sidebar',
                                    'std'       => 'sidebar-sidenav',
                                    'type'      => 'select',
                                    'options'   => $of_sidebars);

	        $of_options[] = array(  'name'  => '',
                                    'desc'  => esc_html__( 'Type - Choose how the navigation should highlight the active pages/sections.', 'inverto' ),
                                    'id'    => 'mainnav_type',
                                    'std'   => '',
                                    'type'      => 'select',
                                    'options'   => array(
	                                    ''  => 'Multipage (Default)',
	                                    'onepage' => 'Onepage',
                                    ));

            // STICKY NAV **********************************************************************************************
            $of_options[] = array(  'name'  => esc_html__( 'Sticky Navigation', 'inverto' ),
                                    'desc'  => esc_html__( 'Choose whether the navigation remains sticked to the top of the page while scrolling down.', 'inverto' ),
                                    'id'    => 'sticky_nav',
                                    'std'   => 1,
                                    'folds' => 1,
                                    'type'  => 'switch');

		    $of_options[] = array(  'name'  => '', //'name' => esc_html__( '', 'inverto' ),
								    'desc'  => esc_html__( 'Display Sticky Nav on tablets and mobile devices', 'inverto' ),
								    'id'    => 'sticky_nav_responsive',
								    'std'   => 1,
								    'fold'  => 'sticky_nav',
								    'type'  => 'switch');

	        $of_options[] = array(  'name'  => '', //esc_html__( 'Sticky Navigation Height', 'inverto' ),
                                    'desc'  => esc_html__( 'Sticky Navigation Height in pixels. E.g.: "50".', 'inverto' ),
                                    'id'    => 'sticky_height',
                                    'std'   => ISHINVERTOTHEME_DEFAULT_STICKY_HEIGHT,
		                            'fold'  => 'sticky_nav',
                                    'type'  => 'text');

            // Main Navigation Extras **********************************************************************************
            $extras_title = esc_html__( 'Main Navigation Extras', 'inverto' );

            if (ishinvertotheme_woocommerce_plugin_active()){
		        $of_options[] = array(  'name'  => $extras_title,
		                                'desc'  => esc_html__( 'Add Shopping Cart', 'inverto' ),
		                                'id'    => 'use_main_nav_cart',
		                                'std'   => 0,
		                                'type'  => 'switch');
                $extras_title = '';
		    }

            if ( ishinvertotheme_wpml_plugin_active() ){
                $of_options[] = array(  'name'  => $extras_title,
                                        'desc'  => esc_html__( 'Add Language Selector', 'inverto' ),
                                        'id'    => 'main_nav_languages',
                                        'std'   => 0,
                                        'type'  => 'switch');
                $extras_title = '';
            }

            $of_options[] = array(  'name'  => $extras_title,
                                    'desc'  => esc_html__( 'Add Search Form', 'inverto' ),
                                    'id'    => 'use_navigation_search',
                                    'std'   => '1',
                                    'type'  => 'switch');

	        $of_options[] = array(  'name'  => '', // esc_html__( 'Expandable area', 'inverto' ),
		                            'desc'  => esc_html__( 'Add Expandable Area.', 'inverto' ),
		                            'id'    => 'expandable_header',
		                            'std'   => 1, //0,
		                            'folds' => 1,
		                            'type'  => 'switch');

		    $of_options[] = array(  'name'      => '', //'name' => esc_html__( 'Expandable header sidebar', 'inverto' ),
		                            'desc'      => esc_html__( 'Select which sidebar will be displayed inside the expandable area by default.', 'inverto' ),
		                            'id'        => 'header_sidebar',
		                            'std'       => 'sidebar-header',
		                            'fold'      => 'expandable_header',
		                            'type'      => 'select',
		                            'options'   => $of_sidebars);

	        // HEADER BAR **********************************************************************************************
            $of_options[] = array(  'name' => esc_html__( 'Header Top Bar', 'inverto' ),
                                    'desc' => esc_html__( 'Show the header top bar used to display social icons and menu', 'inverto' ),
                                    'id' => 'use_header_bar',
                                    'std' => 1,
                                    'folds' => 1,
                                    'type' => 'switch');

            $of_options[] = array(  'name' => '', //'name' => esc_html__( 'Expandable header sidebar', 'inverto' ),
                                    'desc' => esc_html__( 'Select which menu to display in top bar', 'inverto' ),
                                    'id' => 'header_bar_menu',
                                    'std' => 'header-bar-menu',
                                    'fold' => 'use_header_bar',
                                    'type' => 'select',
                                    'options' => $of_menus);

            $of_options[] = array(  'name' => '', //'name' => esc_html__( 'Expandable header sidebar', 'inverto' ),
                                    'desc' => esc_html__( 'Positions', 'inverto' ),
                                    'id' => 'header_bar_order',
                                    'std' => 'social-left',
                                    'fold' => 'use_header_bar',
                                    'type' => 'select',
                                    'options' => array(
                                        'social-left' => esc_html__( 'Social on left / Menu on right', 'inverto' ),
                                        'social-right' => esc_html__( 'Menu on left / Social on right', 'inverto' ),
                                    ));

		    if (ishinvertotheme_woocommerce_plugin_active()){
		        $of_options[] = array(  'name'  => '', //esc_html__( 'Shopping Cart', 'inverto' ),
		                                'desc'  => esc_html__( 'Add Shopping Cart', 'inverto' ),
		                                'id'    => 'use_header_bar_cart',
		                                'std'   => '0',
		                                'fold'  => 'use_header_bar',
		                                'type'  => 'switch');
		    }

	        if ( ishinvertotheme_wpml_plugin_active() ){
                $of_options[] = array(  'name'  => '', //esc_html__( 'Language Selector', 'inverto' ),
                                        'desc'  => esc_html__( 'Add Language Selector', 'inverto' ),
                                        'id'    => 'header_bar_languages',
                                        'std'   => '0',
                                        'fold'  => 'use_header_bar',
                                        'type'  => 'switch');
            }

            $of_options[] = array(  'name'  => '', //esc_html__( 'Header Bar navigation search form', 'inverto' ),
                                    'desc'  => esc_html__( 'Add Search Form', 'inverto' ),
                                    'id'    => 'use_header_bar_search',
                                    'std'   => 0,
	                                'fold' => 'use_header_bar',
                                    'type'  => 'switch');

            $of_options[] = array(  'name'  => esc_html__( 'Header Top Bar Icons', 'inverto' ),
                                    'class' => 'ish-sub-section',
                                    'desc'  => esc_html__( 'Social icons: Paste the social icons using the [ish_icon] shortcode', 'inverto' ),
                                    'id'    => 'social_icons_bar',
                                    'std'   => $social_icons_bar,
	                                'fold' => 'use_header_bar',
                                    'type'  => 'textarea');

            $of_options[] = array(  'name' => esc_html__( 'Title/Taglines Position', 'inverto' ),
                                    'desc' => esc_html__( 'How titles and custom taglines will be displayed.', 'inverto' ),
                                    'id' => 'title_area_style',
                                    'std' => 'left',
                                    'type' => 'select',
                                    'options' => array(
                                        'left' => esc_html__( 'Left aligned', 'inverto' ),
                                        'box' => esc_html__( 'Centered Box', 'inverto' ),
                                    ));



	    do_action( 'ish_theme_options_after_header_options' );
	    do_action( 'ish_theme_options_before_footer_options' );

        /* *************************************************************************************************************
         * 3. Footer Settings
         */
        $of_options[] = array(  'name'  => esc_html__( 'Footer Options', 'inverto' ),
                                'class' => 'footeroptions',
                                'type'  => 'heading');

            // FOOTER WIDGETS ******************************************************************************************
            $of_options[] = array(  'name'  => esc_html__( 'Footer widget area', 'inverto' ),
                                    'desc'  => esc_html__( 'Show the footer widget area.', 'inverto' ),
                                    'id'    => 'footer_widget_area',
                                    'std'   => 1,
                                    'folds' => 1,
                                    'type'  => 'switch');

            $of_options[] = array( 'name'      =>  esc_html__( 'Widgetized Sidebar', 'inverto' ),
                                   'class'     => 'ish-sub-section',
                                   'desc'      => esc_html__( 'Select which sidebar will be displayed inside the footer widget area by default.', 'inverto' ),
                                   'id'        => 'footer_sidebar',
                                   'std'       => 'sidebar-footer',
                                   'fold'      => 'footer_widget_area',
                                   'type'      => 'select',
                                   'options'   => $of_sidebars);

            $of_options[] = array( 'name'      => esc_html__( 'Text Alignment', 'inverto' ),
                                   'class'     => 'ish-sub-section',
                                   'desc'      => esc_html__( 'Default footer widgets text alignment.', 'inverto' ),
                                   'id'        => 'footer_text_align',
                                   'std'       => 'center',
                                   'fold'      => 'footer_widget_area',
                                   'type'      => 'select',
                                   'options'   => Array(
                                        'left'      => esc_html__( 'Left', 'inverto' ),
                                        'center'    => esc_html__( 'Center', 'inverto' ),
                                        'right'     => esc_html__( 'Right', 'inverto' ),
                                   ),
            );

            // FOOTER LEGALS *******************************************************************************************
	        $of_options[] = array(  'name'  => esc_html__( 'Footer legals area', 'inverto' ),
                                    'desc'  => esc_html__( 'Show content in the footer legals area.', 'inverto' ),
                                    'id'    => 'footer_legals_area',
                                    'std'   => $footer_legals_area,
                                    'type'  => 'textarea');

	    do_action( 'ish_theme_options_after_footer_options' );

	    // PORTFOLIO SETTINGS COME HERE

	    do_action( 'ish_theme_options_before_blog_options' );


        /* *************************************************************************************************************
         * 5. Blog Settings
         */
        $of_options[] = array(  'name'  => esc_html__( 'Blog Options', 'inverto' ),
                                'class' => 'blogoptions',
                                'type'  => 'heading');

	        // BLOG STYLE **********************************************************************************************
	        $of_options[] = array(  'name'      => esc_html__( 'Blog Overview Style', 'inverto' ),
                                    'desc'      => esc_html__( 'Choose how the blog overview page will look like.', 'inverto' ),
                                    'id'        => 'blog_overview_style',
                                    'std'       => '2columns', //'classic',
                                    'type'      => 'select',
                                    'options'   => array(
	                                    'classic'       => esc_html__( 'Classic', 'inverto' ),
	                                    //'fullwidth'     => esc_html__( 'Full-width', 'inverto' ),
	                                    //'masonry'       => esc_html__( 'Masonry', 'inverto' ),
	                                    '2columns'       => esc_html__( '2 Columns', 'inverto' ),
                                    ));

            $of_options[] = array(  'name'      => esc_html__( 'Classic Blog Alignment', 'inverto' ),
                                    'class' => 'ish-sub-section',
                                    'desc'      => esc_html__( 'Chose where the texts will be aligned on Classic Blog Style. ', 'inverto' ),
                                    'id'        => 'blog_classic_align',
                                    'std'       => 'center', //'classic',
                                    'type'      => 'select',
                                    'options'   => array(
                                        'left'       => esc_html__( 'Left', 'inverto' ),
                                        'center'       => esc_html__( 'Center', 'inverto' ),
                                        'right'       => esc_html__( 'Right', 'inverto' ),
                                    ));

	        /*$of_options[] = array(  'name' => esc_html__( 'Masonry Options', 'inverto' ),
								    'desc' => esc_html__( 'Masonry Layout Style - Regular Grid or Proportional Tiles.', 'inverto' ),
								    'id' => 'blog_masonry_layout_style',
								    'std' => 'grid-boxes',
								    'type' => 'select',
								    'options' => Array(
									    //'grid' => 'Grid - Same widths, auto heights, ',
									    'grid-boxes' => 'Grid Boxes - Same widths, auto heights',
									    //'tiles' => 'Tiles - Widths & heights as in post settings',
								    ),
		    );

		    $of_options[] = array(  'name' => '', //esc_html__( '', 'inverto' ),
									'desc' => esc_html__( 'Number of columns to display in the Masonry Blog Grid.', 'inverto' ),
									'id' => 'blog_masonry_columns',
									'std' => '2',
									'type' => 'select',
									'options' => Array(
										'3' => '3',
										'2' => '2',
										'1' => '1',
									),
			);

		    $of_options[] = array(  'name' => '', //esc_html__( '', 'inverto' ),
								    'desc' => esc_html__( 'Masonry Row Style - Keep the grid within content or expand to full width.', 'inverto' ),
								    'id' => 'blog_masonry_row_style',
								    'std' => 'full',
								    'type' => 'select',
								    'options' => Array(
									    'notfull' => 'Regular',
									    'full' => 'Full-width',
								    ),
		    );*/


	        // FEATURED POST *******************************************************************************************
	        $of_options[] = array(  'name'  => 'Featured Post', //esc_html__( '', 'inverto' ),
                                    'desc'  => esc_html__( 'Display the featured post instead ot the header of the blog overview page.', 'inverto' ),
                                    'id'    => 'blog_featured_post',
                                    'std' => 'first-post',
								    'type' => 'select',
								    'options' => Array(
									    '' => esc_html__( 'Do not feature', 'inverto' ),
									    'first-post' => esc_html__( 'Feature first (latest) post', 'inverto' ),
									),
	        );

	        // BLOG CATEGORIES BAR *************************************************************************************
            $of_options[] = array(  'name'  => esc_html__( 'Display Categories Bar', 'inverto' ),
                                    'desc'  => esc_html__( 'Display a bar with all Blog categories on overview pages.', 'inverto' ),
                                    'id'    => 'show_blog_categories',
                                    'std'   => 0, //1,
                                    'type'  => 'switch');

	        // BLOG SIDEBAR ********************************************************************************************
            $of_options[] = array(  'name'  => esc_html__( 'Blog Sidebar', 'inverto' ),
                                    'desc'  => esc_html__( 'Display Sidebar on Blog overview and Blog detail pages.', 'inverto' ),
                                    'id'    => 'show_blog_sidebar',
                                    'std'   => 0, //1,
                                    'folds' => 1,
                                    'type'  => 'switch');

            $of_options[] = array(  'name'      => '', //'name' => esc_html__( 'Blog Sidebar position', 'inverto' ),
                                    'desc'      => esc_html__( 'Choose whether to display the sidebar on the left or on the right side of the page.', 'inverto' ),
                                    'id'        => 'blog_sidebar_position',
                                    'std'       => 'right',
                                    'fold'      => 'show_blog_sidebar',
                                    'type'      => 'select',
                                    'options'   => array(
	                                    'left'  => 'Left',
	                                    'right' => 'Right'
                                    ));

            $of_options[] = array(  'name'      => '', //'name' => esc_html__( 'Blog Sidebar', 'inverto' ),
                                    'desc'      => esc_html__( 'Select which sidebar will be displayed on Blog overview and Blog detail pages.', 'inverto' ),
                                    'id'        => 'blog_sidebar',
                                    'std'       => 'sidebar-main',
                                    'fold'      => 'show_blog_sidebar',
                                    'type'      => 'select',
                                    'options'   => $of_sidebars);

	        // PREV/NEXT & SOCIAL SHARING ******************************************************************************
            $of_options[] = array(  'name' => esc_html__( 'Post Detail Page - Prev/Next & Sharing', 'inverto' ),
                                    'desc' => esc_html__( 'Choose what to display at the bottom of the Post Detail page.', 'inverto' ),
                                    'id' => 'single_post_details',
                                    'std' => 'nav-social',
                                    'type' => 'select',
                                    'options' => Array(
                                        ''  => esc_html__( 'None', 'inverto'),
                                        'nav'  => esc_html__( 'Prev/Next Navigation', 'inverto'),
                                        'social'  => esc_html__( 'Sharing Icons', 'inverto'),
                                        'nav-social'  => esc_html__( 'Prev/Next Navigation & Sharing Icons', 'inverto'),
                                    ),
            );

	    do_action( 'ish_theme_options_after_blog_options' );
	    do_action( 'ish_theme_options_before_themes_skins' );

	    /* *************************************************************************************************************
         * Theme Skins
         */

        $of_options[] = array(  'name'  => esc_html__( 'Theme Skins', 'inverto' ),
                                'class' => 'themeskins',
                                'type'  => 'heading');

	        // THEME SKINS *********************************************************************************************
            $of_options[] = array(  'name'      => esc_html__( 'Theme Skins', 'inverto' ),
                                    'desc'      => esc_html__( 'Select one of the pre-defined skins.', 'inverto' ) . '<br><br><span style="color: red;">' . '<strong>' . esc_html__( 'IMPORTANT:', 'inverto' ) . '</strong><br>' . esc_html__( 'Changing the skin will reset all your currently defined Colors, Patterns, Fonts and Boxed Layout options.', 'inverto' ) . '</span>',
                                    'id'        => 'skin',
                                    'std'       => ISHINVERTOTHEME_DEFAULT_SKIN,
                                    'type'      => 'images',
                                    //'fold'    => 'use_skin',
                                    'options'   => $ish_alt_stylesheets_imgs);


	    do_action( 'ish_theme_options_after_themes_skins' );
	    do_action( 'ish_theme_options_before_color_options' );

	    /* *************************************************************************************************************
         * Color Options
         */
        $of_options[] = array(  'name'  => esc_html__( 'Color Options', 'inverto' ),
                                'class' => 'coloroptions',
                                'type'  => 'heading');

		    // GLOBAL COLORS *******************************************************************************************
            $of_options[] = array(  'name'  => esc_html__( 'Global Colors', 'inverto' ),
                                    'desc'  => esc_html__( 'Text color', 'inverto' ),
                                    'id'    => 'text_color',
                                    'std'   => ISHINVERTOTHEME_TEXT_COLOR,
                                    //'fold' => 'off_' . 'use_skin',
                                    'type'  => 'color');

            $of_options[] = array( 	'name'  => '', //esc_html__( '', 'inverto' ),
                                    'desc'  => esc_html__( 'Body content color', 'inverto' ),
                                    'id'    => 'body_color',
                                    'std'   => ISHINVERTOTHEME_BODY_COLOR,
                                    'type' 	=> 'color');

            $of_options[] = array( 	'name'  => '', //esc_html__( '', 'inverto' ),
                                    'desc'  => esc_html__( 'Background color (when no pattern or image)', 'inverto' ),
                                    'id'    => 'background_color',
                                    'std'   => ISHINVERTOTHEME_BACKGROUND_COLOR,
                                    'type' 	=> 'color');

	        // ADDITIONAL COLORS ***************************************************************************************
		    for ($i = 1; $i <= ISHINVERTOTHEME_COLORS_COUNT; $i++){
			    $of_options[] = array(  'name'  => ( ( 1 == $i) ? esc_html__( 'Theme Colors', 'inverto' ) : '' ),
				                        'class' => 'ish-main-colors' . ' ish-item-' . $i,
			                            'desc'  => esc_html__( 'Color', 'inverto' ) . ' ' . $i,
				                        'id'    => 'color' . $i,
				                        'std'   => ( '' != $ishinvertotheme_default_colors[ $i ] ) ? $ishinvertotheme_default_colors[ $i ] : '#ffffff',
				                        'type'  => 'color');
		    }

	        // HEADER BAR COLORS ***************************************************************************************
            $of_options[] = array( 	'name'  => esc_html__( 'Header Top Bar Colors', 'inverto' ),
                                    'desc'  => '', //esc_html__( '', 'inverto' ),
                                    'id'    => 'header_bar_colors',
                                    'std'   => array(
	                                    'bg'            => $ishinvertotheme_default_colors[4],
                                        'text'          => $ishinvertotheme_default_colors[1],
                                        'text_active'   => $ishinvertotheme_default_colors[5]
                                    ),
                                    'type' 	=> 'color_set');


	        // HEADER BAR NAVIGATION COLORS ****************************************************************************
            /*$of_options[] = array( 	'name'  => esc_html__( 'Header Bar Navigation Colors', 'inverto' ),
                                    'desc'  => '', //esc_html__( '', 'inverto' ),
                                    'id'    => 'header_bar_nav_colors',
                                    'std'   => array(
	                                    'bg'            => '',
	                                    'bg_active'     => '',
                                        'text'          => $ishinvertotheme_default_colors[2],
                                        'text_active'   => $ishinvertotheme_default_colors[5]
                                    ),
                                    'type' 	=> 'color_set');*/

	        // HEADER BAR NAVIGATION SUBMENU COLORS ********************************************************************
            $of_options[] = array( 	'name'  => esc_html__( 'Submenu Colors', 'inverto' ), //esc_html__( 'Header Bar Navigation Submenu Colors', 'inverto' ),
                                    'class' => 'ish-sub-section',
                                    'desc'  => '', //esc_html__( '', 'inverto' ),
                                    'id'    => 'header_bar_nav_submenu_colors',
                                    'std'   => array(
	                                    'bg'            => $ishinvertotheme_default_colors[4],
	                                    //'bg_active'     => '',
                                        'text'          => $ishinvertotheme_default_colors[1],
                                        'text_active'   => $ishinvertotheme_default_colors[5]
                                    ),
                                    'type' 	=> 'color_set');

	        $of_options[] = array(	'name'  => esc_html__( 'Background Opacity', 'inverto' ),
	                                'class' => 'ish-sub-section',
                                    'desc'  => esc_html__( 'Header Bar Background opacity in %.', 'inverto' ),
                                    'id'    => 'header_bar_colors_bg_opacity',
                                    'std'   => ISHINVERTOTHEME_DEFAULT_HEADER_BAR_OPACITY,
                                    "min"   => '0',
                                    "step"  => '1',
                                    "max"   => '100',
                                    'type'  => 'sliderui' );

	        // HEADER COLORS *******************************************************************************************
            $of_options[] = array( 	'name'  => esc_html__( 'Header Colors - Default Style', 'inverto' ),
                                    'desc'  => '', //esc_html__( '', 'inverto' ),
                                    'id'    => 'header_colors',
                                    'std'   => array(
	                                    'bg'            => $ishinvertotheme_default_colors[3],
                                        'text'          => $ishinvertotheme_default_colors[1],
                                        'text_active'   => $ishinvertotheme_default_colors[5]
                                    ),
                                    'type' 	=> 'color_set');

	        $of_options[] = array( 	'name'  => esc_html__( 'Main Navigation Colors', 'inverto' ),
                                    'class' => 'ish-sub-section',
                                    'desc'  => '', //esc_html__( '', 'inverto' ),
                                    'id'    => 'main_nav_colors',
                                    'std'   => array(
	                                    'bg'            => '',
	                                    'bg_active'     => $ishinvertotheme_default_colors[6],
                                        'text'          => $ishinvertotheme_default_colors[1],
                                        'text_active'   => $ishinvertotheme_default_colors[5]
                                    ),
                                    'type' 	=> 'color_set');

	        $of_options[] = array( 	'name'  => esc_html__( 'Submenu Colors', 'inverto' ),
	                                'class' => 'ish-sub-section',
                                    'desc'  => '', //esc_html__( '', 'inverto' ),
                                    'id'    => 'main_nav_submenu_colors',
                                    'std'   => array(
	                                    'bg'            => $ishinvertotheme_default_colors[6],
	                                    'bg_active'     => '',
                                        'text'          => $ishinvertotheme_default_colors[1],
                                        'text_active'   => $ishinvertotheme_default_colors[5]
                                    ),
                                    'type' 	=> 'color_set');

	        $of_options[] = array(	'name'  => esc_html__( 'Background Opacity in %', 'inverto' ),
                                    'class' => 'ish-sub-section',
                                    'desc'  => '<span style="color: #FF0000;">' . '<strong>' . esc_html__( 'IMPORTANT:', 'inverto' ) . '</strong> ' . esc_html__( 'For pattern or background image set "0".', 'inverto' ) . ' ' . esc_html__( 'For solid color - "100".', 'inverto' ) . '</span>',
                                    'id'    => 'header_colors_bg_opacity',
                                    'std'   => ISHINVERTOTHEME_DEFAULT_HEADER_OPACITY,
                                    "min"   => '0',
                                    "step"  => '1',
                                    "max"   => '100',
                                    'type'  => 'sliderui' );

	        // ALTERNATIVE - HEADER COLORS *******************************************************************************************
            $of_options[] = array( 	'name'  => esc_html__( 'Header Colors - Alternative Style', 'inverto' ),
                                    'desc'  => '', //esc_html__( '', 'inverto' ),
                                    'id'    => 'header_colors_alternative',
                                    'std'   => array(
	                                    'bg'            => $ishinvertotheme_default_colors[3],
                                        'text'          => $ishinvertotheme_default_colors[1],
                                        'text_active'   => $ishinvertotheme_default_colors[5]
                                    ),
                                    'type' 	=> 'color_set');

	        $of_options[] = array( 	'name'  => esc_html__( 'Main Navigation Colors - Alternative Style', 'inverto' ),
	                                'class' => 'ish-sub-section',
                                    'desc'  => '', //esc_html__( '', 'inverto' ),
                                    'id'    => 'main_nav_colors_alternative',
                                    'std'   => array(
	                                    'bg'            => '',
	                                    'bg_active'     => $ishinvertotheme_default_colors[6],
                                        'text'          => $ishinvertotheme_default_colors[1],
                                        'text_active'   => $ishinvertotheme_default_colors[5]
                                    ),
                                    'type' 	=> 'color_set');

	        $of_options[] = array( 	'name'  => esc_html__( 'Submenu Colors - Alternative Style', 'inverto' ),
	                                'class' => 'ish-sub-section',
                                    'desc'  => '', //esc_html__( '', 'inverto' ),
                                    'id'    => 'main_nav_submenu_colors_alternative',
                                    'std'   => array(
	                                    'bg'            => $ishinvertotheme_default_colors[6],
	                                    'bg_active'     => '',
                                        'text'          => $ishinvertotheme_default_colors[1],
                                        'text_active'   => $ishinvertotheme_default_colors[5]
                                    ),
                                    'type' 	=> 'color_set');

	        $of_options[] = array(	'name'  => esc_html__( 'Background Opacity in % - Alternative Style', 'inverto' ),
                                    'class' => 'ish-sub-section',
                                    'desc'  => '<span style="color: #FF0000;">' . '<strong>' . esc_html__( 'IMPORTANT:', 'inverto' ) . '</strong> ' . esc_html__( 'For pattern or background image set "0".', 'inverto' ) . ' ' . esc_html__( 'For solid color - "100".', 'inverto' ) . '</span>',
                                    'id'    => 'header_colors_alternative_bg_opacity',
                                    'std'   => ISHINVERTOTHEME_DEFAULT_HEADER_OPACITY,
                                    "min"   => '0',
                                    "step"  => '1',
                                    "max"   => '100',
                                    'type'  => 'sliderui' );

	        // TAGLINE COLORS ******************************************************************************************
            $of_options[] = array( 	'name'  => esc_html__( 'Tagline Colors', 'inverto' ),
                                    'desc'  => '', //esc_html__( '', 'inverto' ),
                                    'id'    => 'tagline_colors',
                                    'std'   => array(
	                                    'bg'            => $ishinvertotheme_default_colors[3],
	                                    'headline_1'    => $ishinvertotheme_default_colors[5],
	                                    'headline_2'    => $ishinvertotheme_default_colors[1]
                                    ),
	                                'type' 	=> 'color_set');

			// BREADCRUMBS BAR COLORS **********************************************************************************
            $of_options[] = array( 	'name'  => esc_html__( 'Breadcrumbs Bar Colors', 'inverto' ),
                                    'desc'  => '', //esc_html__( '', 'inverto' ),
                                    'id'    => 'breadcrumbs_colors',
                                    'std'   => array(
	                                    'bg'            => $ishinvertotheme_default_colors[4],
                                        'text'          => $ishinvertotheme_default_colors[5],
                                        'link'          => $ishinvertotheme_default_colors[1],
                                        'link_active'   => $ishinvertotheme_default_colors[5]
                                    ),
	                                'type' 	=> 'color_set');

	        // SIDEBAR COLORS ******************************************************************************************
            $of_options[] = array( 	'name'  => esc_html__( 'Sidebar Colors', 'inverto' ),
                                    'desc'  => '', //esc_html__( '', 'inverto' ),
                                    'id'    => 'sidebar_colors',
                                    'std'   => array(
	                                    'title'         => $ishinvertotheme_default_colors[2],
	                                    'text'          => $ishinvertotheme_default_colors[1],
	                                    'link1'         => $ishinvertotheme_default_colors[1],
	                                    'link1_active'  => $ishinvertotheme_default_colors[5],
	                                    'link2'         => $ishinvertotheme_default_colors[5],
	                                    'link2_active'  => $ishinvertotheme_default_colors[1],
	                                    'block_bg'      => $ishinvertotheme_default_colors[6],
	                                    'block_text'    => $ishinvertotheme_default_colors[1]
                                    ),
                                    'type' 	=> 'color_set');

            // FOOTER COLORS *******************************************************************************************
	        $of_options[] = array( 	'name'  => esc_html__( 'Footer Colors', 'inverto' ),
	                              'desc'  => '', //esc_html__( '', 'inverto' ),
	                              'id'    => 'footer_colors',
	                              'std'   => array(
		                              'bg'            => $ishinvertotheme_default_colors[4],
		                              'title'         => $ishinvertotheme_default_colors[5],
		                              'text'          => $ishinvertotheme_default_colors[1],
		                              'link1'         => $ishinvertotheme_default_colors[5],
		                              'link1_active'  => $ishinvertotheme_default_colors[1],
		                              'link2'         => $ishinvertotheme_default_colors[5],
		                              'link2_active'  => $ishinvertotheme_default_colors[1],
		                              'block_bg'      => $ishinvertotheme_default_colors[6],
		                              'block_text'    => $ishinvertotheme_default_colors[1]
	                              ),
	                              'type' 	=> 'color_set');

            // FOOTER LEGALS COLORS ************************************************************************************
            $of_options[] = array( 	'name'  => esc_html__( 'Footer Legals Colors', 'inverto' ),
                                    'desc'  => '', //esc_html__( '', 'inverto' ),
                                    'id'    => 'footer_legals_colors',
                                    'std'   => array(
	                                    'bg'            => $ishinvertotheme_default_colors[3],
                                        'text'          => $ishinvertotheme_default_colors[1],
                                        'link'          => $ishinvertotheme_default_colors[5],
                                    ),
                                    'type' 	=> 'color_set');

			// SIDENAV COLORS ******************************************************************************************
            $of_options[] = array( 	'name'  => esc_html__( 'Side Navigation Colors', 'inverto' ),
                                    'desc'  => '', //esc_html__( '', 'inverto' ),
                                    'id'    => 'sidenav_colors',
                                    'std'   => array(
	                                    'bg'            => $ishinvertotheme_default_colors[3],
                                        'title'         => $ishinvertotheme_default_colors[2],
                                        'text'          => $ishinvertotheme_default_colors[1],
                                        'link1'         => $ishinvertotheme_default_colors[1],
                                        'link1_active'  => $ishinvertotheme_default_colors[5],
                                        'link2'         => $ishinvertotheme_default_colors[5],
										'link2_active'  => $ishinvertotheme_default_colors[1],
	                                    'block_bg'      => $ishinvertotheme_default_colors[6],
	                                    'block_text'    => $ishinvertotheme_default_colors[1]
                                    ),
                                    'type' 	=> 'color_set');

			// RESPNAV COLORS ******************************************************************************************
            $of_options[] = array( 	'name'  => esc_html__( 'Responsive Navigation Colors', 'inverto' ),
                                    'desc'  => '', //esc_html__( '', 'inverto' ),
                                    'id'    => 'respnav_colors',
                                    'std'   => array(
	                                    'bg'            => $ishinvertotheme_default_colors[7],
                                        'link'          => $ishinvertotheme_default_colors[1],
                                        'link_active'   => $ishinvertotheme_default_colors[5]
                                    ),
                                    'type' 	=> 'color_set');

	        // SEARCH COLORS *******************************************************************************************
            $of_options[] = array( 	'name'  => esc_html__( 'Search Colors', 'inverto' ),
                                    'desc'  => '', //esc_html__( '', 'inverto' ),
                                    'id'    => 'search_colors',
                                    'std'   => array(
	                                    'bg'            => $ishinvertotheme_default_colors[7],
                                        'text'          => $ishinvertotheme_default_colors[1],
                                        'text_active'   => $ishinvertotheme_default_colors[5]
                                    ),
                                    'type' 	=> 'color_set');

	        // EXPANDABLE AREA COLORS **********************************************************************************
            $of_options[] = array( 	'name'  => esc_html__( 'Expandable Area Colors', 'inverto' ),
                                    'desc'  => '', //esc_html__( '', 'inverto' ),
                                    'id'    => 'exparea_colors',
                                    'std'   => array(
	                                    'bg'            => $ishinvertotheme_default_colors[7],
	                                    'title'         => $ishinvertotheme_default_colors[6],
	                                    'text'          => $ishinvertotheme_default_colors[6],
	                                    'link1'         => $ishinvertotheme_default_colors[3],
	                                    'link1_active'  => $ishinvertotheme_default_colors[5],
	                                    'link2'         => $ishinvertotheme_default_colors[5],
	                                    'link2_active'  => $ishinvertotheme_default_colors[3],
	                                    'block_bg'      => $ishinvertotheme_default_colors[1],
	                                    'block_text'    => $ishinvertotheme_default_colors[3]
                                    ),
                                    'type' 	=> 'color_set');


	    do_action( 'ish_theme_options_after_color_options' );
	    do_action( 'ish_theme_options_before_pattern_options' );

	    /* *************************************************************************************************************
         * Pattern Options
         */
        $of_options[] = array(  'name'  => esc_html__( 'Pattern Options', 'inverto' ),
                                'class' => 'patternoptions',
                                'type'  => 'heading');

            // BACKGROUND PATTERN (BOXED LAYOUT ONLY) ******************************************************************
            $of_options[] = array(  'name'  => esc_html__( 'Background Pattern (Boxed layout only)', 'inverto' ),
                                    'desc'  => '', //esc_html__( '', 'inverto' ),
                                    'id'    => 'use_background_pattern',
                                    'std'   => 0,
                                    'on'    => esc_html__( 'Predefined', 'inverto' ),
                                    'off'   => esc_html__( 'Custom', 'inverto' ),
                                    'folds' => 1,
                                    'type'  => 'switch');

            $of_options[] = array( 	'name' 		=> '', //esc_html__( '', 'inverto' ),
                                    'desc' 		=>  esc_html__( 'Choose one of the pre-defined patterns.', 'inverto' ),
                                    'id' 		=> 'background_bg_pattern',
                                    'std' 		=> '',
                                    'type' 		=> 'tiles',
                                    'fold'      => 'use_background_pattern',
                                    'options'   => $ish_bg_images);

            $of_options[] = array(  'name'  => '', //esc_html__( '', 'inverto' ),
                                    'desc'  => esc_html__( 'Upload and select custom pattern.', 'inverto' ),
                                    'id'    => 'background_bg_image',
                                    'std'   => ISHINVERTOTHEME_HTML_URI . '/images/bg-images/bg_01.jpg',
                                    'fold'  => 'off_' . 'use_background_pattern',
                                    'mod'   => 'min',
                                    'type'  => 'media');

            $of_options[] = array(  'name'      => '', //esc_html__( '', 'inverto' ),
                                    'desc'      => esc_html__( 'Background position', 'inverto' ),
                                    'id'        => 'background_bg_image_cover',
                                    'std'       => 1,
                                    'fold'      => 'off_' . 'use_background_pattern',
                                    'type'      => 'radio',
                                    'options'   => array(
	                                    '0'     => esc_html__( 'Repeat and scroll', 'inverto' ),
                                        '1'     => esc_html__( 'Fixed and cover', 'inverto' ),
                                    ));

            // HEADER PATTERN ******************************************************************************************
            $of_options[] = array(  'name' => esc_html__( 'Header pattern', 'inverto' ),
                                    'desc' => 'solid-light-cream-pixels.png', //esc_html__( '', 'inverto' ),
                                    'id' => 'use_header_pattern',
                                    'std' => 1,
                                    'on' => esc_html__( 'Predefined', 'inverto' ),
                                    'off' => esc_html__( 'Custom', 'inverto' ),
                                    'folds' => 1,
                                    'type' => 'switch');

            $of_options[] = array( 	'name' 		=> '',
                                    'desc' 		=>  esc_html__( 'Choose one of the pre-defined patterns.', 'inverto' ) . '<br><br><span style="color: #FF0000;">' . '<strong>' . esc_html__( 'IMPORTANT:', 'inverto' ) . '</strong><br>' . esc_html__( 'The Header background color opacity must not be set to "100". See "Color Options" section.', 'inverto' ), // . ' ' . '<a href="#section-header_colors">' . esc_html__( 'See setting', 'inverto' ) . '</a>' .  '</span>',
                                    'id' 		=> 'header_bg_pattern',
                                    'std' 		=> '',
                                    'type' 		=> 'tiles',
                                    'fold'      => 'use_header_pattern',
                                    'options' 	=> $ish_bg_images);

            $of_options[] = array(  'name' => '',
                                    'desc' => esc_html__( 'Upload and select custom pattern.', 'inverto' ) . '<br><br><span style="color: #FF0000;">' . '<strong>' . esc_html__( 'IMPORTANT:', 'inverto' ) . '</strong><br>' . esc_html__( 'The Header background color opacity must not be set to "100". See "Color Options" section.', 'inverto' ), // . ' ' . '<a href="#section-header_colors">' . esc_html__( 'See setting', 'inverto' ) . '</a>' .  '</span>',
                                    'id' => 'header_bg_image',
                                    'std' => '',
                                    'fold' => 'off_' . 'use_header_pattern',
                                    'mod' => 'min',
                                    'type' => 'media');

	        $of_options[] = array(  'name'      => '', //esc_html__( '', 'inverto' ),
                                    'desc'      => esc_html__( 'Background position', 'inverto' ),
                                    'id'        => 'header_bg_image_cover',
                                    'std'       => 0,
                                    'fold'      => 'off_' . 'use_header_pattern',
                                    'type'      => 'radio',
                                    'options'   => array(
	                                    '0'     => esc_html__( 'Repeat and scroll', 'inverto' ),
                                        '1'     => esc_html__( 'Cover', 'inverto' ),
                                    ));

	        // Expandable Pattern
            $of_options[] = array(  'name' => esc_html__( 'Expandable area pattern', 'inverto' ),
                                    'desc' => '', //esc_html__( '', 'inverto' ),
                                    'id' => 'use_expandable_pattern',
                                    'std' => 1,
                                    'on' => esc_html__( 'Predefined', 'inverto' ),
                                    'off' => esc_html__( 'Custom', 'inverto' ),
                                    'folds' => 1,
                                    'type' => 'switch');

            $of_options[] = array( 	'name' 		=> '',
                                    'desc' 		=>  esc_html__( 'Choose one of the pre-defined patterns.', 'inverto' ),
                                    'id' 		=> 'expandable_bg_pattern',
                                    'std' 		=> '',
                                    'type' 		=> 'tiles',
                                    'fold'      => 'use_expandable_pattern',
                                    'options' 	=> $ish_bg_images,
                                    );

            $of_options[] = array(  'name' => '',
                                    'desc' => esc_html__( 'Upload and select custom pattern.', 'inverto' ),
                                    'id' => 'expandable_bg_image',
                                    'std' => '',
                                    'fold' => 'off_' . 'use_expandable_pattern',
                                    'mod' => 'min',
                                    'type' => 'media');

	        $of_options[] = array(  'name'      => '', //esc_html__( '', 'inverto' ),
                                    'desc'      => esc_html__( 'Background position', 'inverto' ),
                                    'id'        => 'expandable_bg_image_cover',
                                    'std'       => 1,
                                    'fold'      => 'off_' . 'use_expandable_pattern',
                                    'type'      => 'radio',
                                    'options'   => array(
	                                    '0'     => esc_html__( 'Repeat and scroll', 'inverto' ),
                                        '1'     => esc_html__( 'Cover', 'inverto' ),
                                    ));

            // LEAD / TAGLINE PATTERN ********************************************************************************************
            $of_options[] = array(  'name' => esc_html__( 'Tagline pattern', 'inverto' ),
                                    'desc' => '', //esc_html__( '', 'inverto' ),
                                    'id' => 'use_lead_pattern',
                                    'std' => 1,
                                    'on' => esc_html__( 'Predefined', 'inverto' ),
                                    'off' => esc_html__( 'Custom', 'inverto' ),
                                    'folds' => 1,
                                    'type' => 'switch');

            $of_options[] = array( 	'name' 		=> '',
                                    'desc' 		=>  esc_html__( 'Choose one of the pre-defined patterns.', 'inverto' ),
                                    'id' 		=> 'lead_bg_pattern',
                                    'std' 		=> '',
                                    'type' 		=> 'tiles',
                                    'fold'      => 'use_lead_pattern',
                                    'options' 	=> $ish_bg_images);

            $of_options[] = array(  'name' => '',
                                    'desc' => esc_html__( 'Upload and select custom pattern.', 'inverto' ),
                                    'id' => 'lead_bg_image',
	                                'std'   => '', //ISHINVERTOTHEME_HTML_URI . '/images/bg-images/taglines_bg.jpg',
                                    'fold' => 'off_' . 'use_lead_pattern',
                                    'mod' => 'min',
                                    'type' => 'media');

	        $of_options[] = array(  'name'      => '', //esc_html__( '', 'inverto' ),
                                    'desc'      => esc_html__( 'Background position', 'inverto' ),
                                    'id'        => 'lead_bg_image_cover',
                                    'std'       => 1,
                                    'fold'      => 'off_' . 'use_lead_pattern',
                                    'type'      => 'radio',
                                    'options'   => array(
	                                    '0'     => esc_html__( 'Repeat and scroll', 'inverto' ),
                                        '1'     => esc_html__( 'Cover', 'inverto' ),
                                    ));

	        $of_options[] = array(  'name'  => '', //esc_html__( '', 'inverto' ),
                                    'desc'  => esc_html__( 'Number (0 - 100) representing the image opacity in %. 100 - visible, 0 - invisible.', 'inverto' ),
                                    'id'    => 'lead_bg_opacity',
                                    'std'   => 100,
                                    'type'  => 'text');


            // FOOTER PATTERN ******************************************************************************************
            $of_options[] = array(  'name' => esc_html__( 'Footer Widget area pattern', 'inverto' ),
                                    'desc' => '', //esc_html__( '', 'inverto' ),
                                    'id' => 'use_footer_pattern',
                                    'std' => 1,
                                    'on' => esc_html__( 'Predefined', 'inverto' ),
                                    'off' => esc_html__( 'Custom', 'inverto' ),
                                    'folds' => 1,
                                    'type' => 'switch');

            $of_options[] = array( 	'name' 		=> '',
                                    'desc' 		=>  esc_html__( 'Choose one of the pre-defined patterns.', 'inverto' ),
                                    'id' 		=> 'footer_bg_pattern',
                                    'std' 		=> '',
                                    'type' 		=> 'tiles',
                                    'fold'      => 'use_footer_pattern',
                                    'options' 	=> $ish_bg_images);

            $of_options[] = array(  'name' => '',
                                    'desc' => esc_html__( 'Upload and select custom pattern.', 'inverto' ),
                                    'id' => 'footer_bg_image',
                                    'std' => '',
                                    'fold' => 'off_' . 'use_footer_pattern',
                                    'mod' => 'min',
                                    'type' => 'media');

	        $of_options[] = array(  'name'      => '', //esc_html__( '', 'inverto' ),
                                    'desc'      => esc_html__( 'Background position', 'inverto' ),
                                    'id'        => 'footer_bg_image_cover',
                                    'std'       => 1,
                                    'fold'      => 'off_' . 'use_footer_pattern',
                                    'type'      => 'radio',
                                    'options'   => array(
	                                    '0'     => esc_html__( 'Repeat and scroll', 'inverto' ),
                                        '1'     => esc_html__( 'Cover', 'inverto' ),
                                    ));

	    do_action( 'ish_theme_options_after_pattern_options' );
	    do_action( 'ish_theme_options_before_font_options' );

	    /* *************************************************************************************************************
         * Font Options
         */
        $of_options[] = array(  'name'  => esc_html__( 'Font Options', 'inverto' ),
                                'class' => 'fontoptions',
                                'type'  => 'heading');

	        // GOOGLE FONT SUBSETS *************************************************************************************
            $of_options[] = array(  'name' => esc_html__( 'Google Fonts Subsets', 'inverto' ),
                                    'desc' => esc_html__( 'Choose which Font Subsets will be loaded if they are available. This will add language specific characters.', 'inverto' ) . '<br><br><span style="color: #FF0000;">' . '<strong>' . esc_html__( 'IMPORTANT:', 'inverto' ) . '</strong><br>' . esc_html__( 'Using many subsets can slow down your webpage. Only select the ones you need.', 'inverto' ) . '</span>',
                                    'id' => 'google_font_subsets',
                                    'std' => array('latin'),
                                    'disabled' => array('latin'),
                                    'type' => 'multicheck',
						            'options' 	=> array(
							            'latin' => esc_html__( 'Latin (Default)', 'inverto' ),
							            'latin-ext' => esc_html__( 'Latin Extended', 'inverto' ),
							            'cyrillic' => esc_html__( 'Cyrillic', 'inverto' ),
							            'cyrillic-ext' => esc_html__( 'Cyrillic Extended', 'inverto' ),
							            'devanagari' => esc_html__( 'Devanagari', 'inverto' ),
							            'greek' => esc_html__( 'Greek', 'inverto' ),
							            'greek-ext' => esc_html__( 'Greek Extended', 'inverto' ),
							            'khmer' => esc_html__( 'Khmer', 'inverto' ),
							            'vietnamese' => esc_html__( 'Vietnamese', 'inverto' ),
						            ),
            );


	        // BODY FONT ***********************************************************************************************
            $id = 'body_font'; // Important!

	        $of_options[] = array(  'name' => esc_html__( 'Body Font 1', 'inverto' ),
                                    'desc' => esc_html__( 'Font Type', 'inverto' ),
                                    'id' => $id . '_use_google_font',
                                    'std' => 1,
                                    'on' => 'Google',
                                    'off' => 'Regular',
                                    'folds' => 1,
                                    'type' => 'switch');

            // GOOGLE FONT
            $of_options[] = array( 	'name' => '', //esc_html__( 'Theme Google Font', 'inverto' ),
                                    'desc' => esc_html__( 'Font Family', 'inverto' ),
                                    'id' =>  $id . '_google',
                                    'std' => ('google' == $ishinvertotheme_fonts[$id]['type']) ? $ishinvertotheme_fonts[$id]['name'] : ISHINVERTOTHEME_FONT_2,
                                    'fold' => $id . '_use_google_font',
                                    'type' => 'select_google_font',
                                    'preview' 	=> array(
                                                    'text' => esc_html__( '0123456789 ABCDEFGHIJKLMNOPQRSTUVWXYZ abcdefghijklmnopqrstuvwxyz', 'inverto' ), //this is the text from preview box
                                                    'size' => '16px' //this is the text size from preview box
                                    ),
                                    'options' 	=> $ish_googleFontsArray);

            $of_options[] = array(  'name' => '', //esc_html__( 'Font Variant', 'inverto' ),
                                    'desc' =>  esc_html__( 'Font Variant', 'inverto' ),
                                    'id' => $id . '_google_variant',
                                    'std' => ('google' == $ishinvertotheme_fonts[$id]['type']) ? $ishinvertotheme_fonts[$id]['variant'] : '400',
                                    'fold' => $id . '_use_google_font',
                                    'type' => 'select',
                                    'options' 	=> ishinvertotheme_google_variants( ('google' == $ish_saved_fonts[$id]['type']) ? $ish_saved_fonts[$id]['name'] : ( ('google' == $ishinvertotheme_fonts[$id]['type']) ? $ishinvertotheme_fonts[$id]['name'] : ISHINVERTOTHEME_FONT_2 ) ) );


            // REGULAR FONT
            $of_options[] = array(  'name' => '', //esc_html__( 'Theme Regular Font', 'inverto' ),
                                    'desc' =>  esc_html__( 'Font Family', 'inverto' ),
                                    'id' => $id . '_regular',
                                    'std' => ('regular' == $ishinvertotheme_fonts[$id]['type']) ? $ishinvertotheme_fonts[$id]['name'] : 'helvetica',
                                    'fold' => 'off_' . $id . '_use_google_font',
                                    'type' => 'select',
                                    'options' 	=> $ish_regular_fonts);

            $of_options[] = array(  'name' => '', //esc_html__( 'Font Variant', 'inverto' ),
                                    'desc' =>  esc_html__( 'Font Variant', 'inverto' ),
                                    'id' => $id . '_regular_variant',
                                    'std' => ('regular' == $ishinvertotheme_fonts[$id]['type']) ? $ishinvertotheme_fonts[$id]['name'] : 'normal',
                                    'fold' => 'off_' . $id . '_use_google_font',
                                    'type' => 'select',
                                    'options' 	=> $ish_regular_variants);

            // OTHER SETTINGS
            $of_options[] = array( 	'name' 		=> '',
                                    'desc' 		=> esc_html__( 'Font Size', 'inverto' ),
                                    'id' 		=> $id . '_size',
                                    'std' 		=> $ishinvertotheme_fonts[$id]['size'],
                                    "min" 		=> '0',
                                    "step"		=> '1',
                                    "max" 		=> '200',
                                    'type' 		=> 'sliderui' );

            $of_options[] = array( 	'name' 		=> '',
                                    'desc' 		=> esc_html__( 'Line Height', 'inverto' ),
                                    'id' 		=> $id . '_line_height',
                                    'std' 		=> $ishinvertotheme_fonts[$id]['line_height'],
                                    "min" 		=> '0',
                                    "step"		=> '1',
                                    "max" 		=> '200',
                                    'type' 		=> 'sliderui' );

	        // BODY FONT ***********************************************************************************************
            $id = 'body_font_2'; // Important!

            $of_options[] = array(  'name' => esc_html__( 'Body Font 2', 'inverto' ),
                                    'desc' => esc_html__( 'Font Type', 'inverto' ),
                                    'id' => $id . '_use_google_font',
                                    'std' => 1,
                                    'on' => 'Google',
                                    'off' => 'Regular',
                                    'folds' => 1,
                                    'type' => 'switch');

            // GOOGLE FONT
            $of_options[] = array( 	'name' => '', //esc_html__( 'Theme Google Font', 'inverto' ),
                                    'desc' => esc_html__( 'Font Family', 'inverto' ),
                                    'id' =>  $id . '_google',
                                    'std' => ('google' == $ishinvertotheme_fonts[$id]['type']) ? $ishinvertotheme_fonts[$id]['name'] : ISHINVERTOTHEME_FONT_1,
                                    'fold' => $id . '_use_google_font',
                                    'type' => 'select_google_font',
                                    'preview' 	=> array(
                                                    'text' => esc_html__( '0123456789 ABCDEFGHIJKLMNOPQRSTUVWXYZ abcdefghijklmnopqrstuvwxyz', 'inverto' ), //this is the text from preview box
                                                    'size' => '16px' //this is the text size from preview box
                                    ),
                                    'options' 	=> $ish_googleFontsArray);

            // REGULAR FONT
            $of_options[] = array(  'name' => '', //esc_html__( 'Theme Regular Font', 'inverto' ),
                                    'desc' =>  esc_html__( 'Font Family', 'inverto' ),
                                    'id' => $id . '_regular',
                                    'std' => ('regular' == $ishinvertotheme_fonts[$id]['type']) ? $ishinvertotheme_fonts[$id]['name'] : 'helvetica',
                                    'fold' => 'off_' . $id . '_use_google_font',
                                    'type' => 'select',
                                    'options' 	=> $ish_regular_fonts);

            // HEADER FONT *********************************************************************************************
	        $id = 'header_font'; // Important!

            $of_options[] = array(  'name' => esc_html__( 'Header Font', 'inverto' ),
                                    'desc' => esc_html__( 'Font Type', 'inverto' ),
                                    'id' => $id . '_use_google_font',
                                    'std' => 1,
                                    'on' => 'Google',
                                    'off' => 'Regular',
                                    'folds' => 1,
                                    'type' => 'switch');
            // GOOGLE FONT
            $of_options[] = array( 	'name' => '', //esc_html__( 'Theme Google Font', 'inverto' ),
                                    'desc' => esc_html__( 'Font Family', 'inverto' ),
                                    'id' =>  $id . '_google',
                                    'std' => ('google' == $ishinvertotheme_fonts[$id]['type']) ? $ishinvertotheme_fonts[$id]['name'] : ISHINVERTOTHEME_FONT_1,
                                    'fold' => $id . '_use_google_font',
                                    'type' => 'select_google_font',
                                    'preview' 	=> array(
                                                    'text' => esc_html__( 'Google font preview!', 'inverto' ), //this is the text from preview box
                                                    'size' => '30px' //this is the text size from preview box
                                    ),
                                    'options' 	=> $ish_googleFontsArray);

            $of_options[] = array(  'name' => '', //esc_html__( 'Font Variant', 'inverto' ),
                                    'desc' =>  esc_html__( 'Font Variant', 'inverto' ),
                                    'id' => $id . '_google_variant',
                                    'std' => ('google' == $ishinvertotheme_fonts[$id]['type']) ? $ishinvertotheme_fonts[$id]['variant'] : '300',
                                    'fold' => $id . '_use_google_font',
                                    'type' => 'select',
                                    'options' 	=> ishinvertotheme_google_variants( ('google' == $ish_saved_fonts[$id]['type']) ? $ish_saved_fonts[$id]['name'] : ( ('google' == $ishinvertotheme_fonts[$id]['type']) ? $ishinvertotheme_fonts[$id]['name'] : ISHINVERTOTHEME_FONT_1 ) ) );

            // REGULAR FONT
            $of_options[] = array(  'name' => '', //esc_html__( 'Theme Regular Font', 'inverto' ),
                                    'desc' =>  esc_html__( 'Font Family', 'inverto' ),
                                    'id' => $id . '_regular',
                                    'std' => ('regular' == $ishinvertotheme_fonts[$id]['type']) ? $ishinvertotheme_fonts[$id]['name'] : 'helvetica',
                                    'fold' => 'off_' . $id . '_use_google_font',
                                    'type' => 'select',
                                    'options' 	=> $ish_regular_fonts);

            $of_options[] = array(  'name' => '', //esc_html__( 'Font Variant', 'inverto' ),
                                    'desc' =>  esc_html__( 'Font Variant', 'inverto' ),
                                    'id' => $id . '_regular_variant',
                                    'std' => ('regular' == $ishinvertotheme_fonts[$id]['type']) ? $ishinvertotheme_fonts[$id]['name'] : 'normal',
                                    'fold' => 'off_' . $id . '_use_google_font',
                                    'type' => 'select',
                                    'options' 	=> $ish_regular_variants);

            // OTHER SETTINGS
            $of_options[] = array( 	'name' 		=> '',
                                    'desc' 		=> esc_html__( 'Font Size', 'inverto' ),
                                    'id' 		=> $id . '_size',
                                    'std' 		=> $ishinvertotheme_fonts[$id]['size'],
                                    "min" 		=> '0',
                                    "step"		=> '1',
                                    "max" 		=> '200',
                                    'type' 		=> 'sliderui' );

            $of_options[] = array( 	'name' 		=> '',
                                    'desc' 		=> esc_html__( 'Line Height', 'inverto' ),
                                    'id' 		=> $id . '_line_height',
                                    'std' 		=> $ishinvertotheme_fonts[$id]['line_height'],
                                    "min" 		=> '0',
                                    "step"		=> '1',
                                    "max" 		=> '200',
                                    'type' 		=> 'sliderui' );

	        // H1 FONT *************************************************************************************************
            $id = 'h1_font'; // Important!

            $of_options[] = array(  'name' => esc_html__( 'H1', 'inverto' ),
                                    'desc' => esc_html__( 'Font Type', 'inverto' ),
                                    'id' => $id . '_use_google_font',
                                    'std' => 1,
                                    'on' => 'Google',
                                    'off' => 'Regular',
                                    'folds' => 1,
                                    'type' => 'switch');

            // GOOGLE FONT
            $of_options[] = array( 	'name' => '', //esc_html__( 'Theme Google Font', 'inverto' ),
                                    'desc' => esc_html__( 'Font Family', 'inverto' ),
                                    'id' =>  $id . '_google',
                                    'std' => ('google' == $ishinvertotheme_fonts[$id]['type']) ? $ishinvertotheme_fonts[$id]['name'] : ISHINVERTOTHEME_FONT_1,
                                    'fold' => $id . '_use_google_font',
                                    'type' => 'select_google_font',
                                    'preview' 	=> array(
                                                    'text' => esc_html__( 'Google font preview!', 'inverto' ), //this is the text from preview box
                                                    'size' => '30px' //this is the text size from preview box
                                    ),
                                    'options' 	=> $ish_googleFontsArray);

            $of_options[] = array(  'name' => '', //esc_html__( 'Font Variant', 'inverto' ),
                                    'desc' =>  esc_html__( 'Font Variant', 'inverto' ),
                                    'id' => $id . '_google_variant',
                                    'std' => ('google' == $ishinvertotheme_fonts[$id]['type']) ? $ishinvertotheme_fonts[$id]['variant'] : '300',
                                    'fold' => $id . '_use_google_font',
                                    'type' => 'select',
                                    'options' 	=> ishinvertotheme_google_variants( ('google' == $ish_saved_fonts[$id]['type']) ? $ish_saved_fonts[$id]['name'] : ( ('google' == $ishinvertotheme_fonts[$id]['type']) ? $ishinvertotheme_fonts[$id]['name'] : ISHINVERTOTHEME_FONT_1 ) ) );

            // REGULAR FONT
            $of_options[] = array(  'name' => '', //esc_html__( 'Theme Regular Font', 'inverto' ),
                                    'desc' =>  esc_html__( 'Font Family', 'inverto' ),
                                    'id' => $id . '_regular',
                                    'std' => ('regular' == $ishinvertotheme_fonts[$id]['type']) ? $ishinvertotheme_fonts[$id]['name'] : 'helvetica',
                                    'fold' => 'off_' . $id . '_use_google_font',
                                    'type' => 'select',
                                    'options' 	=> $ish_regular_fonts);

            $of_options[] = array(  'name' => '', //esc_html__( 'Font Variant', 'inverto' ),
                                    'desc' =>  esc_html__( 'Font Variant', 'inverto' ),
                                    'id' => $id . '_regular_variant',
                                    'std' => ('regular' == $ishinvertotheme_fonts[$id]['type']) ? $ishinvertotheme_fonts[$id]['name'] : 'normal',
                                    'fold' => 'off_' . $id . '_use_google_font',
                                    'type' => 'select',
                                    'options' 	=> $ish_regular_variants);

            // OTHER SETTINGS
            $of_options[] = array( 	'name' 		=> '',
                                    'desc' 		=> esc_html__( 'Font Size', 'inverto' ),
                                    'id' 		=> $id . '_size',
                                    'std' 		=> $ishinvertotheme_fonts[$id]['size'],
                                    "min" 		=> '0',
                                    "step"		=> '1',
                                    "max" 		=> '200',
                                    'type' 		=> 'sliderui' );

            $of_options[] = array( 	'name' 		=> '',
                                    'desc' 		=> esc_html__( 'Line Height', 'inverto' ),
                                    'id' 		=> $id . '_line_height',
                                    'std' 		=> $ishinvertotheme_fonts[$id]['line_height'],
                                    "min" 		=> '0',
                                    "step"		=> '1',
                                    "max" 		=> '200',
                                    'type' 		=> 'sliderui' );

	        // H2 FONT *************************************************************************************************
            $id = 'h2_font'; // Important!

            $of_options[] = array(  'name' => esc_html__( 'H2', 'inverto' ),
                                    'desc' => esc_html__( 'Font Type', 'inverto' ),
                                    'id' => $id . '_use_google_font',
                                    'std' => 1,
                                    'on' => 'Google',
                                    'off' => 'Regular',
                                    'folds' => 1,
                                    'type' => 'switch');

            // GOOGLE FONT
            $of_options[] = array( 	'name' => '', //esc_html__( 'Theme Google Font', 'inverto' ),
                                    'desc' => esc_html__( 'Font Family', 'inverto' ),
                                    'id' =>  $id . '_google',
                                    'std' => ('google' == $ishinvertotheme_fonts[$id]['type']) ? $ishinvertotheme_fonts[$id]['name'] : ISHINVERTOTHEME_FONT_1,
                                    'fold' => $id . '_use_google_font',
                                    'type' => 'select_google_font',
                                    'preview' 	=> array(
                                                    'text' => esc_html__( 'Google font preview!', 'inverto' ), //this is the text from preview box
                                                    'size' => '30px' //this is the text size from preview box
                                    ),
                                    'options' 	=> $ish_googleFontsArray);

            $of_options[] = array(  'name' => '', //esc_html__( 'Font Variant', 'inverto' ),
                                    'desc' =>  esc_html__( 'Font Variant', 'inverto' ),
                                    'id' => $id . '_google_variant',
                                    'std' => ('google' == $ishinvertotheme_fonts[$id]['type']) ? $ishinvertotheme_fonts[$id]['variant'] : '300',
                                    'fold' => $id . '_use_google_font',
                                    'type' => 'select',
                                    'options' 	=> ishinvertotheme_google_variants( ('google' == $ish_saved_fonts[$id]['type']) ? $ish_saved_fonts[$id]['name'] : ( ('google' == $ishinvertotheme_fonts[$id]['type']) ? $ishinvertotheme_fonts[$id]['name'] : ISHINVERTOTHEME_FONT_1 ) ) );

            // REGULAR FONT
            $of_options[] = array(  'name' => '', //esc_html__( 'Theme Regular Font', 'inverto' ),
                                    'desc' =>  esc_html__( 'Font Family', 'inverto' ),
                                    'id' => $id . '_regular',
                                    'std' => ('regular' == $ishinvertotheme_fonts[$id]['type']) ? $ishinvertotheme_fonts[$id]['name'] : 'helvetica',
                                    'fold' => 'off_' . $id . '_use_google_font',
                                    'type' => 'select',
                                    'options' 	=> $ish_regular_fonts);

            $of_options[] = array(  'name' => '', //esc_html__( 'Font Variant', 'inverto' ),
                                    'desc' =>  esc_html__( 'Font Variant', 'inverto' ),
                                    'id' => $id . '_regular_variant',
                                    'std' => ('regular' == $ishinvertotheme_fonts[$id]['type']) ? $ishinvertotheme_fonts[$id]['name'] : 'normal',
                                    'fold' => 'off_' . $id . '_use_google_font',
                                    'type' => 'select',
                                    'options' 	=> $ish_regular_variants);

            // OTHER SETTINGS
            $of_options[] = array( 	'name' 		=> '',
                                    'desc' 		=> esc_html__( 'Font Size', 'inverto' ),
                                    'id' 		=> $id . '_size',
                                    'std' 		=> $ishinvertotheme_fonts[$id]['size'],
                                    "min" 		=> '0',
                                    "step"		=> '1',
                                    "max" 		=> '200',
                                    'type' 		=> 'sliderui' );

            $of_options[] = array( 	'name' 		=> '',
                                    'desc' 		=> esc_html__( 'Line Height', 'inverto' ),
                                    'id' 		=> $id . '_line_height',
                                    'std' 		=> $ishinvertotheme_fonts[$id]['line_height'],
                                    "min" 		=> '0',
                                    "step"		=> '1',
                                    "max" 		=> '200',
                                    'type' 		=> 'sliderui' );

	         // H3 FONT ************************************************************************************************
            $id = 'h3_font'; // Important!

            $of_options[] = array(  'name' => esc_html__( 'H3', 'inverto' ),
                                    'desc' => esc_html__( 'Font Type', 'inverto' ),
                                    'id' => $id . '_use_google_font',
                                    'std' => 1,
                                    'on' => 'Google',
                                    'off' => 'Regular',
                                    'folds' => 1,
                                    'type' => 'switch');

            // GOOGLE FONT
            $of_options[] = array( 	'name' => '', //esc_html__( 'Theme Google Font', 'inverto' ),
                                    'desc' => esc_html__( 'Font Family', 'inverto' ),
                                    'id' =>  $id . '_google',
                                    'std' => ('google' == $ishinvertotheme_fonts[$id]['type']) ? $ishinvertotheme_fonts[$id]['name'] : ISHINVERTOTHEME_FONT_1,
                                    'fold' => $id . '_use_google_font',
                                    'type' => 'select_google_font',
                                    'preview' 	=> array(
                                                    'text' => esc_html__( 'Google font preview!', 'inverto' ), //this is the text from preview box
                                                    'size' => '30px' //this is the text size from preview box
                                    ),
                                    'options' 	=> $ish_googleFontsArray);

            $of_options[] = array(  'name' => '', //esc_html__( 'Font Variant', 'inverto' ),
                                    'desc' =>  esc_html__( 'Font Variant', 'inverto' ),
                                    'id' => $id . '_google_variant',
                                    'std' => ('google' == $ishinvertotheme_fonts[$id]['type']) ? $ishinvertotheme_fonts[$id]['variant'] : '400',
                                    'fold' => $id . '_use_google_font',
                                    'type' => 'select',
                                    'options' 	=> ishinvertotheme_google_variants( ('google' == $ish_saved_fonts[$id]['type']) ? $ish_saved_fonts[$id]['name'] : ( ('google' == $ishinvertotheme_fonts[$id]['type']) ? $ishinvertotheme_fonts[$id]['name'] : ISHINVERTOTHEME_FONT_1 ) ) );

            // REGULAR FONT
            $of_options[] = array(  'name' => '', //esc_html__( 'Theme Regular Font', 'inverto' ),
                                    'desc' =>  esc_html__( 'Font Family', 'inverto' ),
                                    'id' => $id . '_regular',
                                    'std' => ('regular' == $ishinvertotheme_fonts[$id]['type']) ? $ishinvertotheme_fonts[$id]['name'] : 'helvetica',
                                    'fold' => 'off_' . $id . '_use_google_font',
                                    'type' => 'select',
                                    'options' 	=> $ish_regular_fonts);

            $of_options[] = array(  'name' => '', //esc_html__( 'Font Variant', 'inverto' ),
                                    'desc' =>  esc_html__( 'Font Variant', 'inverto' ),
                                    'id' => $id . '_regular_variant',
                                    'std' => ('regular' == $ishinvertotheme_fonts[$id]['type']) ? $ishinvertotheme_fonts[$id]['name'] : 'normal',
                                    'fold' => 'off_' . $id . '_use_google_font',
                                    'type' => 'select',
                                    'options' 	=> $ish_regular_variants);

            // OTHER SETTINGS
            $of_options[] = array( 	'name' 		=> '',
                                    'desc' 		=> esc_html__( 'Font Size', 'inverto' ),
                                    'id' 		=> $id . '_size',
                                    'std' 		=> $ishinvertotheme_fonts[$id]['size'],
                                    "min" 		=> '0',
                                    "step"		=> '1',
                                    "max" 		=> '200',
                                    'type' 		=> 'sliderui' );

            $of_options[] = array( 	'name' 		=> '',
                                    'desc' 		=> esc_html__( 'Line Height', 'inverto' ),
                                    'id' 		=> $id . '_line_height',
                                    'std' 		=> $ishinvertotheme_fonts[$id]['line_height'],
                                    "min" 		=> '0',
                                    "step"		=> '1',
                                    "max" 		=> '200',
                                    'type' 		=> 'sliderui' );

            // H4 FONT *************************************************************************************************
	        $id = 'h4_font'; // Important!

            $of_options[] = array(  'name' => esc_html__( 'H4', 'inverto' ),
                                    'desc' => esc_html__( 'Font Type', 'inverto' ),
                                    'id' => $id . '_use_google_font',
                                    'std' => 1,
                                    'on' => 'Google',
                                    'off' => 'Regular',
                                    'folds' => 1,
                                    'type' => 'switch');

            // GOOGLE FONT
            $of_options[] = array( 	'name' => '', //esc_html__( 'Theme Google Font', 'inverto' ),
                                    'desc' => esc_html__( 'Font Family', 'inverto' ),
                                    'id' =>  $id . '_google',
                                    'std' => ('google' == $ishinvertotheme_fonts[$id]['type']) ? $ishinvertotheme_fonts[$id]['name'] : ISHINVERTOTHEME_FONT_1,
                                    'fold' => $id . '_use_google_font',
                                    'type' => 'select_google_font',
                                    'preview' 	=> array(
                                                    'text' => esc_html__( 'Google font preview!', 'inverto' ), //this is the text from preview box
                                                    'size' => '30px' //this is the text size from preview box
                                    ),
                                    'options' 	=> $ish_googleFontsArray);

            $of_options[] = array(  'name' => '', //esc_html__( 'Font Variant', 'inverto' ),
                                    'desc' =>  esc_html__( 'Font Variant', 'inverto' ),
                                    'id' => $id . '_google_variant',
                                    'std' => ('google' == $ishinvertotheme_fonts[$id]['type']) ? $ishinvertotheme_fonts[$id]['variant'] : '400',
                                    'fold' => $id . '_use_google_font',
                                    'type' => 'select',
                                    'options' 	=> ishinvertotheme_google_variants( ('google' == $ish_saved_fonts[$id]['type']) ? $ish_saved_fonts[$id]['name'] : ( ('google' == $ishinvertotheme_fonts[$id]['type']) ? $ishinvertotheme_fonts[$id]['name'] : ISHINVERTOTHEME_FONT_1 ) ) );

            // REGULAR FONT
            $of_options[] = array(  'name' => '', //esc_html__( 'Theme Regular Font', 'inverto' ),
                                    'desc' =>  esc_html__( 'Font Family', 'inverto' ),
                                    'id' => $id . '_regular',
                                    'std' => ('regular' == $ishinvertotheme_fonts[$id]['type']) ? $ishinvertotheme_fonts[$id]['name'] : 'helvetica',
                                    'fold' => 'off_' . $id . '_use_google_font',
                                    'type' => 'select',
                                    'options' 	=> $ish_regular_fonts);

            $of_options[] = array(  'name' => '', //esc_html__( 'Font Variant', 'inverto' ),
                                    'desc' =>  esc_html__( 'Font Variant', 'inverto' ),
                                    'id' => $id . '_regular_variant',
                                    'std' => ('regular' == $ishinvertotheme_fonts[$id]['type']) ? $ishinvertotheme_fonts[$id]['name'] : 'normal',
                                    'fold' => 'off_' . $id . '_use_google_font',
                                    'type' => 'select',
                                    'options' 	=> $ish_regular_variants);

            // OTHER SETTINGS
            $of_options[] = array( 	'name' 		=> '',
                                    'desc' 		=> esc_html__( 'Font Size', 'inverto' ),
                                    'id' 		=> $id . '_size',
                                    'std' 		=> $ishinvertotheme_fonts[$id]['size'],
                                    "min" 		=> '0',
                                    "step"		=> '1',
                                    "max" 		=> '200',
                                    'type' 		=> 'sliderui' );

            $of_options[] = array( 	'name' 		=> '',
                                    'desc' 		=> esc_html__( 'Line Height', 'inverto' ),
                                    'id' 		=> $id . '_line_height',
                                    'std' 		=> $ishinvertotheme_fonts[$id]['line_height'],
                                    "min" 		=> '0',
                                    "step"		=> '1',
                                    "max" 		=> '200',
                                    'type' 		=> 'sliderui' );

	        // H5 FONT *************************************************************************************************
            $id = 'h5_font'; // Important!

            $of_options[] = array(  'name' => esc_html__( 'H5', 'inverto' ),
                                    'desc' => esc_html__( 'Font Type', 'inverto' ),
                                    'id' => $id . '_use_google_font',
                                    'std' => 1,
                                    'on' => 'Google',
                                    'off' => 'Regular',
                                    'folds' => 1,
                                    'type' => 'switch');

            // GOOGLE FONT
            $of_options[] = array( 	'name' => '', //esc_html__( 'Theme Google Font', 'inverto' ),
                                    'desc' => esc_html__( 'Font Family', 'inverto' ),
                                    'id' =>  $id . '_google',
                                    'std' => ('google' == $ishinvertotheme_fonts[$id]['type']) ? $ishinvertotheme_fonts[$id]['name'] : ISHINVERTOTHEME_FONT_1,
                                    'fold' => $id . '_use_google_font',
                                    'type' => 'select_google_font',
                                    'preview' 	=> array(
                                                    'text' => esc_html__( 'Google font preview!', 'inverto' ), //this is the text from preview box
                                                    'size' => '30px' //this is the text size from preview box
                                    ),
                                    'options' 	=> $ish_googleFontsArray);

            $of_options[] = array(  'name' => '', //esc_html__( 'Font Variant', 'inverto' ),
                                    'desc' =>  esc_html__( 'Font Variant', 'inverto' ),
                                    'id' => $id . '_google_variant',
                                    'std' => ('google' == $ishinvertotheme_fonts[$id]['type']) ? $ishinvertotheme_fonts[$id]['variant'] : '400',
                                    'fold' => $id . '_use_google_font',
                                    'type' => 'select',
                                    'options' 	=> ishinvertotheme_google_variants( ('google' == $ish_saved_fonts[$id]['type']) ? $ish_saved_fonts[$id]['name'] : ( ('google' == $ishinvertotheme_fonts[$id]['type']) ? $ishinvertotheme_fonts[$id]['name'] : ISHINVERTOTHEME_FONT_1 ) ) );

            // REGULAR FONT
            $of_options[] = array(  'name' => '', //esc_html__( 'Theme Regular Font', 'inverto' ),
                                    'desc' =>  esc_html__( 'Font Family', 'inverto' ),
                                    'id' => $id . '_regular',
                                    'std' => ('regular' == $ishinvertotheme_fonts[$id]['type']) ? $ishinvertotheme_fonts[$id]['name'] : 'helvetica',
                                    'fold' => 'off_' . $id . '_use_google_font',
                                    'type' => 'select',
                                    'options' 	=> $ish_regular_fonts);

            $of_options[] = array(  'name' => '', //esc_html__( 'Font Variant', 'inverto' ),
                                    'desc' =>  esc_html__( 'Font Variant', 'inverto' ),
                                    'id' => $id . '_regular_variant',
                                    'std' => ('regular' == $ishinvertotheme_fonts[$id]['type']) ? $ishinvertotheme_fonts[$id]['name'] : 'normal',
                                    'fold' => 'off_' . $id . '_use_google_font',
                                    'type' => 'select',
                                    'options' 	=> $ish_regular_variants);

            // OTHER SETTINGS
            $of_options[] = array( 	'name' 		=> '',
                                    'desc' 		=> esc_html__( 'Font Size', 'inverto' ),
                                    'id' 		=> $id . '_size',
                                    'std' 		=> $ishinvertotheme_fonts[$id]['size'],
                                    "min" 		=> '0',
                                    "step"		=> '1',
                                    "max" 		=> '200',
                                    'type' 		=> 'sliderui' );

            $of_options[] = array( 	'name' 		=> '',
                                    'desc' 		=> esc_html__( 'Line Height', 'inverto' ),
                                    'id' 		=> $id . '_line_height',
                                    'std' 		=> $ishinvertotheme_fonts[$id]['line_height'],
                                    "min" 		=> '0',
                                    "step"		=> '1',
                                    "max" 		=> '200',
                                    'type' 		=> 'sliderui' );

	        // H6 FONT *************************************************************************************************
            $id = 'h6_font'; // Important!

            $of_options[] = array(  'name' => esc_html__( 'H6', 'inverto' ),
                                    'desc' => esc_html__( 'Font Type', 'inverto' ),
                                    'id' => $id . '_use_google_font',
                                    'std' => 1,
                                    'on' => 'Google',
                                    'off' => 'Regular',
                                    'folds' => 1,
                                    'type' => 'switch');

            // GOOGLE FONT
            $of_options[] = array( 	'name' => '', //esc_html__( 'Theme Google Font', 'inverto' ),
                                    'desc' => esc_html__( 'Font Family', 'inverto' ),
                                    'id' =>  $id . '_google',
                                    'std' => ('google' == $ishinvertotheme_fonts[$id]['type']) ? $ishinvertotheme_fonts[$id]['name'] : ISHINVERTOTHEME_FONT_1,
                                    'fold' => $id . '_use_google_font',
                                    'type' => 'select_google_font',
                                    'preview' 	=> array(
                                                    'text' => esc_html__( 'Google font preview!', 'inverto' ), //this is the text from preview box
                                                    'size' => '30px' //this is the text size from preview box
                                    ),
                                    'options' 	=> $ish_googleFontsArray);

            $of_options[] = array(  'name' => '', //esc_html__( 'Font Variant', 'inverto' ),
                                    'desc' =>  esc_html__( 'Font Variant', 'inverto' ),
                                    'id' => $id . '_google_variant',
                                    'std' => ('google' == $ishinvertotheme_fonts[$id]['type']) ? $ishinvertotheme_fonts[$id]['variant'] : '400',
                                    'fold' => $id . '_use_google_font',
                                    'type' => 'select',
                                    'options' 	=> ishinvertotheme_google_variants( ('google' == $ish_saved_fonts[$id]['type']) ? $ish_saved_fonts[$id]['name'] : ( ('google' == $ishinvertotheme_fonts[$id]['type']) ? $ishinvertotheme_fonts[$id]['name'] : ISHINVERTOTHEME_FONT_1 ) ) );

            // REGULAR FONT
            $of_options[] = array(  'name' => '', //esc_html__( 'Theme Regular Font', 'inverto' ),
                                    'desc' =>  esc_html__( 'Font Family', 'inverto' ),
                                    'id' => $id . '_regular',
                                    'std' => ('regular' == $ishinvertotheme_fonts[$id]['type']) ? $ishinvertotheme_fonts[$id]['name'] : 'helvetica',
                                    'fold' => 'off_' . $id . '_use_google_font',
                                    'type' => 'select',
                                    'options' 	=> $ish_regular_fonts);

            $of_options[] = array(  'name' => '', //esc_html__( 'Font Variant', 'inverto' ),
                                    'desc' =>  esc_html__( 'Font Variant', 'inverto' ),
                                    'id' => $id . '_regular_variant',
                                    'std' => ('regular' == $ishinvertotheme_fonts[$id]['type']) ? $ishinvertotheme_fonts[$id]['name'] : 'normal',
                                    'fold' => 'off_' . $id . '_use_google_font',
                                    'type' => 'select',
                                    'options' 	=> $ish_regular_variants);

            // OTHER SETTINGS
            $of_options[] = array( 	'name' 		=> '',
                                    'desc' 		=> esc_html__( 'Font Size', 'inverto' ),
                                    'id' 		=> $id . '_size',
                                    'std' 		=> $ishinvertotheme_fonts[$id]['size'],
                                    "min" 		=> '0',
                                    "step"		=> '1',
                                    "max" 		=> '200',
                                    'type' 		=> 'sliderui' );

            $of_options[] = array( 	'name' 		=> '',
                                    'desc' 		=> esc_html__( 'Line Height', 'inverto' ),
                                    'id' 		=> $id . '_line_height',
                                    'std' 		=> $ishinvertotheme_fonts[$id]['line_height'],
                                    "min" 		=> '0',
                                    "step"		=> '1',
                                    "max" 		=> '200',
                                    'type' 		=> 'sliderui' );

	    do_action( 'ish_theme_options_after_styling_options' );
	    do_action( 'ish_theme_options_before_woocommerce_options' );

        /* *************************************************************************************************************
         * 7. Woocommerce Settings
         */
        if (ishinvertotheme_woocommerce_plugin_active()){
            $of_options[] = array(  'name' => esc_html__( 'Woocommerce', 'inverto' ),
                                    'class' => 'woocommerce',
                                    'type' => 'heading');

	            // WOOCOMMERCE SIDEBAR *********************************************************************************
                $of_options[] = array(  'name' => esc_html__( 'Woocommerce Sidebar', 'inverto' ),
                                        'desc' => esc_html__( "Display the sidebar on each woocommerce page by default. This settings can be overridden in each page's settings.", 'inverto' ),
                                        'id' => 'show_woocommerce_sidebar',
                                        'std' => 0,
                                        'folds' => 1,
                                        'type' => 'switch');

                $of_options[] = array(  'name' => '', //'name' => esc_html__( 'Woocommerce Sidebar position', 'inverto' ),
                                        'desc'  => esc_html__( 'Choose whether to display the sidebar on the left or on the right side of woocommerce pages.', 'inverto' ),
                                        'id'    => 'woocommerce_sidebar_position',
                                        'std'   => 'right',
                                        'fold'  => 'show_woocommerce_sidebar',
                                        'type'  => 'select',
                                        'options' => array('left' => 'Left', 'right' => 'Right'));

                $of_options[] = array(  'name' => '', //'name' => esc_html__( 'Woocommerce Sidebar', 'inverto' ),
                                        'desc' => esc_html__( 'Select which sidebar will be displayed on each woocommerce page by default.', 'inverto' ),
                                        'id' => 'woocommerce_sidebar',
                                        'std' => 'sidebar-woocommerce',
                                        'fold' => 'show_woocommerce_sidebar',
                                        'type' => 'select',
                                        'options' => $of_sidebars);

	            // PRODUCTS PER PAGE ***********************************************************************************
                $of_options[] = array(  'name' => esc_html__( 'Products per Page', 'inverto' ),
                                        'desc' => esc_html__( 'Number of products displayed per page. To see all items set the value to "-1"', 'inverto' ),
                                        'id' => 'woocommerce_posts_per_page',
                                        'std' => '8',
                                        'type' => 'text');



                // PRODUCTS PER ROW ************************************************************************************
                $of_options[] = array(  'name' => esc_html__( 'Products per Row', 'inverto' ),
                                        'desc' => esc_html__( 'Number of products displayed per row (columns count).', 'inverto' ),
                                        'id' => 'woocommerce_posts_per_row',
                                        'std'   => '4',
                                        'type'  => 'select',
                                        'options' => array(
                                            '1' => '1',
                                            '2' => '2',
                                            '3' => '3',
                                            '4' => '4',
                                            '5' => '5',
                                            '6' => '6',
                                            ),
                                        );

                // PRODUCTS DETAIL PAGE ********************************************************************************
                $of_options[] = array(  'name' => esc_html__( 'Product Detail Page - Prev/Next & Sharing', 'inverto' ),
                                        'desc' => esc_html__( 'Choose what to display at the bottom of the Product Detail page.', 'inverto' ),
                                        'id' => 'woocommerce_single_product_details',
                                        'std' => 'nav-social',
                                        'type' => 'select',
                                        'options' => Array(
                                            ''  => esc_html__( 'None', 'inverto'),
                                            'nav'  => esc_html__( 'Prev/Next Navigation', 'inverto'),
                                            'social'  => esc_html__( 'Sharing Icons', 'inverto'),
                                            'nav-social'  => esc_html__( 'Prev/Next Navigation & Sharing Icons', 'inverto'),
                                        ),
                );
        }

	    do_action( 'ish_theme_options_after_woocommerce_options' );
	    do_action( 'ish_theme_options_before_plugins_options' );

        /* *************************************************************************************************************
         * 8. Plugins Options
         */
	    $section_options = Array();
	    $section_heading = Array(
		    array(  'name' => esc_html__( 'Plugins Options' , 'inverto' ),
                                'class' => 'pluginsoptions',
                                'type' => 'heading',
		    ),
	    );

	    // Allow plugins to create options
	    $section_options = apply_filters( 'ish_theme_options_section_content', $section_options, 'pluginsoptions' );

	    if ( count( $section_options ) >= 1 ){
		    $of_options = array_merge( $of_options, $section_heading, $section_options );
	    }

	    do_action( 'ish_theme_options_after_plugins_options' );
	    do_action( 'ish_theme_options_before_backup_options' );

        /* *************************************************************************************************************
         * 9. Backup Options
         */
        $of_options[] = array(  'name' => esc_html__( 'Backup Options' , 'inverto' ),
                                'class' => 'backupoptions',
                                'type' => 'heading');

	        // BACKUP & RESTORE ****************************************************************************************
            $of_options[] = array( 'name' => esc_html__( 'Backup and Restore Options', 'inverto' ),
                                'id' => 'of_backup',
                                'std' => '',
                                'type' => 'backup',
                                'desc' => 'You can use the two buttons below to backup your current options, and then restore it back at a later time. This is useful if you want to experiment on the options but would like to keep the old settings in case you need it back.',
                                );

	        // TRANSFER OPTIONS ****************************************************************************************
            $of_options[] = array( 'name' => esc_html__( 'Transfer Theme Options Data', 'inverto' ),
                                'id' => 'of_transfer',
                                'std' => '',
                                'type' => 'transfer',
                                'desc' => 'You can tranfer the saved options data between different installs by copying the text inside the text box. To import data from another install, replace the data in the text box with the one from another install and click "Import Options".
                                    ',
                                );

	    do_action( 'ish_theme_options_after_backup_options' );
	    do_action( 'ish_theme_options_before_themeupdate_options' );

        /* *************************************************************************************************************
         * 10. Theme Update
         */
		// This section was deprecated. Use Appearance > Theme License to get the latest updates.

		do_action( 'ish_theme_options_after_themeupdate_options' );
	    do_action( 'ish_theme_options_before_demo_import_options' );

        /* *************************************************************************************************************
         * 10. Demo Content
         */
        $of_options[] = array(  'name' => esc_html__( 'Demo Data Import', 'inverto' ),
                                'class' => 'demo_import',
                                'type' => 'heading');

	        // THEME UPDATE ********************************************************************************************
            $of_options[] = array(  'name' => esc_html__( 'Demo Data Import', 'inverto' ),
                                    'desc' => '',
                                    'id' => 'demo_import',
                                    'std' => '',
                                    'type' => 'demo_import');

	    do_action( 'ish_theme_options_after_demo_import_options' );

	}
}