/******/ (function() { // webpackBootstrap
var __webpack_exports__ = {};
/*!***************************!*\
  !*** ./_src/js/global.js ***!
  \***************************/
/* global wphbGlobal */

(function () {
  'use strict';

  var WPHBGlobal = {
    init: function init() {
      this.registerClearAllCache();
      this.registerClearNetworkCache();
      this.registerClearCacheFromNotice();
      this.registerClearCloudflare();
      this.registerSafeModeActions();
    },
    /**
     * Clear selected module from admin bar.
     *
     * @since 3.0.1
     *
     * @param {string} module Module ID.
     */
    clearCache: function clearCache(module) {
      jQuery.ajax({
        url: wphbGlobal.ajaxurl,
        method: 'POST',
        data: {
          nonce: wphbGlobal.nonce,
          action: 'wphb_clear_caches',
          modules: [module]
        }
      }).done(function () {
        location.reload();
      });
    },
    /**
     * Clear all cache from admin bar.
     *
     * @since 3.0.1
     */
    registerClearAllCache: function registerClearAllCache() {
      var _this = this;
      var btn = document.getElementById('wp-admin-bar-wphb-clear-all-cache');
      if (!btn) {
        return;
      }
      btn.addEventListener('click', function () {
        return _this.post('wphb_global_clear_cache');
      });
    },
    /**
     * Clear network cache.
     */
    registerClearNetworkCache: function registerClearNetworkCache() {
      var btn = document.querySelector('#wp-admin-bar-wphb-clear-cache-network-wide > a');
      if (!btn) {
        return;
      }
      btn.addEventListener('click', function () {
        if ('undefined' === typeof window.WPHB_Admin) {
          window.location.href = '/wp-admin/network/admin.php?page=wphb-caching&update=open-ccnw';
          return;
        }
        window.SUI.openModal('ccnw-modal', 'wpbody', 'ccnw-clear-now');
      });
    },
    /**
     * Clear cache from notice regarding plugin/theme updates.
     */
    registerClearCacheFromNotice: function registerClearCacheFromNotice() {
      var _this2 = this;
      var btn = document.getElementById('wp-admin-notice-wphb-clear-cache');
      if (!btn) {
        return;
      }
      btn.addEventListener('click', function () {
        return _this2.post('wphb_global_clear_cache');
      });
    },
    /**
     * Clear Cloudflare browser cache.
     *
     * @since 2.7.2
     */
    registerClearCloudflare: function registerClearCloudflare() {
      var _this3 = this;
      var btn = document.querySelector('#wp-admin-bar-wphb-clear-cloudflare > a');
      if (!btn) {
        return;
      }
      btn.addEventListener('click', function () {
        return _this3.post('wphb_front_clear_cloudflare');
      });
    },
    copyTextToClipboard: function copyTextToClipboard(text) {
      var textArea = document.createElement("textarea");
      textArea.value = text;

      // Avoid scrolling to bottom
      textArea.style.top = "0";
      textArea.style.left = "0";
      textArea.style.position = "fixed";
      document.body.appendChild(textArea);
      textArea.focus();
      textArea.select();
      try {
        document.execCommand('copy');
      } catch (err) {
        console.error('Oops, unable to copy', err);
      }
      document.body.removeChild(textArea);
    },
    /**
     * Regsiter safe mode actions.
     *
     * @since 3.4.0
     */
    registerSafeModeActions: function registerSafeModeActions() {
      var _this4 = this;
      var saveButton = document.getElementById('wphb-ao-safe-mode-save');
      if (saveButton) {
        saveButton.addEventListener('click', function () {
          saveButton.disabled = true;
          _this4.request('wphb_react_minify_publish_safe_mode').then(function () {
            window.location.href = wphbGlobal.minify_url + '&safe_mode_status=published';
          });
        });
      }
      var copyButton = document.getElementById('wphb-ao-safe-mode-copy');
      if (copyButton) {
        copyButton.addEventListener('click', function (e) {
          e.preventDefault();
          _this4.copyTextToClipboard(window.location.href);
          var successClass = 'wphb-ao-safe-mode-copy-success';
          copyButton.classList.add(successClass);
          setTimeout(function () {
            copyButton.classList.remove(successClass);
          }, 3000);
        });
      }
    },
    /**
     * Send AJAX request.
     *
     * @param {string}  action
     * @param {boolean} reload
     */
    post: function post(action) {
      var reload = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : true;
      this.request(action).then(function () {
        if (reload) {
          location.reload(action);
        }
      });
    },
    request: function request(action) {
      return new Promise(function (resolve) {
        var xhr = new XMLHttpRequest();
        xhr.open('POST', wphbGlobal.ajaxurl + '?action=' + action + '&_ajax_nonce=' + wphbGlobal.nonce);
        xhr.onload = function () {
          if (xhr.status === 200) {
            resolve();
          }
        };
        xhr.send();
      });
    }
  };
  document.addEventListener('DOMContentLoaded', function () {
    WPHBGlobal.init();
  });
  window.WPHBGlobal = WPHBGlobal;
})();
/******/ })()
;
//# sourceMappingURL=wphb-global.min.js.map